(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[  23206156,     387757]
NotebookOptionsPosition[  23143608,     386950]
NotebookOutlinePosition[  23144000,     386966]
CellTagsIndexPosition[  23143957,     386963]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilTeX`"}]], "Input",
 CellChangeTimes->{{3.966968271457609*^9, 3.9669682779533978`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"6e54cd13-cd4b-4e52-a869-f30f488dbbd7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilTeX cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
01/10/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"4bcc80ae-1e52-43af-b5d1-c074ae62f114"],

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{3.9669683052359133`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"a54dbc55-a09a-4159-95b5-719e53661849"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{3.966968305236465*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"cf47c7a4-3133-43ee-bbb0-10aacb8aeb39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305236766*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"5a1cfefc-2f7f-40b2-b7dd-d436c1abaf0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305237047*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"1d9ee3a9-e236-4e55-bbfa-514a9055292f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305237317*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"be9d2400-d263-454b-a86a-6f88c826cfbf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305237576*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"e4819fc6-8959-4ab0-b0b0-13af10f8eb00"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["9. ExportToTikZ3D", "Subtitle",
 CellChangeTimes->{{3.964711967446312*^9, 3.9647120331966953`*^9}, {
   3.965828746741377*^9, 3.965828772379876*^9}, {3.966422117997758*^9, 
   3.966422160573628*^9}, {3.9664222257197533`*^9, 3.966422232684371*^9}, 
   3.9664306609167547`*^9, {3.966530326160678*^9, 3.966530345500471*^9}, {
   3.9672191065675383`*^9, 3.967219107131865*^9}},
 Background->RGBColor[
  0.4, 0.6, 1, 0.33],ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ExportToTikZ3D"}]], "Input",
 CellChangeTimes->{{3.967118696721233*^9, 3.967118700444887*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"022f7641-b745-452a-8335-deeb5989347f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportToTikZ3D[plotArgs, filename] exporta gr\
\[AAcute]ficos 3D de Mathematica a c\[OAcute]digo TikZ/PGFPlots para \
LaTeX.\\n\\nExportToTikZ3D[plotArgs, filename, grid, color, samples, \
axisType, colormap, opacity, axisExtension, maxPointsImplicit, \
textAnnotations] exporta con opciones espec\[IAcute]ficas.\\n\\nPAR\
\[CapitalAAcute]METROS REQUERIDOS:\\n- plotArgs: Argumentos del \
gr\[AAcute]fico 3D. Puede ser un gr\[AAcute]fico individual o lista de m\
\[UAcute]ltiples gr\[AAcute]ficos.\\n- filename: String con nombre del \
archivo de salida (debe terminar en '.tex').\\n\\nOPCIONES DISPONIBLES:\\n- \
grid (por defecto: True): Boolean. Controla si se muestra la \
cuadr\[IAcute]cula.\\n  - True: Muestra cuadr\[IAcute]cula\\n  - False: Sin \
cuadr\[IAcute]cula\\n\\n- color (por defecto: 'blue'): String. Color \
principal del gr\[AAcute]fico.\\n  - COLORES B\[CapitalAAcute]SICOS: 'black', \
'blue', 'brown', 'cyan', 'darkgray', 'gray', 'green', 'lightgray', 'lime', \
'magenta', 'olive', 'orange', 'pink', 'purple', 'red', 'teal', 'violet', \
'white', 'yellow'\\n  - COLORES MEZCLADOS: 'blue!50!red', 'green!70!black', \
'red!20!blue!80!green', 'yellow!75!red'\\n  - Para m\[UAcute]ltiples gr\
\[AAcute]ficos se asignan autom\[AAcute]ticamente: 'blue', 'red', \
'green!70!black', 'orange', 'purple', 'brown', 'pink', 'gray', 'cyan', \
'magenta'\\n\\n- samples (por defecto: 30): Integer. N\[UAcute]mero de \
muestras para generar superficies.\\n  - Rango recomendado: 10-100\\n  - \
Valores altos = mayor resoluci\[OAcute]n pero archivos m\[AAcute]s grandes\\n \
 - Se ajusta autom\[AAcute]ticamente para m\[UAcute]ltiples \
gr\[AAcute]ficos\\n\\n- axisType (por defecto: 'box'): String. Estilo de los \
ejes.\\n  - 'box': Ejes en forma de caja completa\\n  - 'center': Ejes \
centrados con flechas\\n  - 'none': Sin ejes visibles\\n\\n- colormap (por \
defecto: 'viridis'): String. Mapa de colores para superficies con gradientes.\
\\n  - COLORMAPS DISPONIBLES (exactamente estos):\\n    * 'viridis': \
Verde-azul-violeta (perceptualmente uniforme, recomendado para datos cient\
\[IAcute]ficos)\\n    * 'cool': Cian a magenta (bueno para datos que van de \
fr\[IAcute]o a caliente)\\n    * 'hot': Negro-rojo-amarillo-blanco (cl\
\[AAcute]sico mapa de calor)\\n    * 'jet': Azul-cian-amarillo-rojo (colorido \
pero no perceptualmente uniforme)\\n    * 'hsv': Espectro completo HSV \
circular\\n    * 'spring': Magenta-amarillo (tonos primaverales)\\n    * \
'summer': Verde-amarillo (tonos veraniegos)\\n    * 'autumn': Rojo-amarillo \
(tonos oto\[NTilde]ales)\\n    * 'winter': Azul-verde (tonos invernales)\\n   \
 * 'gray': Escala de grises (negro a blanco)\\n    * 'blackwhite': Alias para \
escala de grises\\n\\n- opacity (por defecto: 1.0): Real entre 0.0 y 1.0. \
Transparencia del gr\[AAcute]fico.\\n  - 1.0 = completamente opaco\\n  - 0.0 \
= completamente transparente\\n  - Valores intermedios: 0.1 (muy \
transparente), 0.3 (transparente), 0.5 (semi-transparente), 0.7 (poco \
transparente), 0.9 (casi opaco)\\n\\n- axisExtension (por defecto: 0.0): Real \
\[GreaterEqual] 0.0. Extensi\[OAcute]n adicional de l\[IAcute]mites de \
ejes.\\n  - Fracci\[OAcute]n del rango de datos\\n  - Solo efectivo con \
axisType -> 'center'\\n  - Ejemplo: 0.1 extiende ejes 10% m\[AAcute]s all\
\[AAcute] de los datos\\n\\n- maxPointsImplicit (por defecto: 8000): Integer \
\[GreaterEqual] 100. M\[AAcute]ximo n\[UAcute]mero de puntos para superficies \
impl\[IAcute]citas.\\n  - Controla balance entre calidad y rendimiento\\n  - \
Se distribuye autom\[AAcute]ticamente entre m\[UAcute]ltiples \
gr\[AAcute]ficos\\n\\n- textAnnotations (por defecto: {}): List. Anotaciones \
de texto en el gr\[AAcute]fico.\\n  - Formato: {{'texto', {x, y, z}}, \
{'texto', {x, y, z}, opciones}, ...}\\n  - Cada anotaci\[OAcute]n: {'string', \
{coordenadas 3D}, opciones (opcional)}\\n  - Opciones de formato disponibles:\
\\n    * {'color', 'red'}: Color del texto (acepta todos los colores listados \
arriba)\\n    * {'size', '\\\\large'}: Tama\[NTilde]o del texto\\n      - \
Tama\[NTilde]os LaTeX: '\\\\tiny', '\\\\scriptsize', '\\\\footnotesize', \
'\\\\small', '\\\\normalsize', '\\\\large', '\\\\Large', '\\\\huge', \
'\\\\Huge'\\n    * {'anchor', 'north'}: Anclaje del texto\\n      - Opciones: \
'north', 'south', 'east', 'west', 'north east', 'north west', 'south east', \
'south west', 'center'\\n    * {'rotate', '45'}: Rotaci\[OAcute]n en grados \
(0-360)\\n\\nTIPOS DE GR\[CapitalAAcute]FICOS SOPORTADOS:\\n1. Plot3D: {funci\
\[OAcute]n, {x, xmin, xmax}, {y, ymin, ymax}}\\n2. ParametricPlot3D (curva): \
{{x[t], y[t], z[t]}, {t, tmin, tmax}}\\n3. ParametricPlot3D (superficie): \
{{x[u,v], y[u,v], z[u,v]}, {u, umin, umax}, {v, vmin, vmax}}\\n4. \
ContourPlot3D: {ecuaci\[OAcute]n == 0, {x, xmin, xmax}, {y, ymin, ymax}, {z, \
zmin, zmax}}\\n5. M\[UAcute]ltiples gr\[AAcute]ficos: Lista de cualquiera de \
los tipos anteriores (Show)\\n\\nVALOR DE RETORNO:\\nString con la ruta \
completa del archivo .tex generado, o $Failed si hay error.\\n\\nEJEMPLOS DE \
COLORES Y COLORMAPS:\\n- ExportToTikZ3D[{x^2 + y^2, {x, -2, 2}, {y, -2, 2}}, \
'plot1.tex', color -> 'RoyalBlue']\\n- ExportToTikZ3D[{x^2 + y^2, {x, -2, 2}, \
{y, -2, 2}}, 'plot2.tex', color -> 'green!70!black', colormap -> 'hot']\\n- \
ExportToTikZ3D[{x^2 + y^2, {x, -2, 2}, {y, -2, 2}}, 'plot3.tex', color -> \
'RGB{255,100,50}', colormap -> 'viridis']\\n- ExportToTikZ3D[{x^2 + y^2, {x, \
-2, 2}, {y, -2, 2}}, 'plot4.tex', color -> 'HTML{FF6B35}', colormap -> \
'cool', opacity -> 0.7]\\n\\nOTROS EJEMPLOS:\\n- ExportToTikZ3D[{x^2 + y^2, \
{x, -2, 2}, {y, -2, 2}}, 'paraboloid.tex']\\n- ExportToTikZ3D[{x^2 + y^2, {x, \
-2, 2}, {y, -2, 2}}, 'plot.tex', True, 'red', 40, 'center', 'hot', 0.8, 0.1, \
5000, {}]\\n- ExportToTikZ3D[{{Cos[t], Sin[t], t/2}, {t, 0, 4Pi}}, \
'helix.tex', grid -> False, color -> 'green!70!black']\\n- \
ExportToTikZ3D[{x^2 + y^2 + z^2 == 4, {x, -2, 2}, {y, -2, 2}, {z, -2, 2}}, \
'sphere.tex', maxPointsImplicit -> 10000, colormap -> 'jet']\\n- \
ExportToTikZ3D[{x^2 + y^2, {x, -2, 2}, {y, -2, 2}}, 'annotated.tex', \
textAnnotations -> {{'Origen', {0, 0, 0}, {{'color', 'purple'}, {'size', \
'\\\\Large'}}}, {'M\[AAcute]ximo', {0, 0, 4}, {{'color', 'red!80!black'}, \
{'size', '\\\\large'}, {'anchor', 'south'}}}}]\\n\\nNOTAS:\\n- El archivo se \
guarda en $HomeDirectory/Downloads/[basename]/\\n- Se crea \
autom\[AAcute]ticamente una carpeta con el nombre base del archivo\\n- El \
archivo generado es un documento LaTeX completo listo para compilar\\n- \
Requiere paquetes LaTeX: tikz, pgfplots, amsmath, amssymb, xcolor\\n- Los \
colormaps son exactamente los 11 especificados (no hay otros disponibles)\\n- \
Los colores pueden ser cualquier especificaci\[OAcute]n v\[AAcute]lida de \
TikZ/xcolor\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"ExportToTikZ3D", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`plotArgs_", ",", 
                    "VilTeX`Private`filename_", ",", 
                    RowBox[{"VilTeX`Private`grid_", ":", "True"}], ",", 
                    RowBox[{"VilTeX`Private`color_", ":", "\"blue\""}], ",", 
                    RowBox[{"VilTeX`Private`samples_", ":", "30"}], ",", 
                    RowBox[{"VilTeX`Private`axisType_", ":", "\"box\""}], ",", 
                    RowBox[{"VilTeX`Private`colormap_", ":", "\"viridis\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`opacity_", ":", "1.`"}], ",", 
                    RowBox[{"VilTeX`Private`axisExtension_", ":", "0.`"}], 
                    ",", 
                    
                    RowBox[{
                    "VilTeX`Private`maxPointsImplicit_", ":", "8000"}], ",", 
                    RowBox[{"VilTeX`Private`textAnnotations_", ":", 
                    RowBox[{"{", "}"}]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`data", ",", 
                    "VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderName", ",", 
                    "VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`formatNumber", ",", 
                    "VilTeX`Private`validNumber", ",", 
                    "VilTeX`Private`plotType", ",", "VilTeX`Private`func", 
                    ",", "VilTeX`Private`xRange", ",", 
                    "VilTeX`Private`yRange", ",", "VilTeX`Private`zRange", 
                    ",", "VilTeX`Private`tRange", ",", 
                    "VilTeX`Private`paramFuncs", ",", 
                    "VilTeX`Private`surfaceData", ",", 
                    "VilTeX`Private`axisConfiguration", ",", 
                    "VilTeX`Private`colormapStyle", ",", 
                    "VilTeX`Private`opacityStyle", ",", 
                    "VilTeX`Private`equation", ",", 
                    "VilTeX`Private`targetValue", ",", 
                    "VilTeX`Private`effectiveSamples", ",", 
                    "VilTeX`Private`multipleGraphs", ",", 
                    "VilTeX`Private`graphList", ",", 
                    "VilTeX`Private`allPlotData", ",", 
                    "VilTeX`Private`globalLimits", ",", 
                    "VilTeX`Private`combinedTikzCode", ",", 
                    "VilTeX`Private`currentGraph", ",", 
                    "VilTeX`Private`currentPlotType", ",", 
                    "VilTeX`Private`currentData", ",", 
                    "VilTeX`Private`currentSurfaceData", ",", 
                    "VilTeX`Private`allLimits", ",", "VilTeX`Private`colors", 
                    ",", "VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`textTikzCode"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    
                    RowBox[{"VilTeX`Private`calculateExtendedLimits", ",", 
                    "VilTeX`Private`combineGlobalLimits", ",", 
                    "VilTeX`Private`generateAxisLimitsString", ",", 
                    "VilTeX`Private`generateImplicitSurfaceMejorada", ",", 
                    "VilTeX`Private`determineGraphType"}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`filename", 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: filename debe ser un string\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: filename debe terminar en .tex\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"BooleanQ", "[", "VilTeX`Private`grid", "]"}]}], 
                    ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: grid debe ser True o False\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"box\"", ",", "\"center\"", ",", "\"none\""}], 
                    "}"}], ",", "VilTeX`Private`axisType"}], "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: axisType debe ser \\\"box\\\", \\\"center\\\" o \
\\\"none\\\"\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"\"viridis\"", ",", "\"cool\"", ",", "\"hot\"", 
                    ",", "\"jet\"", ",", "\"hsv\"", ",", "\"spring\"", ",", 
                    "\"summer\"", ",", "\"autumn\"", ",", "\"winter\"", ",", 
                    "\"gray\"", ",", "\"blackwhite\""}], "}"}], ",", 
                    "VilTeX`Private`colormap"}], "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: colormap no v\[AAcute]lido\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`opacity", 
                    "]"}]}], "||", 
                    RowBox[{"VilTeX`Private`opacity", "<", "0"}], "||", 
                    RowBox[{"VilTeX`Private`opacity", ">", "1"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: opacity debe ser un n\[UAcute]mero entre 0 y \
1\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`axisExtension", 
                    "]"}]}], "||", 
                    RowBox[{"VilTeX`Private`axisExtension", "<", "0"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: axisExtension debe ser un n\[UAcute]mero >= \
0\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"IntegerQ", "[", 
                    "VilTeX`Private`maxPointsImplicit", "]"}]}], "||", 
                    
                    RowBox[{"VilTeX`Private`maxPointsImplicit", "<", 
                    "100"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: maxPointsImplicit debe ser un entero >= 100\"", 
                    "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`textAnnotations", 
                    "]"}], "||", 
                    RowBox[{"VilTeX`Private`textAnnotations", "===", 
                    RowBox[{"{", "}"}]}]}], ")"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: textAnnotations debe ser una lista\"", "]"}], 
                    ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`multipleGraphs", "=", "False"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`graphList", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`plotArgs", "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`plotArgs", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`plotArgs", ",", "ListQ"}], "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`plotArgs", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`isMultiple", "=", "True"}], "}"}],
                     ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`plotArgs", "]"}], 
                    "\[Equal]", "2"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "]"}], "\[Equal]", "3"}],
                     "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}]}], ",", 
                    
                    RowBox[{
                    RowBox[{"VilTeX`Private`isMultiple", "=", "False"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`plotArgs", "]"}], 
                    "\[Equal]", "3"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "]"}]}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "3", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}]}], ",", 
                    
                    RowBox[{
                    RowBox[{"VilTeX`Private`isMultiple", "=", "False"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "]"}], "\[Equal]", "3"}],
                     "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "3", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"ListQ", "[", "#1", "]"}]}], "&"}]}], "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`isMultiple", "=", "False"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`plotArgs", "]"}], 
                    "\[Equal]", "4"}], "&&", 
                    RowBox[{
                    RowBox[{"Head", "[", 
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "]"}], "===", "Equal"}], 
                    "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "3", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "4", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}]}], ",", 
                    
                    RowBox[{
                    RowBox[{"VilTeX`Private`isMultiple", "=", "False"}], 
                    ";"}]}], "]"}], ";", 
                    
                    RowBox[{"VilTeX`Private`multipleGraphs", "=", 
                    "VilTeX`Private`isMultiple"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`multipleGraphs", ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphList", "=", 
                    "VilTeX`Private`plotArgs"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`graphList", "=", 
                    RowBox[{"{", "VilTeX`Private`plotArgs", "}"}]}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`axisConfiguration", "=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`axisType", "\[Equal]", 
                    "\"box\""}], ",", "\"axis lines=box\"", ",", 
                    
                    RowBox[{"VilTeX`Private`axisType", "\[Equal]", 
                    "\"center\""}], ",", 
                    "\"axis lines=center, axis line style={->}\"", ",", 
                    
                    RowBox[{"VilTeX`Private`axisType", "\[Equal]", 
                    "\"none\""}], ",", "\"axis lines=none\"", ",", "True", 
                    ",", "\"axis lines=box\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`colormapStyle", "=", 
                    
                    RowBox[{"\"colormap/\"", "<>", 
                    "VilTeX`Private`colormap"}]}], ";", 
                    RowBox[{"VilTeX`Private`opacityStyle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`opacity", "<", "1.`"}], ",", 
                    RowBox[{"\", opacity=\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`opacity", "]"}], 
                    "<>", "\", fill opacity=\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`opacity", 
                    "]"}]}], ",", "\"\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`colors", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"blue\"", ",", "\"red\"", ",", 
                    "\"green!70!black\"", ",", "\"orange\"", ",", 
                    "\"purple\"", ",", "\"brown\"", ",", "\"pink\"", ",", 
                    "\"gray\"", ",", "\"cyan\"", ",", "\"magenta\""}], 
                    "}"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`result", ",", 
                    "VilTeX`Private`num"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`x", "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`num", "=", 
                    RowBox[{"N", "[", "VilTeX`Private`x", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], "<", 
                    FractionBox["1", 
                    SuperscriptBox["10", "10"]]}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", "\"0\""}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], ">", 
                    SuperscriptBox["10", "8"]}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", "1"}], "]"}], ",", 
                    "InputForm"}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], ">", 
                    "1000"}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", "0.1`"}], "]"}], ",", 
                    "InputForm"}], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", 
                    FractionBox["1", 
                    SuperscriptBox["10", "4"]]}], "]"}], ",", "InputForm"}], 
                    "]"}]}]}], "]"}]}], "]"}]}], "]"}], ";"}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", "\"0\""}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`multipleGraphs", "&&", 
                    RowBox[{"StringQ", "[", "VilTeX`Private`result", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{
                    
                    RowBox[{"ToExpression", "[", "VilTeX`Private`result", 
                    "]"}], ",", "0.01`"}], "]"}], ",", "InputForm"}], "]"}]}],
                     ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`result", "]"}], 
                    ",", "VilTeX`Private`result", ",", 
                    RowBox[{"ToString", "[", "VilTeX`Private`result", "]"}]}],
                     "]"}]}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`x", "]"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`x", "\[Element]", 
                    TemplateBox[{}, "Reals"]}], "&&", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`x", "]"}], "<", 
                    SuperscriptBox["10", "10"]}]}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`calculateExtendedLimits", "[", 
                    "VilTeX`Private`dataPoints_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xDataMin", ",", 
                    "VilTeX`Private`xDataMax", ",", "VilTeX`Private`yDataMin",
                     ",", "VilTeX`Private`yDataMax", ",", 
                    "VilTeX`Private`zDataMin", ",", "VilTeX`Private`zDataMax",
                     ",", "VilTeX`Private`xRangeData", ",", 
                    "VilTeX`Private`yRangeData", ",", 
                    "VilTeX`Private`zRangeData"}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`dataPoints", "]"}],
                     ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xDataMin", "=", 
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`dataPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xDataMax", "=", 
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`dataPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yDataMin", "=", 
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`dataPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yDataMax", "=", 
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`dataPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`zDataMin", "=", 
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`dataPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "3"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`zDataMax", "=", 
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`dataPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "3"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`axisType", "\[Equal]", 
                    "\"center\""}], "&&", 
                    RowBox[{"VilTeX`Private`axisExtension", ">", "0"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xRangeData", "=", 
                    
                    RowBox[{"VilTeX`Private`xDataMax", "-", 
                    "VilTeX`Private`xDataMin"}]}], ";", 
                    RowBox[{"VilTeX`Private`yRangeData", "=", 
                    
                    RowBox[{"VilTeX`Private`yDataMax", "-", 
                    "VilTeX`Private`yDataMin"}]}], ";", 
                    RowBox[{"VilTeX`Private`zRangeData", "=", 
                    
                    RowBox[{"VilTeX`Private`zDataMax", "-", 
                    "VilTeX`Private`zDataMin"}]}], ";", 
                    RowBox[{"VilTeX`Private`xDataMin", "=", 
                    RowBox[{"VilTeX`Private`xDataMin", "-", 
                    
                    RowBox[{"VilTeX`Private`axisExtension", " ", 
                    "VilTeX`Private`xRangeData"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`xDataMax", "=", 
                    RowBox[{"VilTeX`Private`xDataMax", "+", 
                    
                    RowBox[{"VilTeX`Private`axisExtension", " ", 
                    "VilTeX`Private`xRangeData"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`yDataMin", "=", 
                    RowBox[{"VilTeX`Private`yDataMin", "-", 
                    
                    RowBox[{"VilTeX`Private`axisExtension", " ", 
                    "VilTeX`Private`yRangeData"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`yDataMax", "=", 
                    RowBox[{"VilTeX`Private`yDataMax", "+", 
                    
                    RowBox[{"VilTeX`Private`axisExtension", " ", 
                    "VilTeX`Private`yRangeData"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`zDataMin", "=", 
                    RowBox[{"VilTeX`Private`zDataMin", "-", 
                    
                    RowBox[{"VilTeX`Private`axisExtension", " ", 
                    "VilTeX`Private`zRangeData"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`zDataMax", "=", 
                    RowBox[{"VilTeX`Private`zDataMax", "+", 
                    
                    RowBox[{"VilTeX`Private`axisExtension", " ", 
                    "VilTeX`Private`zRangeData"}]}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xDataMin", ",", 
                    "VilTeX`Private`xDataMax", ",", "VilTeX`Private`yDataMin",
                     ",", "VilTeX`Private`yDataMax", ",", 
                    "VilTeX`Private`zDataMin", ",", 
                    "VilTeX`Private`zDataMax"}], "}"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "1", ",", 
                    RowBox[{"-", "1"}], ",", "1", ",", 
                    RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "]"}]}],
                     ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`combineGlobalLimits", "[", 
                    "VilTeX`Private`limitsList_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xMins", ",", 
                    "VilTeX`Private`xMaxs", ",", "VilTeX`Private`yMins", ",", 
                    "VilTeX`Private`yMaxs", ",", "VilTeX`Private`zMins", ",", 
                    "VilTeX`Private`zMaxs"}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`limitsList", "]"}],
                     ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xMins", "=", 
                    
                    RowBox[{"VilTeX`Private`limitsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`xMaxs", "=", 
                    
                    RowBox[{"VilTeX`Private`limitsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`yMins", "=", 
                    
                    RowBox[{"VilTeX`Private`limitsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "3"}], "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`yMaxs", "=", 
                    
                    RowBox[{"VilTeX`Private`limitsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "4"}], "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`zMins", "=", 
                    
                    RowBox[{"VilTeX`Private`limitsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "5"}], "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`zMaxs", "=", 
                    
                    RowBox[{"VilTeX`Private`limitsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "6"}], "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", "VilTeX`Private`xMins", "]"}], ",", 
                    RowBox[{"Max", "[", "VilTeX`Private`xMaxs", "]"}], ",", 
                    RowBox[{"Min", "[", "VilTeX`Private`yMins", "]"}], ",", 
                    RowBox[{"Max", "[", "VilTeX`Private`yMaxs", "]"}], ",", 
                    RowBox[{"Min", "[", "VilTeX`Private`zMins", "]"}], ",", 
                    RowBox[{"Max", "[", "VilTeX`Private`zMaxs", "]"}]}], 
                    "}"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "1", ",", 
                    RowBox[{"-", "1"}], ",", "1", ",", 
                    RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "]"}]}],
                     ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`generateAxisLimitsString", "[", 
                    "VilTeX`Private`limits_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xMin", ",", "VilTeX`Private`xMax",
                     ",", "VilTeX`Private`yMin", ",", "VilTeX`Private`yMax", 
                    ",", "VilTeX`Private`zMin", ",", "VilTeX`Private`zMax"}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xMin", ",", "VilTeX`Private`xMax",
                     ",", "VilTeX`Private`yMin", ",", "VilTeX`Private`yMax", 
                    ",", "VilTeX`Private`zMin", ",", "VilTeX`Private`zMax"}], 
                    "}"}], "=", "VilTeX`Private`limits"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`multipleGraphs", "||", 
                    RowBox[{"(", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`axisType", "\[Equal]", 
                    "\"center\""}], "&&", 
                    RowBox[{"VilTeX`Private`axisExtension", ">", "0"}]}], 
                    ")"}]}], ",", 
                    RowBox[{"\"  xmin=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`xMin", "]"}], "<>", "\", xmax=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`xMax", "]"}], "<>", "\",\\n\"", "<>", 
                    "\"  ymin=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`yMin", "]"}], "<>", "\", ymax=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`yMax", "]"}], "<>", "\",\\n\"", "<>", 
                    "\"  zmin=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`zMin", "]"}], "<>", "\", zmax=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`zMax", "]"}], "<>", "\",\\n\""}], ",", 
                    "\"\""}], "]"}]}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`generateImplicitSurfaceMejorada", 
                    "[", 
                    
                    RowBox[{"VilTeX`Private`equation_", ",", 
                    "VilTeX`Private`xRange_", ",", "VilTeX`Private`yRange_", 
                    ",", "VilTeX`Private`zRange_", ",", 
                    "VilTeX`Private`targetSamples_", ",", 
                    "VilTeX`Private`maxPointsLimit_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`xMin",
                     ",", "VilTeX`Private`xMax", ",", "VilTeX`Private`yVar", 
                    ",", "VilTeX`Private`yMin", ",", "VilTeX`Private`yMax", 
                    ",", "VilTeX`Private`zVar", ",", "VilTeX`Private`zMin", 
                    ",", "VilTeX`Private`zMax", ",", 
                    "VilTeX`Private`leftSide", ",", 
                    "VilTeX`Private`rightSide", ",", 
                    "VilTeX`Private`implicitFunc", ",", 
                    "VilTeX`Private`surfPoints", ",", 
                    "VilTeX`Private`zSolutions", ",", 
                    "VilTeX`Private`tolerance", ",", 
                    "VilTeX`Private`currentPoints", ",", 
                    "VilTeX`Private`adaptiveSamples"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`xMin",
                     ",", "VilTeX`Private`xMax"}], "}"}], "=", 
                    "VilTeX`Private`xRange"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`yVar", ",", "VilTeX`Private`yMin",
                     ",", "VilTeX`Private`yMax"}], "}"}], "=", 
                    "VilTeX`Private`yRange"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`zVar", ",", "VilTeX`Private`zMin",
                     ",", "VilTeX`Private`zMax"}], "}"}], "=", 
                    "VilTeX`Private`zRange"}], ";", 
                    RowBox[{"VilTeX`Private`leftSide", "=", 
                    
                    RowBox[{"VilTeX`Private`equation", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`rightSide", "=", 
                    
                    RowBox[{"VilTeX`Private`equation", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`implicitFunc", "=", 
                    
                    RowBox[{"VilTeX`Private`leftSide", "-", 
                    "VilTeX`Private`rightSide"}]}], ";", 
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`tolerance", "=", "0.001`"}], ";", 
                    
                    RowBox[{"VilTeX`Private`currentPoints", "=", "0"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FreeQ", "[", 
                    
                    RowBox[{"VilTeX`Private`equation", ",", 
                    "VilTeX`Private`zVar"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`equation2D", ",", 
                    "VilTeX`Private`xVals", ",", "VilTeX`Private`yVals", ",", 
                    "VilTeX`Private`zVals", ",", "VilTeX`Private`zSteps"}], 
                    "}"}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`equation2D", "=", 
                    "VilTeX`Private`equation"}], ";", 
                    RowBox[{"VilTeX`Private`xVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`xMax", "-", 
                    "VilTeX`Private`xMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{"VilTeX`Private`targetSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`targetSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`yMax", "-", 
                    "VilTeX`Private`yMin"}], ")"}], " ", "VilTeX`Private`j"}], 
                    RowBox[{"VilTeX`Private`targetSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`targetSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`zSteps", "=", 
                    RowBox[{"Min", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`targetSamples", " ", "2"}], ",", 
                    "60"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`zVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`zMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`zMax", "-", 
                    "VilTeX`Private`zMin"}], ")"}], " ", "VilTeX`Private`k"}], 
                    RowBox[{"VilTeX`Private`zSteps", "-", "1"}]]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`zSteps", "-", "1"}]}], "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`equation2DValue", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`equation2DValue", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"N", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`leftSide", "-", 
                    "VilTeX`Private`rightSide"}], "/.", "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`yVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}]}], 
                    "}"}]}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`equation2DValue", "]"}], "&&", 
                    RowBox[{
                    
                    RowBox[{"Abs", "[", "VilTeX`Private`equation2DValue", 
                    "]"}], "<", "VilTeX`Private`tolerance"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`currentPoints", "<", 
                    "VilTeX`Private`maxPointsLimit"}]}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`surfPoints", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`zVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`k", "\[RightDoubleBracket]"}]}], "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPoints", "++"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`currentPoints", "\[GreaterEqual]",
                     "VilTeX`Private`maxPointsLimit"}], ",", 
                    RowBox[{"Break", "[", "]"}]}], "]"}], ";"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`zVals", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`yVals", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`currentPoints", "\[GreaterEqual]",
                     "VilTeX`Private`maxPointsLimit"}], ",", 
                    RowBox[{"Break", "[", "]"}]}], "]"}], ";"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`xVals", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`zSolutions", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Solve", "[", 
                    
                    RowBox[{"VilTeX`Private`equation", ",", 
                    "VilTeX`Private`zVar", ",", 
                    TemplateBox[{}, "Reals"]}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`zSolutions", "]"}],
                     ">", "0"}], "&&", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`zSolutions", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    ",", "Solve"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`zFunc", ",", 
                    "VilTeX`Private`xVals", ",", "VilTeX`Private`yVals", ",", 
                    
                    RowBox[{"VilTeX`Private`validSolutions", "=", 
                    RowBox[{"{", "}"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`zFunc", "=", 
                    RowBox[{"VilTeX`Private`zVar", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`zSolutions", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`solIdx", 
                    "\[RightDoubleBracket]"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FreeQ", "[", 
                    
                    RowBox[{"VilTeX`Private`zFunc", ",", 
                    "VilTeX`Private`zVar"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validSolutions", "=", 
                    RowBox[{"Append", "[", 
                    
                    RowBox[{"VilTeX`Private`validSolutions", ",", 
                    "VilTeX`Private`zFunc"}], "]"}]}], ";"}]}], "]"}]}], ",", 
                    
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`solIdx", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`zSolutions", "]"}],
                     ",", "3"}], "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validSolutions", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`xMax", "-", 
                    "VilTeX`Private`xMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{
                    RowBox[{"VilTeX`Private`targetSamples", " ", "2"}], "-", 
                    "1"}]]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`targetSamples", " ", "2"}], "-", 
                    "1"}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`yMax", "-", 
                    "VilTeX`Private`yMin"}], ")"}], " ", "VilTeX`Private`j"}], 
                    RowBox[{
                    RowBox[{"VilTeX`Private`targetSamples", " ", "2"}], "-", 
                    "1"}]]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "0", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`targetSamples", " ", "2"}], "-", 
                    "1"}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`zVal", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`zVal", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"N", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validSolutions", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`k", 
                    "\[RightDoubleBracket]"}], "/.", "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`yVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}]}], 
                    "}"}]}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`zVal", "]"}], "&&", 
                    RowBox[{"VilTeX`Private`zMin", "\[LessEqual]", 
                    "VilTeX`Private`zVal", "\[LessEqual]", 
                    "VilTeX`Private`zMax"}], "&&", 
                    RowBox[{"VilTeX`Private`currentPoints", "<", 
                    "VilTeX`Private`maxPointsLimit"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`surfPoints", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], ",", 
                    "VilTeX`Private`zVal"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPoints", "++"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validSolutions", 
                    "]"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`yVals", "]"}]}], 
                    "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`xVals", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`adaptiveSamples", "=", 
                    RowBox[{"Min", "[", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{"VilTeX`Private`targetSamples", ",", "25"}], 
                    "]"}], ",", 
                    RowBox[{"Floor", "[", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`maxPointsImplicit", " ", "0.8`"}],
                     ")"}], 
                    RowBox[{"1", "/", "3"}]], "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`adaptiveSamples", "=", 
                    RowBox[{"Max", "[", 
                    RowBox[{"VilTeX`Private`adaptiveSamples", ",", "8"}], 
                    "]"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVals", ",", 
                    "VilTeX`Private`yVals", ",", "VilTeX`Private`zVals"}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`xMax", "-", 
                    "VilTeX`Private`xMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{"VilTeX`Private`adaptiveSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`adaptiveSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`yMax", "-", 
                    "VilTeX`Private`yMin"}], ")"}], " ", "VilTeX`Private`j"}], 
                    RowBox[{"VilTeX`Private`adaptiveSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`adaptiveSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`zVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`zMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`zMax", "-", 
                    "VilTeX`Private`zMin"}], ")"}], " ", "VilTeX`Private`k"}], 
                    RowBox[{"VilTeX`Private`adaptiveSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`adaptiveSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`currentPoints", "<", 
                    "VilTeX`Private`maxPointsLimit"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`funcVal", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`funcVal", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`implicitFunc", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`yVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`zVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`zVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`k", "\[RightDoubleBracket]"}]}]}], 
                    "}"}]}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`funcVal", "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`funcVal", "]"}], "<", 
                    "VilTeX`Private`tolerance"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`surfPoints", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "VilTeX`Private`zVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`k", "\[RightDoubleBracket]"}]}], "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPoints", "++"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`zVals", "]"}]}], 
                    "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`yVals", "]"}]}], 
                    "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`xVals", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`surfPoints", "]"}],
                     ">", "VilTeX`Private`maxPointsLimit"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"RandomSample", "[", 
                    
                    RowBox[{"VilTeX`Private`surfPoints", ",", 
                    "VilTeX`Private`maxPointsLimit"}], "]"}]}], ";"}]}], 
                    "]"}], ";", "VilTeX`Private`surfPoints"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`determineGraphType", "[", 
                    "VilTeX`Private`graphArgs_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "\[Equal]", "4"}], "&&", 
                    RowBox[{
                    RowBox[{"Head", "[", 
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "===", "Equal"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}]}], ",", 
                    "\"ImplicitPlot3D\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "\[Equal]", "3"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}]}]}], ",", "\"Plot3D\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "\[Equal]", "2"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "\[Equal]", "3"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}]}], ",", 
                    "\"ParametricPlot3D_Curve\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "\[Equal]", "3"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "\[Equal]", "3"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}]}], ",", 
                    "\"ParametricPlot3D_Surface\"", ",", "True", ",", 
                    "\"Unknown\""}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allPlotData", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`allLimits", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`adjustedSamples", ",", 
                    "VilTeX`Private`adjustedMaxPoints"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`multipleGraphs", "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`graphList", "]"}], 
                    ">", "1"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`adjustedSamples", "=", 
                    RowBox[{"Min", "[", 
                    RowBox[{"VilTeX`Private`samples", ",", "25"}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`adjustedMaxPoints", "=", 
                    RowBox[{"Min", "[", 
                    RowBox[{"VilTeX`Private`maxPointsImplicit", ",", 
                    RowBox[{"Floor", "[", 
                    FractionBox["8000", 
                    RowBox[{"Length", "[", "VilTeX`Private`graphList", "]"}]],
                     "]"}]}], "]"}]}], ";"}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`adjustedSamples", "=", 
                    "VilTeX`Private`samples"}], ";", 
                    
                    RowBox[{"VilTeX`Private`adjustedMaxPoints", "=", 
                    "VilTeX`Private`maxPointsImplicit"}], ";"}]}], "]"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`currentGraph", "=", 
                    
                    RowBox[{"VilTeX`Private`graphList", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`graphIdx", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPlotType", "=", 
                    
                    RowBox[{"VilTeX`Private`determineGraphType", "[", 
                    "VilTeX`Private`currentGraph", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentData", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentSurfaceData", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`currentPlotType", "\[Equal]", 
                    "\"ImplicitPlot3D\""}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`equation", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`yRange", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`zRange", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`currentSurfaceData", "=", 
                    
                    RowBox[{"VilTeX`Private`generateImplicitSurfaceMejorada", 
                    "[", 
                    RowBox[{
                    "VilTeX`Private`equation", ",", "VilTeX`Private`xRange", 
                    ",", "VilTeX`Private`yRange", ",", 
                    "VilTeX`Private`zRange", ",", 
                    "VilTeX`Private`adjustedSamples", ",", 
                    "VilTeX`Private`adjustedMaxPoints"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", 
                    "VilTeX`Private`currentSurfaceData", "]"}], ">", "0"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allLimits", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allLimits", ",", 
                    
                    RowBox[{"VilTeX`Private`calculateExtendedLimits", "[", 
                    "VilTeX`Private`currentSurfaceData", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`allPlotData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allPlotData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", ",", 
                    "VilTeX`Private`currentSurfaceData", ",", 
                    "VilTeX`Private`currentGraph"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`currentSurfaceData"}], "]"}]}], ";"}]}], 
                    "]"}], ";"}], ",", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", "\[Equal]", 
                    "\"Plot3D\""}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`func", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`yRange", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`xMin",
                     ",", "VilTeX`Private`xMax", ",", "VilTeX`Private`yVar", 
                    ",", "VilTeX`Private`yMin", ",", "VilTeX`Private`yMax", 
                    ",", "VilTeX`Private`xVals", ",", 
                    "VilTeX`Private`yVals"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`xMin",
                     ",", "VilTeX`Private`xMax"}], "}"}], "=", 
                    "VilTeX`Private`xRange"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`yVar", ",", "VilTeX`Private`yMin",
                     ",", "VilTeX`Private`yMax"}], "}"}], "=", 
                    "VilTeX`Private`yRange"}], ";", 
                    RowBox[{"VilTeX`Private`xVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`xMax", "-", 
                    "VilTeX`Private`xMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{"VilTeX`Private`adjustedSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`adjustedSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`yMax", "-", 
                    "VilTeX`Private`yMin"}], ")"}], " ", "VilTeX`Private`j"}], 
                    RowBox[{"VilTeX`Private`adjustedSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`adjustedSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`zVal", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`zVal", "=", 
                    RowBox[{"VilTeX`Private`func", "/.", "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`yVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}]}], 
                    "}"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`zVal", "]"}], 
                    "&&", 
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`zVal", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`currentSurfaceData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`currentSurfaceData", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], ",", 
                    "VilTeX`Private`zVal"}], "}"}]}], "]"}]}], ";"}]}], "]"}],
                     ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`yVals", "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`xVals", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", 
                    "VilTeX`Private`currentSurfaceData", "]"}], ">", "0"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allLimits", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allLimits", ",", 
                    
                    RowBox[{"VilTeX`Private`calculateExtendedLimits", "[", 
                    "VilTeX`Private`currentSurfaceData", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`allPlotData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allPlotData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", ",", 
                    "VilTeX`Private`currentSurfaceData", ",", 
                    "VilTeX`Private`currentGraph"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`currentSurfaceData"}], "]"}]}], ";"}]}], 
                    "]"}], ";"}], ",", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", "\[Equal]", 
                    "\"ParametricPlot3D_Curve\""}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`paramFuncs", "=", 
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tRange", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tVar", ",", "VilTeX`Private`tMin",
                     ",", "VilTeX`Private`tMax", ",", "VilTeX`Private`tVals", 
                    ",", "VilTeX`Private`xFunc", ",", "VilTeX`Private`yFunc", 
                    ",", "VilTeX`Private`zFunc", ",", 
                    "VilTeX`Private`curvePoints"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tVar", ",", "VilTeX`Private`tMin",
                     ",", "VilTeX`Private`tMax"}], "}"}], "=", 
                    "VilTeX`Private`tRange"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xFunc", ",", 
                    "VilTeX`Private`yFunc", ",", "VilTeX`Private`zFunc"}], 
                    "}"}], "=", "VilTeX`Private`paramFuncs"}], ";", 
                    RowBox[{"VilTeX`Private`curvePoints", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`multipleGraphs", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`adjustedSamples", " ", "2"}], ",",
                     "100"}], "]"}], ",", 
                    RowBox[{"VilTeX`Private`adjustedSamples", " ", "4"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`tMax", "-", 
                    "VilTeX`Private`tMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{"VilTeX`Private`curvePoints", "-", "1"}]]}], ",", 
                    
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`curvePoints", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", "VilTeX`Private`yVal",
                     ",", "VilTeX`Private`zVal"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVal", "=", 
                    
                    RowBox[{"VilTeX`Private`xFunc", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`tVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`tVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}]}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`yVal", "=", 
                    
                    RowBox[{"VilTeX`Private`yFunc", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`tVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`tVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}]}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`zVal", "=", 
                    
                    RowBox[{"VilTeX`Private`zFunc", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`tVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`tVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}]}]}], ";", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", "VilTeX`Private`yVal",
                     ",", "VilTeX`Private`zVal"}], "}"}], ",", "NumericQ"}], 
                    "]"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", "VilTeX`Private`yVal",
                     ",", "VilTeX`Private`zVal"}], "}"}], ",", 
                    "VilTeX`Private`validNumber"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`currentData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`currentData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    "VilTeX`Private`yVal", ",", "VilTeX`Private`zVal"}], 
                    "}"}]}], "]"}]}], ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`tVals", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`currentData", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allLimits", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allLimits", ",", 
                    
                    RowBox[{"VilTeX`Private`calculateExtendedLimits", "[", 
                    "VilTeX`Private`currentData", "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allPlotData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allPlotData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", ",", 
                    "VilTeX`Private`currentData", ",", 
                    "VilTeX`Private`currentGraph"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`currentData"}], "]"}]}], ";"}]}], "]"}], 
                    ";"}], ",", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", "\[Equal]", 
                    "\"ParametricPlot3D_Surface\""}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`paramFuncs", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`yRange", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`uVar", ",", "VilTeX`Private`uMin",
                     ",", "VilTeX`Private`uMax", ",", "VilTeX`Private`vVar", 
                    ",", "VilTeX`Private`vMin", ",", "VilTeX`Private`vMax", 
                    ",", "VilTeX`Private`uVals", ",", "VilTeX`Private`vVals", 
                    ",", "VilTeX`Private`xFunc", ",", "VilTeX`Private`yFunc", 
                    ",", "VilTeX`Private`zFunc"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`uVar", ",", "VilTeX`Private`uMin",
                     ",", "VilTeX`Private`uMax"}], "}"}], "=", 
                    "VilTeX`Private`xRange"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`vVar", ",", "VilTeX`Private`vMin",
                     ",", "VilTeX`Private`vMax"}], "}"}], "=", 
                    "VilTeX`Private`yRange"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xFunc", ",", 
                    "VilTeX`Private`yFunc", ",", "VilTeX`Private`zFunc"}], 
                    "}"}], "=", "VilTeX`Private`paramFuncs"}], ";", 
                    RowBox[{"VilTeX`Private`uVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`uMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`uMax", "-", 
                    "VilTeX`Private`uMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{"VilTeX`Private`adjustedSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`adjustedSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`vVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`vMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`vMax", "-", 
                    "VilTeX`Private`vMin"}], ")"}], " ", "VilTeX`Private`j"}], 
                    RowBox[{"VilTeX`Private`adjustedSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`adjustedSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", "VilTeX`Private`yVal",
                     ",", "VilTeX`Private`zVal"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVal", "=", 
                    
                    RowBox[{"VilTeX`Private`xFunc", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`uVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`uVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`vVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`vVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}]}], 
                    "}"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`yVal", "=", 
                    
                    RowBox[{"VilTeX`Private`yFunc", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`uVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`uVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`vVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`vVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}]}], 
                    "}"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`zVal", "=", 
                    
                    RowBox[{"VilTeX`Private`zFunc", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`uVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`uVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`vVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`vVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}]}], 
                    "}"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", "VilTeX`Private`yVal",
                     ",", "VilTeX`Private`zVal"}], "}"}], ",", "NumericQ"}], 
                    "]"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", "VilTeX`Private`yVal",
                     ",", "VilTeX`Private`zVal"}], "}"}], ",", 
                    "VilTeX`Private`validNumber"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`currentSurfaceData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`currentSurfaceData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    "VilTeX`Private`yVal", ",", "VilTeX`Private`zVal"}], 
                    "}"}]}], "]"}]}], ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`vVals", "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`uVals", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", 
                    "VilTeX`Private`currentSurfaceData", "]"}], ">", "0"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allLimits", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allLimits", ",", 
                    
                    RowBox[{"VilTeX`Private`calculateExtendedLimits", "[", 
                    "VilTeX`Private`currentSurfaceData", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`allPlotData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allPlotData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", ",", 
                    "VilTeX`Private`currentSurfaceData", ",", 
                    "VilTeX`Private`currentGraph"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`currentSurfaceData"}], "]"}]}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`graphIdx", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`graphList", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`allValidData", 
                    "]"}], "\[Equal]", "0"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: No se generaron datos v\[AAcute]lidos para ning\
\[UAcute]n gr\[AAcute]fico\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`globalLimits", "=", 
                    
                    RowBox[{"VilTeX`Private`combineGlobalLimits", "[", 
                    "VilTeX`Private`allLimits", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderName", "=", 
                    
                    RowBox[{"FileBaseName", "[", "VilTeX`Private`filename", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "VilTeX`Private`folderName"}], "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", "\"\""}], 
                    ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`plotType", ",", 
                    "VilTeX`Private`graphData", ",", 
                    "VilTeX`Private`graphArgs", ",", 
                    "VilTeX`Private`tikzPlot", ",", 
                    "VilTeX`Private`validPoints", ",", 
                    "VilTeX`Private`plotStyle", ",", 
                    "VilTeX`Private`meshData", ",", 
                    "VilTeX`Private`currentColor"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`plotType", ",", 
                    "VilTeX`Private`graphData", ",", 
                    "VilTeX`Private`graphArgs"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`allPlotData", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`plotIdx", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentColor", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`multipleGraphs", "&&", 
                    RowBox[{"VilTeX`Private`plotIdx", "\[LessEqual]", 
                    RowBox[{"Length", "[", "VilTeX`Private`colors", "]"}]}]}],
                     ",", 
                    
                    RowBox[{"VilTeX`Private`colors", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`plotIdx", "\[RightDoubleBracket]"}], ",", 
                    "VilTeX`Private`color"}], "]"}]}], ";", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotType", "\[Equal]", 
                    "\"ImplicitPlot3D\""}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validPoints", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`graphData", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[Equal]", "3"}], 
                    "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"#1", ",", "VilTeX`Private`validNumber"}], 
                    "]"}]}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validPoints", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`plotStyle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validPoints", 
                    "]"}], ">", "2000"}], ",", 
                    "\"only marks, mark=*, mark size=0.5pt\"", ",", 
                    "\"only marks, mark=*, mark size=0.8pt\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzPlot", "=", 
                    
                    RowBox[{"\"\\\\addplot3[\"", "<>", 
                    "VilTeX`Private`currentColor", "<>", "\", \"", "<>", 
                    "VilTeX`Private`plotStyle", "<>", 
                    "VilTeX`Private`opacityStyle", "<>", 
                    "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`validPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`validPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`validPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validPoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "VilTeX`Private`tikzPlot"}]}], ";"}]}], "]"}], ";"}], ",", 
                    
                    RowBox[{"VilTeX`Private`plotType", "\[Equal]", 
                    "\"Plot3D\""}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`xMin",
                     ",", "VilTeX`Private`xMax", ",", "VilTeX`Private`yVar", 
                    ",", "VilTeX`Private`yMin", ",", "VilTeX`Private`yMax"}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`xMin",
                     ",", "VilTeX`Private`xMax"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`yVar", ",", "VilTeX`Private`yMin",
                     ",", "VilTeX`Private`yMax"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`meshData", "=", "\"\""}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", "VilTeX`Private`yVal",
                     ",", "VilTeX`Private`zVal"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVal", "=", 
                    RowBox[{"VilTeX`Private`xMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`xMax", "-", 
                    "VilTeX`Private`xMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{"VilTeX`Private`samples", "-", "1"}]]}]}], ";", 
                    RowBox[{"VilTeX`Private`yVal", "=", 
                    RowBox[{"VilTeX`Private`yMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`yMax", "-", 
                    "VilTeX`Private`yMin"}], ")"}], " ", "VilTeX`Private`j"}], 
                    RowBox[{"VilTeX`Private`samples", "-", "1"}]]}]}], ";", 
                    RowBox[{"VilTeX`Private`zVal", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "/.", "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xVar", "\[Rule]", 
                    "VilTeX`Private`xVal"}], ",", 
                    RowBox[{
                    "VilTeX`Private`yVar", "\[Rule]", 
                    "VilTeX`Private`yVal"}]}], "}"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`zVal", "]"}], 
                    "&&", 
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`zVal", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`meshData", "=", 
                    RowBox[{"VilTeX`Private`meshData", "<>", "\"(\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`xVal", "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`yVal", "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`zVal", "]"}], "<>", "\")\\n\""}]}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`samples", "-", "1"}]}], "}"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`meshData", "=", 
                    RowBox[{"VilTeX`Private`meshData", "<>", "\"\\n\""}]}], 
                    ";"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`samples", "-", "1"}]}], "}"}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"StringLength", "[", "VilTeX`Private`meshData", 
                    "]"}], ">", "10"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzPlot", "=", 
                    
                    RowBox[{"\"\\\\addplot3[\"", "<>", 
                    "VilTeX`Private`currentColor", "<>", 
                    "\", surf, mesh/rows=\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`samples", "]"}], 
                    "<>", "\", mesh/cols=\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`samples", "]"}], 
                    "<>", "VilTeX`Private`opacityStyle", "<>", 
                    "\"] coordinates {\\n\"", "<>", "VilTeX`Private`meshData",
                     "<>", "\"};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "VilTeX`Private`tikzPlot"}]}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";"}], ",", 
                    
                    RowBox[{"VilTeX`Private`plotType", "\[Equal]", 
                    "\"ParametricPlot3D_Curve\""}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`graphData", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzPlot", "=", 
                    
                    RowBox[{"\"\\\\addplot3[\"", "<>", 
                    "VilTeX`Private`currentColor", "<>", 
                    "\", thick, no marks] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`graphData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`graphData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`graphData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "3"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`graphData", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "VilTeX`Private`tikzPlot"}]}], ";"}]}], "]"}], ";"}], ",", 
                    
                    RowBox[{"VilTeX`Private`plotType", "\[Equal]", 
                    "\"ParametricPlot3D_Surface\""}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`uVar", ",", "VilTeX`Private`uMin",
                     ",", "VilTeX`Private`uMax", ",", "VilTeX`Private`vVar", 
                    ",", "VilTeX`Private`vMin", ",", "VilTeX`Private`vMax"}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`uVar", ",", "VilTeX`Private`uMin",
                     ",", "VilTeX`Private`uMax"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`vVar", ",", "VilTeX`Private`vMin",
                     ",", "VilTeX`Private`vMax"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`meshData", "=", "\"\""}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`uVal", ",", "VilTeX`Private`vVal",
                     ",", "VilTeX`Private`xVal", ",", "VilTeX`Private`yVal", 
                    ",", "VilTeX`Private`zVal"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`uVal", "=", 
                    RowBox[{"VilTeX`Private`uMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`uMax", "-", 
                    "VilTeX`Private`uMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{"VilTeX`Private`samples", "-", "1"}]]}]}], ";", 
                    RowBox[{"VilTeX`Private`vVal", "=", 
                    RowBox[{"VilTeX`Private`vMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`vMax", "-", 
                    "VilTeX`Private`vMin"}], ")"}], " ", "VilTeX`Private`j"}], 
                    RowBox[{"VilTeX`Private`samples", "-", "1"}]]}]}], ";", 
                    RowBox[{"VilTeX`Private`xVal", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}], "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`uVar", "\[Rule]", 
                    "VilTeX`Private`uVal"}], ",", 
                    RowBox[{
                    "VilTeX`Private`vVar", "\[Rule]", 
                    "VilTeX`Private`vVal"}]}], "}"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`yVal", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}], "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`uVar", "\[Rule]", 
                    "VilTeX`Private`uVal"}], ",", 
                    RowBox[{
                    "VilTeX`Private`vVar", "\[Rule]", 
                    "VilTeX`Private`vVal"}]}], "}"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`zVal", "=", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "3"}], "\[RightDoubleBracket]"}], "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`uVar", "\[Rule]", 
                    "VilTeX`Private`uVal"}], ",", 
                    RowBox[{
                    "VilTeX`Private`vVar", "\[Rule]", 
                    "VilTeX`Private`vVal"}]}], "}"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    "VilTeX`Private`yVal", ",", "VilTeX`Private`zVal"}], 
                    "}"}], ",", "NumericQ"}], "]"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    "VilTeX`Private`yVal", ",", "VilTeX`Private`zVal"}], 
                    "}"}], ",", "VilTeX`Private`validNumber"}], "]"}]}], ",", 
                    
                    RowBox[{
                    RowBox[{"VilTeX`Private`meshData", "=", 
                    RowBox[{"VilTeX`Private`meshData", "<>", "\"(\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`xVal", "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`yVal", "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`zVal", "]"}], "<>", "\")\\n\""}]}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`samples", "-", "1"}]}], "}"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`meshData", "=", 
                    RowBox[{"VilTeX`Private`meshData", "<>", "\"\\n\""}]}], 
                    ";"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`samples", "-", "1"}]}], "}"}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"StringLength", "[", "VilTeX`Private`meshData", 
                    "]"}], ">", "10"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzPlot", "=", 
                    
                    RowBox[{"\"\\\\addplot3[\"", "<>", 
                    "VilTeX`Private`currentColor", "<>", 
                    "\", surf, mesh/rows=\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`samples", "]"}], 
                    "<>", "\", mesh/cols=\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`samples", "]"}], 
                    "<>", "VilTeX`Private`opacityStyle", "<>", 
                    "\"] coordinates {\\n\"", "<>", "VilTeX`Private`meshData",
                     "<>", "\"};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "VilTeX`Private`tikzPlot"}]}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`plotIdx", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`allPlotData", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`textTikzCode", "=", "\"\""}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`textAnnotations", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`processedAnnotations", "=", 
                    RowBox[{"{", "}"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`annotation", ",", 
                    "VilTeX`Private`text", ",", "VilTeX`Private`coords", ",", 
                    "VilTeX`Private`options", ",", "VilTeX`Private`xPos", ",",
                     "VilTeX`Private`yPos", ",", "VilTeX`Private`zPos", ",", 
                    "VilTeX`Private`textOptions", ",", 
                    "VilTeX`Private`validCoords"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`annotation", "=", 
                    
                    RowBox[{"VilTeX`Private`textAnnotations", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`text", "=", "\"\""}], ";", 
                    RowBox[{"VilTeX`Private`textOptions", "=", "\"\""}], ";", 
                    
                    RowBox[{"VilTeX`Private`validCoords", "=", "False"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`annotation", "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`annotation", "]"}],
                     "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`text", "=", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "\[Equal]", "3"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`coords", "=", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`coords", ",", "NumericQ"}], "]"}],
                     ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xPos", ",", "VilTeX`Private`yPos",
                     ",", "VilTeX`Private`zPos"}], "}"}], "=", 
                    RowBox[{"N", "[", "VilTeX`Private`coords", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`validCoords", "=", "True"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`annotation", "]"}],
                     "\[GreaterEqual]", "3"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`options", "=", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`options", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`options", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`key", ",", "VilTeX`Private`val"}],
                     "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`options", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`val", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`options", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "\[Equal]", "\"color\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", "\"text=\"", 
                    "<>", "VilTeX`Private`val", "<>", "\",\""}]}], ",", 
                    RowBox[{"VilTeX`Private`key", "\[Equal]", "\"size\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", "\"font=\"", 
                    "<>", "VilTeX`Private`val", "<>", "\",\""}]}], ",", 
                    RowBox[{"VilTeX`Private`key", "\[Equal]", "\"anchor\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", 
                    "\"anchor=\"", "<>", "VilTeX`Private`val", "<>", 
                    "\",\""}]}], ",", 
                    RowBox[{"VilTeX`Private`key", "\[Equal]", "\"rotate\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", 
                    "\"rotate=\"", "<>", "VilTeX`Private`val", "<>", 
                    "\",\""}]}], ",", "True", ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", 
                    "VilTeX`Private`key", "<>", "\"=\"", "<>", 
                    "VilTeX`Private`val", "<>", "\",\""}]}]}], "]"}], ";"}]}],
                     "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`options", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`text", "]"}], 
                    "&&", 
                    RowBox[{"VilTeX`Private`text", "\[NotEqual]", "\"\""}], 
                    "&&", "VilTeX`Private`validCoords", "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xPos", ",", "VilTeX`Private`yPos",
                     ",", "VilTeX`Private`zPos"}], "}"}], ",", "NumericQ"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"StringLength", "[", "VilTeX`Private`textOptions",
                     "]"}], ">", "0"}], "&&", 
                    RowBox[{
                    RowBox[{"StringTake", "[", 
                    RowBox[{"VilTeX`Private`textOptions", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "\[Equal]", "\",\""}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    RowBox[{"StringDrop", "[", 
                    RowBox[{"VilTeX`Private`textOptions", ",", 
                    RowBox[{"-", "1"}]}], "]"}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`processedAnnotations", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`text", ",", "VilTeX`Private`xPos",
                     ",", "VilTeX`Private`yPos", ",", "VilTeX`Private`zPos", 
                    ",", "VilTeX`Private`textOptions"}], "}"}]}], "]"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`textAnnotations", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`text", ",", "VilTeX`Private`x", 
                    ",", "VilTeX`Private`y", ",", "VilTeX`Private`z", ",", 
                    "VilTeX`Private`opts"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`text", ",", "VilTeX`Private`x", 
                    ",", "VilTeX`Private`y", ",", "VilTeX`Private`z", ",", 
                    "VilTeX`Private`opts"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`processedAnnotations", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`textTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`textTikzCode", "<>", 
                    "\"\\\\node[\"", "<>", "VilTeX`Private`opts", "<>", 
                    "\"] at (axis cs:\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`x", "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`y", "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`z", "]"}], "<>", "\") {\"", "<>", 
                    "VilTeX`Private`text", "<>", "\"};\\n\""}]}], ";"}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    
                    RowBox[{"Length", "[", 
                    "VilTeX`Private`processedAnnotations", "]"}]}], "}"}]}], 
                    "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"StringLength", "[", 
                    "VilTeX`Private`combinedTikzCode", "]"}], "<", "10"}], 
                    ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: No se gener\[OAcute] c\[OAcute]digo TikZ v\
\[AAcute]lido\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"\"\\\\begin{tikzpicture}\\n\"", "<>", 
                    "\"\\\\begin{axis}[\\n\"", "<>", "\"  xlabel={$x$},\\n\"",
                     "<>", "\"  ylabel={$y$},\\n\"", "<>", 
                    "\"  zlabel={$z$},\\n\"", "<>", "\"  \"", "<>", 
                    "VilTeX`Private`colormapStyle", "<>", "\",\\n\"", "<>", 
                    RowBox[{"If", "[", 
                    
                    RowBox[{"VilTeX`Private`grid", ",", 
                    "\"  grid=major,\\n\"", ",", "\"\""}], "]"}], "<>", 
                    "\"  view={60}{30},\\n\"", "<>", "\"  \"", "<>", 
                    "VilTeX`Private`axisConfiguration", "<>", "\",\\n\"", 
                    "<>", 
                    
                    RowBox[{"VilTeX`Private`generateAxisLimitsString", "[", 
                    "VilTeX`Private`globalLimits", "]"}], "<>", 
                    "\"  axis equal=false,\\n\"", "<>", 
                    "\"  samples=50,\\n\"", "<>", "\"  point meta=z\\n\"", 
                    "<>", "\"]\\n\"", "<>", "VilTeX`Private`combinedTikzCode",
                     "<>", "VilTeX`Private`textTikzCode", "<>", 
                    "\"\\\\end{axis}\\n\"", "<>", 
                    "\"\\\\end{tikzpicture}\""}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", "<>", 
                    "\"\\\\usepackage{tikz}\\n\"", "<>", 
                    "\"\\\\usepackage{pgfplots}\\n\"", "<>", 
                    "\"\\\\usepackage{amsmath}\\n\"", "<>", 
                    "\"\\\\usepackage{amssymb}\\n\"", "<>", 
                    "\"\\\\pgfplotsset{compat=1.18}\\n\"", "<>", 
                    "\"\\\\usepgfplotslibrary{colorbrewer}\\n\"", "<>", 
                    "\"\\\\usepgfplotslibrary{colormaps}\\n\"", "<>", 
                    "\"\\n\\\\begin{document}\\n\"", "<>", 
                    "VilTeX`Private`tikzCode", "<>", 
                    "\"\\n\\\\end{document}\""}]}], ";", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`ExportToTikZ3D\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportToTikZ3D[plotArgs, filename] exporta gr\
\[AAcute]ficos 3D de Mathematica a c\[OAcute]digo TikZ/PGFPlots para \
LaTeX.\\n\\nExportToTikZ3D[plotArgs, filename, grid, color, samples, \
axisType, colormap, opacity, axisExtension, maxPointsImplicit, \
textAnnotations] exporta con opciones espec\[IAcute]ficas.\\n\\nPAR\
\[CapitalAAcute]METROS REQUERIDOS:\\n- plotArgs: Argumentos del \
gr\[AAcute]fico 3D. Puede ser un gr\[AAcute]fico individual o lista de m\
\[UAcute]ltiples gr\[AAcute]ficos.\\n- filename: String con nombre del \
archivo de salida (debe terminar en '.tex').\\n\\nOPCIONES DISPONIBLES:\\n- \
grid (por defecto: True): Boolean. Controla si se muestra la \
cuadr\[IAcute]cula.\\n  - True: Muestra cuadr\[IAcute]cula\\n  - False: Sin \
cuadr\[IAcute]cula\\n\\n- color (por defecto: 'blue'): String. Color \
principal del gr\[AAcute]fico.\\n  - COLORES B\[CapitalAAcute]SICOS: 'black', \
'blue', 'brown', 'cyan', 'darkgray', 'gray', 'green', 'lightgray', 'lime', \
'magenta', 'olive', 'orange', 'pink', 'purple', 'red', 'teal', 'violet', \
'white', 'yellow'\\n  - COLORES MEZCLADOS: 'blue!50!red', 'green!70!black', \
'red!20!blue!80!green', 'yellow!75!red'\\n  - Para m\[UAcute]ltiples gr\
\[AAcute]ficos se asignan autom\[AAcute]ticamente: 'blue', 'red', \
'green!70!black', 'orange', 'purple', 'brown', 'pink', 'gray', 'cyan', \
'magenta'\\n\\n- samples (por defecto: 30): Integer. N\[UAcute]mero de \
muestras para generar superficies.\\n  - Rango recomendado: 10-100\\n  - \
Valores altos = mayor resoluci\[OAcute]n pero archivos m\[AAcute]s grandes\\n \
 - Se ajusta autom\[AAcute]ticamente para m\[UAcute]ltiples \
gr\[AAcute]ficos\\n\\n- axisType (por defecto: 'box'): String. Estilo de los \
ejes.\\n  - 'box': Ejes en forma de caja completa\\n  - 'center': Ejes \
centrados con flechas\\n  - 'none': Sin ejes visibles\\n\\n- colormap (por \
defecto: 'viridis'): String. Mapa de colores para superficies con gradientes.\
\\n  - COLORMAPS DISPONIBLES (exactamente estos):\\n    * 'viridis': \
Verde-azul-violeta (perceptualmente uniforme, recomendado para datos cient\
\[IAcute]ficos)\\n    * 'cool': Cian a magenta (bueno para datos que van de \
fr\[IAcute]o a caliente)\\n    * 'hot': Negro-rojo-amarillo-blanco (cl\
\[AAcute]sico mapa de calor)\\n    * 'jet': Azul-cian-amarillo-rojo (colorido \
pero no perceptualmente uniforme)\\n    * 'hsv': Espectro completo HSV \
circular\\n    * 'spring': Magenta-amarillo (tonos primaverales)\\n    * \
'summer': Verde-amarillo (tonos veraniegos)\\n    * 'autumn': Rojo-amarillo \
(tonos oto\[NTilde]ales)\\n    * 'winter': Azul-verde (tonos invernales)\\n   \
 * 'gray': Escala de grises (negro a blanco)\\n    * 'blackwhite': Alias para \
escala de grises\\n\\n- opacity (por defecto: 1.0): Real entre 0.0 y 1.0. \
Transparencia del gr\[AAcute]fico.\\n  - 1.0 = completamente opaco\\n  - 0.0 \
= completamente transparente\\n  - Valores intermedios: 0.1 (muy \
transparente), 0.3 (transparente), 0.5 (semi-transparente), 0.7 (poco \
transparente), 0.9 (casi opaco)\\n\\n- axisExtension (por defecto: 0.0): Real \
\[GreaterEqual] 0.0. Extensi\[OAcute]n adicional de l\[IAcute]mites de \
ejes.\\n  - Fracci\[OAcute]n del rango de datos\\n  - Solo efectivo con \
axisType -> 'center'\\n  - Ejemplo: 0.1 extiende ejes 10% m\[AAcute]s all\
\[AAcute] de los datos\\n\\n- maxPointsImplicit (por defecto: 8000): Integer \
\[GreaterEqual] 100. M\[AAcute]ximo n\[UAcute]mero de puntos para superficies \
impl\[IAcute]citas.\\n  - Controla balance entre calidad y rendimiento\\n  - \
Se distribuye autom\[AAcute]ticamente entre m\[UAcute]ltiples \
gr\[AAcute]ficos\\n\\n- textAnnotations (por defecto: {}): List. Anotaciones \
de texto en el gr\[AAcute]fico.\\n  - Formato: {{'texto', {x, y, z}}, \
{'texto', {x, y, z}, opciones}, ...}\\n  - Cada anotaci\[OAcute]n: {'string', \
{coordenadas 3D}, opciones (opcional)}\\n  - Opciones de formato disponibles:\
\\n    * {'color', 'red'}: Color del texto (acepta todos los colores listados \
arriba)\\n    * {'size', '\\\\large'}: Tama\[NTilde]o del texto\\n      - \
Tama\[NTilde]os LaTeX: '\\\\tiny', '\\\\scriptsize', '\\\\footnotesize', \
'\\\\small', '\\\\normalsize', '\\\\large', '\\\\Large', '\\\\huge', \
'\\\\Huge'\\n    * {'anchor', 'north'}: Anclaje del texto\\n      - Opciones: \
'north', 'south', 'east', 'west', 'north east', 'north west', 'south east', \
'south west', 'center'\\n    * {'rotate', '45'}: Rotaci\[OAcute]n en grados \
(0-360)\\n\\nTIPOS DE GR\[CapitalAAcute]FICOS SOPORTADOS:\\n1. Plot3D: {funci\
\[OAcute]n, {x, xmin, xmax}, {y, ymin, ymax}}\\n2. ParametricPlot3D (curva): \
{{x[t], y[t], z[t]}, {t, tmin, tmax}}\\n3. ParametricPlot3D (superficie): \
{{x[u,v], y[u,v], z[u,v]}, {u, umin, umax}, {v, vmin, vmax}}\\n4. \
ContourPlot3D: {ecuaci\[OAcute]n == 0, {x, xmin, xmax}, {y, ymin, ymax}, {z, \
zmin, zmax}}\\n5. M\[UAcute]ltiples gr\[AAcute]ficos: Lista de cualquiera de \
los tipos anteriores (Show)\\n\\nVALOR DE RETORNO:\\nString con la ruta \
completa del archivo .tex generado, o $Failed si hay error.\\n\\nEJEMPLOS DE \
COLORES Y COLORMAPS:\\n- ExportToTikZ3D[{x^2 + y^2, {x, -2, 2}, {y, -2, 2}}, \
'plot1.tex', color -> 'RoyalBlue']\\n- ExportToTikZ3D[{x^2 + y^2, {x, -2, 2}, \
{y, -2, 2}}, 'plot2.tex', color -> 'green!70!black', colormap -> 'hot']\\n- \
ExportToTikZ3D[{x^2 + y^2, {x, -2, 2}, {y, -2, 2}}, 'plot3.tex', color -> \
'RGB{255,100,50}', colormap -> 'viridis']\\n- ExportToTikZ3D[{x^2 + y^2, {x, \
-2, 2}, {y, -2, 2}}, 'plot4.tex', color -> 'HTML{FF6B35}', colormap -> \
'cool', opacity -> 0.7]\\n\\nOTROS EJEMPLOS:\\n- ExportToTikZ3D[{x^2 + y^2, \
{x, -2, 2}, {y, -2, 2}}, 'paraboloid.tex']\\n- ExportToTikZ3D[{x^2 + y^2, {x, \
-2, 2}, {y, -2, 2}}, 'plot.tex', True, 'red', 40, 'center', 'hot', 0.8, 0.1, \
5000, {}]\\n- ExportToTikZ3D[{{Cos[t], Sin[t], t/2}, {t, 0, 4Pi}}, \
'helix.tex', grid -> False, color -> 'green!70!black']\\n- \
ExportToTikZ3D[{x^2 + y^2 + z^2 == 4, {x, -2, 2}, {y, -2, 2}, {z, -2, 2}}, \
'sphere.tex', maxPointsImplicit -> 10000, colormap -> 'jet']\\n- \
ExportToTikZ3D[{x^2 + y^2, {x, -2, 2}, {y, -2, 2}}, 'annotated.tex', \
textAnnotations -> {{'Origen', {0, 0, 0}, {{'color', 'purple'}, {'size', \
'\\\\Large'}}}, {'M\[AAcute]ximo', {0, 0, 4}, {{'color', 'red!80!black'}, \
{'size', '\\\\large'}, {'anchor', 'south'}}}}]\\n\\nNOTAS:\\n- El archivo se \
guarda en $HomeDirectory/Downloads/[basename]/\\n- Se crea \
autom\[AAcute]ticamente una carpeta con el nombre base del archivo\\n- El \
archivo generado es un documento LaTeX completo listo para compilar\\n- \
Requiere paquetes LaTeX: tikz, pgfplots, amsmath, amssymb, xcolor\\n- Los \
colormaps son exactamente los 11 especificados (no hay otros disponibles)\\n- \
Los colores pueden ser cualquier especificaci\[OAcute]n v\[AAcute]lida de \
TikZ/xcolor\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ExportToTikZ3D[plotArgs, filename] exporta gr\[AAcute]ficos 3D de \
Mathematica a c\[OAcute]digo TikZ/PGFPlots para LaTeX.\n\n\
ExportToTikZ3D[plotArgs, filename, grid, color, samples, axisType, colormap, \
opacity, axisExtension, maxPointsImplicit, textAnnotations] exporta con \
opciones espec\[IAcute]ficas.\n\nPAR\[CapitalAAcute]METROS REQUERIDOS:\n- \
plotArgs: Argumentos del gr\[AAcute]fico 3D. Puede ser un gr\[AAcute]fico \
individual o lista de m\[UAcute]ltiples gr\[AAcute]ficos.\n- filename: String \
con nombre del archivo de salida (debe terminar en '.tex').\n\nOPCIONES \
DISPONIBLES:\n- grid (por defecto: True): Boolean. Controla si se muestra la \
cuadr\[IAcute]cula.\n  - True: Muestra cuadr\[IAcute]cula\n  - False: Sin \
cuadr\[IAcute]cula\n\n- color (por defecto: 'blue'): String. Color principal \
del gr\[AAcute]fico.\n  - COLORES B\[CapitalAAcute]SICOS: 'black', 'blue', \
'brown', 'cyan', 'darkgray', 'gray', 'green', 'lightgray', 'lime', 'magenta', \
'olive', 'orange', 'pink', 'purple', 'red', 'teal', 'violet', 'white', \
'yellow'\n  - COLORES MEZCLADOS: 'blue!50!red', 'green!70!black', \
'red!20!blue!80!green', 'yellow!75!red'\n  - Para m\[UAcute]ltiples gr\
\[AAcute]ficos se asignan autom\[AAcute]ticamente: 'blue', 'red', \
'green!70!black', 'orange', 'purple', 'brown', 'pink', 'gray', 'cyan', \
'magenta'\n\n- samples (por defecto: 30): Integer. N\[UAcute]mero de muestras \
para generar superficies.\n  - Rango recomendado: 10-100\n  - Valores altos = \
mayor resoluci\[OAcute]n pero archivos m\[AAcute]s grandes\n  - Se ajusta \
autom\[AAcute]ticamente para m\[UAcute]ltiples gr\[AAcute]ficos\n\n- axisType \
(por defecto: 'box'): String. Estilo de los ejes.\n  - 'box': Ejes en forma \
de caja completa\n  - 'center': Ejes centrados con flechas\n  - 'none': Sin \
ejes visibles\n\n- colormap (por defecto: 'viridis'): String. Mapa de colores \
para superficies con gradientes.\n  - COLORMAPS DISPONIBLES (exactamente \
estos):\n    * 'viridis': Verde-azul-violeta (perceptualmente uniforme, \
recomendado para datos cient\[IAcute]ficos)\n    * 'cool': Cian a magenta \
(bueno para datos que van de fr\[IAcute]o a caliente)\n    * 'hot': \
Negro-rojo-amarillo-blanco (cl\[AAcute]sico mapa de calor)\n    * 'jet': \
Azul-cian-amarillo-rojo (colorido pero no perceptualmente uniforme)\n    * \
'hsv': Espectro completo HSV circular\n    * 'spring': Magenta-amarillo \
(tonos primaverales)\n    * 'summer': Verde-amarillo (tonos veraniegos)\n    \
* 'autumn': Rojo-amarillo (tonos oto\[NTilde]ales)\n    * 'winter': \
Azul-verde (tonos invernales)\n    * 'gray': Escala de grises (negro a \
blanco)\n    * 'blackwhite': Alias para escala de grises\n\n- opacity (por \
defecto: 1.0): Real entre 0.0 y 1.0. Transparencia del gr\[AAcute]fico.\n  - \
1.0 = completamente opaco\n  - 0.0 = completamente transparente\n  - Valores \
intermedios: 0.1 (muy transparente), 0.3 (transparente), 0.5 \
(semi-transparente), 0.7 (poco transparente), 0.9 (casi opaco)\n\n- \
axisExtension (por defecto: 0.0): Real \[GreaterEqual] 0.0. Extensi\[OAcute]n \
adicional de l\[IAcute]mites de ejes.\n  - Fracci\[OAcute]n del rango de \
datos\n  - Solo efectivo con axisType -> 'center'\n  - Ejemplo: 0.1 extiende \
ejes 10% m\[AAcute]s all\[AAcute] de los datos\n\n- maxPointsImplicit (por \
defecto: 8000): Integer \[GreaterEqual] 100. M\[AAcute]ximo n\[UAcute]mero de \
puntos para superficies impl\[IAcute]citas.\n  - Controla balance entre \
calidad y rendimiento\n  - Se distribuye autom\[AAcute]ticamente entre m\
\[UAcute]ltiples gr\[AAcute]ficos\n\n- textAnnotations (por defecto: {}): \
List. Anotaciones de texto en el gr\[AAcute]fico.\n  - Formato: {{'texto', \
{x, y, z}}, {'texto', {x, y, z}, opciones}, ...}\n  - Cada anotaci\[OAcute]n: \
{'string', {coordenadas 3D}, opciones (opcional)}\n  - Opciones de formato \
disponibles:\n    * {'color', 'red'}: Color del texto (acepta todos los \
colores listados arriba)\n    * {'size', '\\large'}: Tama\[NTilde]o del texto\
\n      - Tama\[NTilde]os LaTeX: '\\tiny', '\\scriptsize', '\\footnotesize', \
'\\small', '\\normalsize', '\\large', '\\Large', '\\huge', '\\Huge'\n    * \
{'anchor', 'north'}: Anclaje del texto\n      - Opciones: 'north', 'south', \
'east', 'west', 'north east', 'north west', 'south east', 'south west', \
'center'\n    * {'rotate', '45'}: Rotaci\[OAcute]n en grados (0-360)\n\nTIPOS \
DE GR\[CapitalAAcute]FICOS SOPORTADOS:\n1. Plot3D: {funci\[OAcute]n, {x, \
xmin, xmax}, {y, ymin, ymax}}\n2. ParametricPlot3D (curva): {{x[t], y[t], \
z[t]}, {t, tmin, tmax}}\n3. ParametricPlot3D (superficie): {{x[u,v], y[u,v], \
z[u,v]}, {u, umin, umax}, {v, vmin, vmax}}\n4. ContourPlot3D: \
{ecuaci\[OAcute]n == 0, {x, xmin, xmax}, {y, ymin, ymax}, {z, zmin, zmax}}\n\
5. M\[UAcute]ltiples gr\[AAcute]ficos: Lista de cualquiera de los tipos \
anteriores (Show)\n\nVALOR DE RETORNO:\nString con la ruta completa del \
archivo .tex generado, o $Failed si hay error.\n\nEJEMPLOS DE COLORES Y \
COLORMAPS:\n- ExportToTikZ3D[{x^2 + y^2, {x, -2, 2}, {y, -2, 2}}, \
'plot1.tex', color -> 'RoyalBlue']\n- ExportToTikZ3D[{x^2 + y^2, {x, -2, 2}, \
{y, -2, 2}}, 'plot2.tex', color -> 'green!70!black', colormap -> 'hot']\n- \
ExportToTikZ3D[{x^2 + y^2, {x, -2, 2}, {y, -2, 2}}, 'plot3.tex', color -> \
'RGB{255,100,50}', colormap -> 'viridis']\n- ExportToTikZ3D[{x^2 + y^2, {x, \
-2, 2}, {y, -2, 2}}, 'plot4.tex', color -> 'HTML{FF6B35}', colormap -> \
'cool', opacity -> 0.7]\n\nOTROS EJEMPLOS:\n- ExportToTikZ3D[{x^2 + y^2, {x, \
-2, 2}, {y, -2, 2}}, 'paraboloid.tex']\n- ExportToTikZ3D[{x^2 + y^2, {x, -2, \
2}, {y, -2, 2}}, 'plot.tex', True, 'red', 40, 'center', 'hot', 0.8, 0.1, \
5000, {}]\n- ExportToTikZ3D[{{Cos[t], Sin[t], t/2}, {t, 0, 4Pi}}, \
'helix.tex', grid -> False, color -> 'green!70!black']\n- ExportToTikZ3D[{x^2 \
+ y^2 + z^2 == 4, {x, -2, 2}, {y, -2, 2}, {z, -2, 2}}, 'sphere.tex', \
maxPointsImplicit -> 10000, colormap -> 'jet']\n- ExportToTikZ3D[{x^2 + y^2, \
{x, -2, 2}, {y, -2, 2}}, 'annotated.tex', textAnnotations -> {{'Origen', {0, \
0, 0}, {{'color', 'purple'}, {'size', '\\Large'}}}, {'M\[AAcute]ximo', {0, 0, \
4}, {{'color', 'red!80!black'}, {'size', '\\large'}, {'anchor', 'south'}}}}]\n\
\nNOTAS:\n- El archivo se guarda en $HomeDirectory/Downloads/[basename]/\n- \
Se crea autom\[AAcute]ticamente una carpeta con el nombre base del archivo\n- \
El archivo generado es un documento LaTeX completo listo para compilar\n- \
Requiere paquetes LaTeX: tikz, pgfplots, amsmath, amssymb, xcolor\n- Los \
colormaps son exactamente los 11 especificados (no hay otros disponibles)\n- \
Los colores pueden ser cualquier especificaci\[OAcute]n v\[AAcute]lida de \
TikZ/xcolor", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`ExportToTikZ3D, {VilTeX`ExportToTikZ3D[
         Pattern[VilTeX`Private`plotArgs, 
          Blank[]], 
         Pattern[VilTeX`Private`filename, 
          Blank[]], 
         Optional[
          Pattern[VilTeX`Private`grid, 
           Blank[]], True], 
         Optional[
          Pattern[VilTeX`Private`color, 
           Blank[]], "blue"], 
         Optional[
          Pattern[VilTeX`Private`samples, 
           Blank[]], 30], 
         Optional[
          Pattern[VilTeX`Private`axisType, 
           Blank[]], "box"], 
         Optional[
          Pattern[VilTeX`Private`colormap, 
           Blank[]], "viridis"], 
         Optional[
          Pattern[VilTeX`Private`opacity, 
           Blank[]], 1.], 
         Optional[
          Pattern[VilTeX`Private`axisExtension, 
           Blank[]], 0.], 
         Optional[
          Pattern[VilTeX`Private`maxPointsImplicit, 
           Blank[]], 8000], 
         Optional[
          Pattern[VilTeX`Private`textAnnotations, 
           Blank[]], {}]] :> 
       Module[{VilTeX`Private`data, VilTeX`Private`tikzCode, 
          VilTeX`Private`fullDocument, VilTeX`Private`downloadPath, 
          VilTeX`Private`folderName, VilTeX`Private`folderPath, 
          VilTeX`Private`formatNumber, VilTeX`Private`validNumber, 
          VilTeX`Private`plotType, VilTeX`Private`func, VilTeX`Private`xRange,
           VilTeX`Private`yRange, VilTeX`Private`zRange, 
          VilTeX`Private`tRange, VilTeX`Private`paramFuncs, 
          VilTeX`Private`surfaceData, VilTeX`Private`axisConfiguration, 
          VilTeX`Private`colormapStyle, VilTeX`Private`opacityStyle, 
          VilTeX`Private`equation, VilTeX`Private`targetValue, 
          VilTeX`Private`effectiveSamples, VilTeX`Private`multipleGraphs, 
          VilTeX`Private`graphList, VilTeX`Private`allPlotData, 
          VilTeX`Private`globalLimits, VilTeX`Private`combinedTikzCode, 
          VilTeX`Private`currentGraph, VilTeX`Private`currentPlotType, 
          VilTeX`Private`currentData, VilTeX`Private`currentSurfaceData, 
          VilTeX`Private`allLimits, VilTeX`Private`colors, 
          VilTeX`Private`allValidData, VilTeX`Private`textTikzCode}, 
         Clear[VilTeX`Private`calculateExtendedLimits, 
           VilTeX`Private`combineGlobalLimits, 
           VilTeX`Private`generateAxisLimitsString, 
           VilTeX`Private`generateImplicitSurfaceMejorada, 
           VilTeX`Private`determineGraphType]; If[
           Not[
            StringQ[VilTeX`Private`filename]], 
           Print["Error: filename debe ser un string"]; Return[$Failed]; 
           Null]; If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], 
           Print["Error: filename debe terminar en .tex"]; Return[$Failed]; 
           Null]; If[
           Not[
            BooleanQ[VilTeX`Private`grid]], 
           Print["Error: grid debe ser True o False"]; Return[$Failed]; Null]; 
         If[
           Not[
            MemberQ[{"box", "center", "none"}, VilTeX`Private`axisType]], 
           Print["Error: axisType debe ser \"box\", \"center\" o \"none\""]; 
           Return[$Failed]; Null]; If[
           Not[
            
            MemberQ[{
             "viridis", "cool", "hot", "jet", "hsv", "spring", "summer", 
              "autumn", "winter", "gray", "blackwhite"}, 
             VilTeX`Private`colormap]], 
           Print["Error: colormap no v\[AAcute]lido"]; Return[$Failed]; Null]; 
         If[
           Or[
            Not[
             NumericQ[VilTeX`Private`opacity]], VilTeX`Private`opacity < 0, 
            VilTeX`Private`opacity > 1], 
           Print["Error: opacity debe ser un n\[UAcute]mero entre 0 y 1"]; 
           Return[$Failed]; Null]; If[
           Or[
            Not[
             NumericQ[VilTeX`Private`axisExtension]], 
            VilTeX`Private`axisExtension < 0], 
           Print["Error: axisExtension debe ser un n\[UAcute]mero >= 0"]; 
           Return[$Failed]; Null]; If[
           Or[
            Not[
             IntegerQ[VilTeX`Private`maxPointsImplicit]], 
            VilTeX`Private`maxPointsImplicit < 100], 
           Print["Error: maxPointsImplicit debe ser un entero >= 100"]; 
           Return[$Failed]; Null]; If[
           Not[
            Or[
             ListQ[VilTeX`Private`textAnnotations], 
             VilTeX`Private`textAnnotations === {}]], 
           Print["Error: textAnnotations debe ser una lista"]; 
           Return[$Failed]; Null]; VilTeX`Private`multipleGraphs = False; 
         VilTeX`Private`graphList = {}; If[
           And[
            ListQ[VilTeX`Private`plotArgs], Length[VilTeX`Private`plotArgs] >= 
            2], If[
             And[
              AllTrue[VilTeX`Private`plotArgs, ListQ], 
              Length[VilTeX`Private`plotArgs] >= 2], 
             Module[{VilTeX`Private`isMultiple = True}, If[
                 And[Length[VilTeX`Private`plotArgs] == 2, 
                  ListQ[
                   Part[VilTeX`Private`plotArgs, 1]], Length[
                    Part[VilTeX`Private`plotArgs, 1]] == 3, 
                  MatchQ[
                   Part[VilTeX`Private`plotArgs, 2], {
                    Blank[], 
                    Blank[], 
                    Blank[]}]], VilTeX`Private`isMultiple = False; Null]; 
               If[Length[VilTeX`Private`plotArgs] == 3, If[
                   And[
                    Not[
                    ListQ[
                    Part[VilTeX`Private`plotArgs, 1]]], 
                    MatchQ[
                    Part[VilTeX`Private`plotArgs, 2], {
                    Blank[], 
                    Blank[], 
                    Blank[]}], 
                    MatchQ[
                    Part[VilTeX`Private`plotArgs, 3], {
                    Blank[], 
                    Blank[], 
                    Blank[]}]], VilTeX`Private`isMultiple = False; Null]; If[
                   And[
                    ListQ[
                    Part[VilTeX`Private`plotArgs, 1]], Length[
                    Part[VilTeX`Private`plotArgs, 1]] == 3, 
                    MatchQ[
                    Part[VilTeX`Private`plotArgs, 2], {
                    Blank[], 
                    Blank[], 
                    Blank[]}], 
                    MatchQ[
                    Part[VilTeX`Private`plotArgs, 3], {
                    Blank[], 
                    Blank[], 
                    Blank[]}], 
                    AllTrue[
                    Part[VilTeX`Private`plotArgs, 1], Not[
                    ListQ[#]]& ]], VilTeX`Private`isMultiple = False; Null]; 
                 Null]; If[
                 And[Length[VilTeX`Private`plotArgs] == 4, Head[
                    Part[VilTeX`Private`plotArgs, 1]] === Equal, 
                  MatchQ[
                   Part[VilTeX`Private`plotArgs, 2], {
                    Blank[], 
                    Blank[], 
                    Blank[]}], 
                  MatchQ[
                   Part[VilTeX`Private`plotArgs, 3], {
                    Blank[], 
                    Blank[], 
                    Blank[]}], 
                  MatchQ[
                   Part[VilTeX`Private`plotArgs, 4], {
                    Blank[], 
                    Blank[], 
                    Blank[]}]], VilTeX`Private`isMultiple = False; Null]; 
               VilTeX`Private`multipleGraphs = VilTeX`Private`isMultiple; 
               Null]; Null]; Null]; 
         If[VilTeX`Private`multipleGraphs, 
           VilTeX`Private`graphList = VilTeX`Private`plotArgs; Null, 
           VilTeX`Private`graphList = {VilTeX`Private`plotArgs}; Null]; 
         VilTeX`Private`axisConfiguration = 
          Which[VilTeX`Private`axisType == "box", "axis lines=box", 
            VilTeX`Private`axisType == "center", 
            "axis lines=center, axis line style={->}", 
            VilTeX`Private`axisType == "none", "axis lines=none", True, 
            "axis lines=box"]; 
         VilTeX`Private`colormapStyle = 
          "colormap/" <> VilTeX`Private`colormap; 
         VilTeX`Private`opacityStyle = 
          If[VilTeX`Private`opacity < 
            1., ((", opacity=" <> ToString[VilTeX`Private`opacity]) <> 
             ", fill opacity=") <> ToString[VilTeX`Private`opacity], ""]; 
         VilTeX`Private`colors = {
           "blue", "red", "green!70!black", "orange", "purple", "brown", 
            "pink", "gray", "cyan", "magenta"}; VilTeX`Private`formatNumber[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := 
          Module[{VilTeX`Private`result, VilTeX`Private`num}, If[
              NumericQ[VilTeX`Private`x], 
              VilTeX`Private`num = N[VilTeX`Private`x]; 
              If[Abs[VilTeX`Private`num] < 10^(-10), VilTeX`Private`result = 
                "0", 
                If[
                Abs[VilTeX`Private`num] > 10^8, VilTeX`Private`result = 
                 ToString[
                   Round[VilTeX`Private`num, 1], InputForm], 
                 If[
                 Abs[VilTeX`Private`num] > 1000, VilTeX`Private`result = 
                  ToString[
                    Round[VilTeX`Private`num, 0.1], InputForm], 
                  VilTeX`Private`result = ToString[
                    Round[VilTeX`Private`num, 10^(-4)], InputForm]]]]; Null, 
              VilTeX`Private`result = "0"]; If[
              And[VilTeX`Private`multipleGraphs, 
               StringQ[VilTeX`Private`result]], 
              VilTeX`Private`result = ToString[
                 Round[
                  ToExpression[VilTeX`Private`result], 0.01], InputForm]; 
              Null]; If[
              StringQ[VilTeX`Private`result], VilTeX`Private`result, 
              ToString[VilTeX`Private`result]]]; VilTeX`Private`validNumber[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := And[
            NumericQ[VilTeX`Private`x], 
            Element[VilTeX`Private`x, Reals], Abs[VilTeX`Private`x] < 10^10]; 
         VilTeX`Private`calculateExtendedLimits[
            Pattern[VilTeX`Private`dataPoints, 
             Blank[]]] := 
          Module[{VilTeX`Private`xDataMin, VilTeX`Private`xDataMax, 
             VilTeX`Private`yDataMin, VilTeX`Private`yDataMax, 
             VilTeX`Private`zDataMin, VilTeX`Private`zDataMax, 
             VilTeX`Private`xRangeData, VilTeX`Private`yRangeData, 
             VilTeX`Private`zRangeData}, 
            If[
            Length[VilTeX`Private`dataPoints] > 0, 
             VilTeX`Private`xDataMin = Min[
                Part[VilTeX`Private`dataPoints, All, 1]]; 
             VilTeX`Private`xDataMax = Max[
                Part[VilTeX`Private`dataPoints, All, 1]]; 
             VilTeX`Private`yDataMin = Min[
                Part[VilTeX`Private`dataPoints, All, 2]]; 
             VilTeX`Private`yDataMax = Max[
                Part[VilTeX`Private`dataPoints, All, 2]]; 
             VilTeX`Private`zDataMin = Min[
                Part[VilTeX`Private`dataPoints, All, 3]]; 
             VilTeX`Private`zDataMax = Max[
                Part[VilTeX`Private`dataPoints, All, 3]]; If[
               And[
               VilTeX`Private`axisType == "center", 
                VilTeX`Private`axisExtension > 0], 
               VilTeX`Private`xRangeData = 
                VilTeX`Private`xDataMax - VilTeX`Private`xDataMin; 
               VilTeX`Private`yRangeData = 
                VilTeX`Private`yDataMax - VilTeX`Private`yDataMin; 
               VilTeX`Private`zRangeData = 
                VilTeX`Private`zDataMax - VilTeX`Private`zDataMin; 
               VilTeX`Private`xDataMin = 
                VilTeX`Private`xDataMin - VilTeX`Private`axisExtension 
                 VilTeX`Private`xRangeData; 
               VilTeX`Private`xDataMax = 
                VilTeX`Private`xDataMax + 
                 VilTeX`Private`axisExtension VilTeX`Private`xRangeData; 
               VilTeX`Private`yDataMin = 
                VilTeX`Private`yDataMin - VilTeX`Private`axisExtension 
                 VilTeX`Private`yRangeData; 
               VilTeX`Private`yDataMax = 
                VilTeX`Private`yDataMax + 
                 VilTeX`Private`axisExtension VilTeX`Private`yRangeData; 
               VilTeX`Private`zDataMin = 
                VilTeX`Private`zDataMin - VilTeX`Private`axisExtension 
                 VilTeX`Private`zRangeData; 
               VilTeX`Private`zDataMax = 
                VilTeX`Private`zDataMax + 
                 VilTeX`Private`axisExtension VilTeX`Private`zRangeData; 
               Null]; {
              VilTeX`Private`xDataMin, VilTeX`Private`xDataMax, 
               VilTeX`Private`yDataMin, VilTeX`Private`yDataMax, 
               VilTeX`Private`zDataMin, VilTeX`Private`zDataMax}, {-1, 1, -1, 
             1, -1, 1}]]; VilTeX`Private`combineGlobalLimits[
            Pattern[VilTeX`Private`limitsList, 
             Blank[]]] := 
          Module[{VilTeX`Private`xMins, VilTeX`Private`xMaxs, 
             VilTeX`Private`yMins, VilTeX`Private`yMaxs, VilTeX`Private`zMins,
              VilTeX`Private`zMaxs}, 
            If[
            Length[VilTeX`Private`limitsList] > 0, 
             VilTeX`Private`xMins = Part[VilTeX`Private`limitsList, All, 1]; 
             VilTeX`Private`xMaxs = Part[VilTeX`Private`limitsList, All, 2]; 
             VilTeX`Private`yMins = Part[VilTeX`Private`limitsList, All, 3]; 
             VilTeX`Private`yMaxs = Part[VilTeX`Private`limitsList, All, 4]; 
             VilTeX`Private`zMins = Part[VilTeX`Private`limitsList, All, 5]; 
             VilTeX`Private`zMaxs = Part[VilTeX`Private`limitsList, All, 6]; {
              
               Min[VilTeX`Private`xMins], 
               Max[VilTeX`Private`xMaxs], 
               Min[VilTeX`Private`yMins], 
               Max[VilTeX`Private`yMaxs], 
               Min[VilTeX`Private`zMins], 
               Max[VilTeX`Private`zMaxs]}, {-1, 1, -1, 1, -1, 1}]]; 
         VilTeX`Private`generateAxisLimitsString[
            Pattern[VilTeX`Private`limits, 
             Blank[]]] := 
          Module[{VilTeX`Private`xMin, VilTeX`Private`xMax, 
             VilTeX`Private`yMin, VilTeX`Private`yMax, VilTeX`Private`zMin, 
             VilTeX`Private`zMax}, {
              VilTeX`Private`xMin, VilTeX`Private`xMax, VilTeX`Private`yMin, 
               VilTeX`Private`yMax, VilTeX`Private`zMin, VilTeX`Private`zMax} = 
             VilTeX`Private`limits; If[
              Or[VilTeX`Private`multipleGraphs, 
               And[
               VilTeX`Private`axisType == "center", 
                VilTeX`Private`axisExtension > 
                0]], ((((((((((((("  xmin=" <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`xMin]) <> 
                    ", xmax=") <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`xMax]) <> 
                    ",\n") <> "  ymin=") <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`yMin]) <> 
                    ", ymax=") <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`yMax]) <> 
                   ",\n") <> "  zmin=") <> 
                 VilTeX`Private`formatNumber[VilTeX`Private`zMin]) <> 
                ", zmax=") <> 
               VilTeX`Private`formatNumber[VilTeX`Private`zMax]) <> ",\n", 
              ""]]; VilTeX`Private`generateImplicitSurfaceMejorada[
            Pattern[VilTeX`Private`equation, 
             Blank[]], 
            Pattern[VilTeX`Private`xRange, 
             Blank[]], 
            Pattern[VilTeX`Private`yRange, 
             Blank[]], 
            Pattern[VilTeX`Private`zRange, 
             Blank[]], 
            Pattern[VilTeX`Private`targetSamples, 
             Blank[]], 
            Pattern[VilTeX`Private`maxPointsLimit, 
             Blank[]]] := 
          Module[{VilTeX`Private`xVar, VilTeX`Private`xMin, 
             VilTeX`Private`xMax, VilTeX`Private`yVar, VilTeX`Private`yMin, 
             VilTeX`Private`yMax, VilTeX`Private`zVar, VilTeX`Private`zMin, 
             VilTeX`Private`zMax, VilTeX`Private`leftSide, 
             VilTeX`Private`rightSide, VilTeX`Private`implicitFunc, 
             VilTeX`Private`surfPoints, VilTeX`Private`zSolutions, 
             VilTeX`Private`tolerance, VilTeX`Private`currentPoints, 
             VilTeX`Private`adaptiveSamples}, {
              VilTeX`Private`xVar, VilTeX`Private`xMin, VilTeX`Private`xMax} = 
             VilTeX`Private`xRange; {
              VilTeX`Private`yVar, VilTeX`Private`yMin, VilTeX`Private`yMax} = 
             VilTeX`Private`yRange; {
              VilTeX`Private`zVar, VilTeX`Private`zMin, VilTeX`Private`zMax} = 
             VilTeX`Private`zRange; 
            VilTeX`Private`leftSide = Part[VilTeX`Private`equation, 1]; 
            VilTeX`Private`rightSide = Part[VilTeX`Private`equation, 2]; 
            VilTeX`Private`implicitFunc = 
             VilTeX`Private`leftSide - VilTeX`Private`rightSide; 
            VilTeX`Private`surfPoints = {}; VilTeX`Private`tolerance = 0.001; 
            VilTeX`Private`currentPoints = 0; If[
              FreeQ[VilTeX`Private`equation, VilTeX`Private`zVar], 
              Module[{VilTeX`Private`equation2D, VilTeX`Private`xVals, 
                 VilTeX`Private`yVals, VilTeX`Private`zVals, 
                 VilTeX`Private`zSteps}, 
                VilTeX`Private`equation2D = VilTeX`Private`equation; 
                VilTeX`Private`xVals = 
                 Table[VilTeX`Private`xMin + (VilTeX`Private`xMax - 
                    VilTeX`Private`xMin) (VilTeX`Private`i/(
                    VilTeX`Private`targetSamples - 1)), {
                   VilTeX`Private`i, 0, VilTeX`Private`targetSamples - 1}]; 
                VilTeX`Private`yVals = 
                 Table[VilTeX`Private`yMin + (VilTeX`Private`yMax - 
                    VilTeX`Private`yMin) (VilTeX`Private`j/(
                    VilTeX`Private`targetSamples - 1)), {
                   VilTeX`Private`j, 0, VilTeX`Private`targetSamples - 1}]; 
                VilTeX`Private`zSteps = 
                 Min[VilTeX`Private`targetSamples 2, 60]; 
                VilTeX`Private`zVals = 
                 Table[VilTeX`Private`zMin + (VilTeX`Private`zMax - 
                    VilTeX`Private`zMin) (VilTeX`Private`k/(
                    VilTeX`Private`zSteps - 1)), {
                   VilTeX`Private`k, 0, VilTeX`Private`zSteps - 1}]; Do[Do[
                    
                    Module[{VilTeX`Private`equation2DValue}, 
                    VilTeX`Private`equation2DValue = Quiet[
                    N[
                    ReplaceAll[
                    VilTeX`Private`leftSide - VilTeX`Private`rightSide, {
                    VilTeX`Private`xVar -> 
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    VilTeX`Private`yVar -> 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j]}]]]; If[
                    And[
                    VilTeX`Private`validNumber[
                    VilTeX`Private`equation2DValue], 
                    Abs[VilTeX`Private`equation2DValue] < 
                    VilTeX`Private`tolerance, VilTeX`Private`currentPoints < 
                    VilTeX`Private`maxPointsLimit], 
                    Do[VilTeX`Private`surfPoints = 
                    Append[VilTeX`Private`surfPoints, {
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j], 
                    Part[VilTeX`Private`zVals, VilTeX`Private`k]}]; 
                    Increment[VilTeX`Private`currentPoints]; 
                    If[VilTeX`Private`currentPoints >= 
                    VilTeX`Private`maxPointsLimit, 
                    Break[]]; Null, {VilTeX`Private`k, 
                    Length[VilTeX`Private`zVals]}]; Null]; Null], {
                    VilTeX`Private`j, 
                    Length[VilTeX`Private`yVals]}]; 
                  If[VilTeX`Private`currentPoints >= 
                    VilTeX`Private`maxPointsLimit, 
                    Break[]]; Null, {VilTeX`Private`i, 
                   Length[VilTeX`Private`xVals]}]; Null]; Null, 
              VilTeX`Private`zSolutions = Quiet[
                 Solve[VilTeX`Private`equation, VilTeX`Private`zVar, Reals]]; 
              If[
                And[Length[VilTeX`Private`zSolutions] > 0, 
                 FreeQ[
                  Part[VilTeX`Private`zSolutions, 1], Solve]], 
                Module[{
                  VilTeX`Private`zFunc, VilTeX`Private`xVals, 
                   VilTeX`Private`yVals, VilTeX`Private`validSolutions = {}}, 
                  Do[VilTeX`Private`zFunc = ReplaceAll[VilTeX`Private`zVar, 
                    Part[VilTeX`Private`zSolutions, VilTeX`Private`solIdx]]; 
                    If[
                    FreeQ[VilTeX`Private`zFunc, VilTeX`Private`zVar], 
                    VilTeX`Private`validSolutions = 
                    Append[VilTeX`Private`validSolutions, 
                    VilTeX`Private`zFunc]; Null], {VilTeX`Private`solIdx, 
                    Min[
                    Length[VilTeX`Private`zSolutions], 3]}]; 
                  If[Length[VilTeX`Private`validSolutions] > 0, 
                    VilTeX`Private`xVals = 
                    Table[VilTeX`Private`xMin + (VilTeX`Private`xMax - 
                    VilTeX`Private`xMin) (VilTeX`Private`i/(
                    VilTeX`Private`targetSamples 2 - 1)), {
                    VilTeX`Private`i, 0, VilTeX`Private`targetSamples 2 - 1}]; 
                    VilTeX`Private`yVals = 
                    Table[VilTeX`Private`yMin + (VilTeX`Private`yMax - 
                    VilTeX`Private`yMin) (VilTeX`Private`j/(
                    VilTeX`Private`targetSamples 2 - 1)), {
                    VilTeX`Private`j, 0, VilTeX`Private`targetSamples 2 - 1}]; 
                    Do[
                    Do[
                    Do[
                    
                    Module[{VilTeX`Private`zVal}, 
                    VilTeX`Private`zVal = Quiet[
                    N[
                    ReplaceAll[
                    Part[VilTeX`Private`validSolutions, VilTeX`Private`k], {
                    VilTeX`Private`xVar -> 
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    VilTeX`Private`yVar -> 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j]}]]]; If[
                    And[
                    VilTeX`Private`validNumber[VilTeX`Private`zVal], 
                    VilTeX`Private`zMin <= VilTeX`Private`zVal <= 
                    VilTeX`Private`zMax, VilTeX`Private`currentPoints < 
                    VilTeX`Private`maxPointsLimit], 
                    VilTeX`Private`surfPoints = 
                    Append[VilTeX`Private`surfPoints, {
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j], 
                    VilTeX`Private`zVal}]; 
                    Increment[VilTeX`Private`currentPoints]; Null]; Null], {
                    VilTeX`Private`k, 
                    Length[VilTeX`Private`validSolutions]}], {
                    VilTeX`Private`j, 
                    Length[VilTeX`Private`yVals]}], {VilTeX`Private`i, 
                    Length[VilTeX`Private`xVals]}]; Null]; Null]; Null, 
                VilTeX`Private`adaptiveSamples = Min[
                   Max[VilTeX`Private`targetSamples, 25], 
                   Floor[(VilTeX`Private`maxPointsImplicit 0.8)^(1/3)]]; 
                VilTeX`Private`adaptiveSamples = 
                 Max[VilTeX`Private`adaptiveSamples, 8]; 
                Module[{
                  VilTeX`Private`xVals, VilTeX`Private`yVals, 
                   VilTeX`Private`zVals}, 
                  VilTeX`Private`xVals = 
                   Table[VilTeX`Private`xMin + (VilTeX`Private`xMax - 
                    VilTeX`Private`xMin) (VilTeX`Private`i/(
                    VilTeX`Private`adaptiveSamples - 1)), {
                    VilTeX`Private`i, 0, VilTeX`Private`adaptiveSamples - 1}]; 
                  VilTeX`Private`yVals = 
                   Table[VilTeX`Private`yMin + (VilTeX`Private`yMax - 
                    VilTeX`Private`yMin) (VilTeX`Private`j/(
                    VilTeX`Private`adaptiveSamples - 1)), {
                    VilTeX`Private`j, 0, VilTeX`Private`adaptiveSamples - 1}]; 
                  VilTeX`Private`zVals = 
                   Table[VilTeX`Private`zMin + (VilTeX`Private`zMax - 
                    VilTeX`Private`zMin) (VilTeX`Private`k/(
                    VilTeX`Private`adaptiveSamples - 1)), {
                    VilTeX`Private`k, 0, VilTeX`Private`adaptiveSamples - 1}]; 
                  Do[
                    Do[
                    Do[
                    If[
                    VilTeX`Private`currentPoints < 
                    VilTeX`Private`maxPointsLimit, 
                    Module[{VilTeX`Private`funcVal}, 
                    VilTeX`Private`funcVal = Quiet[
                    N[
                    ReplaceAll[
                    VilTeX`Private`implicitFunc, {
                    VilTeX`Private`xVar -> 
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    VilTeX`Private`yVar -> 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j], 
                    VilTeX`Private`zVar -> 
                    Part[VilTeX`Private`zVals, VilTeX`Private`k]}]]]; If[
                    And[
                    VilTeX`Private`validNumber[VilTeX`Private`funcVal], 
                    Abs[VilTeX`Private`funcVal] < VilTeX`Private`tolerance], 
                    VilTeX`Private`surfPoints = 
                    Append[VilTeX`Private`surfPoints, {
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j], 
                    Part[VilTeX`Private`zVals, VilTeX`Private`k]}]; 
                    Increment[VilTeX`Private`currentPoints]; Null]; Null]; 
                    Null], {VilTeX`Private`k, 
                    Length[VilTeX`Private`zVals]}], {VilTeX`Private`j, 
                    Length[VilTeX`Private`yVals]}], {VilTeX`Private`i, 
                    Length[VilTeX`Private`xVals]}]; Null]; Null]; Null]; 
            If[Length[VilTeX`Private`surfPoints] > 
              VilTeX`Private`maxPointsLimit, 
              VilTeX`Private`surfPoints = 
               RandomSample[
                VilTeX`Private`surfPoints, VilTeX`Private`maxPointsLimit]; 
              Null]; VilTeX`Private`surfPoints]; 
         VilTeX`Private`determineGraphType[
            Pattern[VilTeX`Private`graphArgs, 
             Blank[]]] := Module[{}, 
            Which[
             And[Length[VilTeX`Private`graphArgs] == 4, Head[
                Part[VilTeX`Private`graphArgs, 1]] === Equal, 
              MatchQ[
               Part[VilTeX`Private`graphArgs, 2], {
                Blank[], 
                Blank[], 
                Blank[]}], 
              MatchQ[
               Part[VilTeX`Private`graphArgs, 3], {
                Blank[], 
                Blank[], 
                Blank[]}], 
              MatchQ[
               Part[VilTeX`Private`graphArgs, 4], {
                Blank[], 
                Blank[], 
                Blank[]}]], "ImplicitPlot3D", 
             And[Length[VilTeX`Private`graphArgs] == 3, 
              MatchQ[
               Part[VilTeX`Private`graphArgs, 2], {
                Blank[], 
                Blank[], 
                Blank[]}], 
              MatchQ[
               Part[VilTeX`Private`graphArgs, 3], {
                Blank[], 
                Blank[], 
                Blank[]}], 
              Not[
               ListQ[
                Part[VilTeX`Private`graphArgs, 1]]]], "Plot3D", 
             And[Length[VilTeX`Private`graphArgs] == 2, 
              ListQ[
               Part[VilTeX`Private`graphArgs, 1]], Length[
                Part[VilTeX`Private`graphArgs, 1]] == 3, 
              MatchQ[
               Part[VilTeX`Private`graphArgs, 2], {
                Blank[], 
                Blank[], 
                Blank[]}]], "ParametricPlot3D_Curve", 
             And[Length[VilTeX`Private`graphArgs] == 3, 
              ListQ[
               Part[VilTeX`Private`graphArgs, 1]], Length[
                Part[VilTeX`Private`graphArgs, 1]] == 3, 
              MatchQ[
               Part[VilTeX`Private`graphArgs, 2], {
                Blank[], 
                Blank[], 
                Blank[]}], 
              MatchQ[
               Part[VilTeX`Private`graphArgs, 3], {
                Blank[], 
                Blank[], 
                Blank[]}]], "ParametricPlot3D_Surface", True, "Unknown"]]; 
         VilTeX`Private`allPlotData = {}; VilTeX`Private`allLimits = {}; 
         VilTeX`Private`allValidData = {}; 
         Module[{VilTeX`Private`adjustedSamples, 
            VilTeX`Private`adjustedMaxPoints}, If[
             And[
             VilTeX`Private`multipleGraphs, Length[VilTeX`Private`graphList] > 
              1], VilTeX`Private`adjustedSamples = 
              Min[VilTeX`Private`samples, 25]; 
             VilTeX`Private`adjustedMaxPoints = 
              Min[VilTeX`Private`maxPointsImplicit, 
                Floor[8000/Length[VilTeX`Private`graphList]]]; Null, 
             VilTeX`Private`adjustedSamples = VilTeX`Private`samples; 
             VilTeX`Private`adjustedMaxPoints = 
              VilTeX`Private`maxPointsImplicit; Null]; 
           Do[VilTeX`Private`currentGraph = 
              Part[VilTeX`Private`graphList, VilTeX`Private`graphIdx]; 
             VilTeX`Private`currentPlotType = 
              VilTeX`Private`determineGraphType[VilTeX`Private`currentGraph]; 
             VilTeX`Private`currentData = {}; 
             VilTeX`Private`currentSurfaceData = {}; 
             Which[VilTeX`Private`currentPlotType == "ImplicitPlot3D", 
               VilTeX`Private`equation = Part[VilTeX`Private`currentGraph, 1]; 
               VilTeX`Private`xRange = Part[VilTeX`Private`currentGraph, 2]; 
               VilTeX`Private`yRange = Part[VilTeX`Private`currentGraph, 3]; 
               VilTeX`Private`zRange = Part[VilTeX`Private`currentGraph, 4]; 
               VilTeX`Private`currentSurfaceData = 
                VilTeX`Private`generateImplicitSurfaceMejorada[
                 VilTeX`Private`equation, VilTeX`Private`xRange, 
                  VilTeX`Private`yRange, VilTeX`Private`zRange, 
                  VilTeX`Private`adjustedSamples, 
                  VilTeX`Private`adjustedMaxPoints]; 
               If[Length[VilTeX`Private`currentSurfaceData] > 0, 
                 VilTeX`Private`allLimits = Append[VilTeX`Private`allLimits, 
                    VilTeX`Private`calculateExtendedLimits[
                    VilTeX`Private`currentSurfaceData]]; 
                 VilTeX`Private`allPlotData = 
                  Append[VilTeX`Private`allPlotData, {
                    VilTeX`Private`currentPlotType, 
                    VilTeX`Private`currentSurfaceData, 
                    VilTeX`Private`currentGraph}]; 
                 VilTeX`Private`allValidData = 
                  Join[VilTeX`Private`allValidData, 
                    VilTeX`Private`currentSurfaceData]; Null]; Null, 
               VilTeX`Private`currentPlotType == "Plot3D", 
               VilTeX`Private`func = Part[VilTeX`Private`currentGraph, 1]; 
               VilTeX`Private`xRange = Part[VilTeX`Private`currentGraph, 2]; 
               VilTeX`Private`yRange = Part[VilTeX`Private`currentGraph, 3]; 
               Module[{
                 VilTeX`Private`xVar, VilTeX`Private`xMin, 
                  VilTeX`Private`xMax, VilTeX`Private`yVar, 
                  VilTeX`Private`yMin, VilTeX`Private`yMax, 
                  VilTeX`Private`xVals, 
                  VilTeX`Private`yVals}, {
                   VilTeX`Private`xVar, VilTeX`Private`xMin, 
                    VilTeX`Private`xMax} = 
                  VilTeX`Private`xRange; {
                   VilTeX`Private`yVar, VilTeX`Private`yMin, 
                    VilTeX`Private`yMax} = VilTeX`Private`yRange; 
                 VilTeX`Private`xVals = 
                  Table[VilTeX`Private`xMin + (VilTeX`Private`xMax - 
                    VilTeX`Private`xMin) (VilTeX`Private`i/(
                    VilTeX`Private`adjustedSamples - 1)), {
                    VilTeX`Private`i, 0, VilTeX`Private`adjustedSamples - 1}]; 
                 VilTeX`Private`yVals = 
                  Table[VilTeX`Private`yMin + (VilTeX`Private`yMax - 
                    VilTeX`Private`yMin) (VilTeX`Private`j/(
                    VilTeX`Private`adjustedSamples - 1)), {
                    VilTeX`Private`j, 0, VilTeX`Private`adjustedSamples - 1}]; 
                 Do[
                   
                   Module[{VilTeX`Private`zVal}, 
                    VilTeX`Private`zVal = 
                    ReplaceAll[
                    VilTeX`Private`func, {
                    VilTeX`Private`xVar -> 
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    VilTeX`Private`yVar -> 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j]}]; If[
                    And[
                    NumericQ[VilTeX`Private`zVal], 
                    VilTeX`Private`validNumber[VilTeX`Private`zVal]], 
                    VilTeX`Private`currentSurfaceData = 
                    Append[VilTeX`Private`currentSurfaceData, {
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j], 
                    VilTeX`Private`zVal}]; Null]; Null], {VilTeX`Private`j, 
                    Length[VilTeX`Private`yVals]}, {VilTeX`Private`i, 
                    Length[VilTeX`Private`xVals]}]; Null]; 
               If[Length[VilTeX`Private`currentSurfaceData] > 0, 
                 VilTeX`Private`allLimits = Append[VilTeX`Private`allLimits, 
                    VilTeX`Private`calculateExtendedLimits[
                    VilTeX`Private`currentSurfaceData]]; 
                 VilTeX`Private`allPlotData = 
                  Append[VilTeX`Private`allPlotData, {
                    VilTeX`Private`currentPlotType, 
                    VilTeX`Private`currentSurfaceData, 
                    VilTeX`Private`currentGraph}]; 
                 VilTeX`Private`allValidData = 
                  Join[VilTeX`Private`allValidData, 
                    VilTeX`Private`currentSurfaceData]; Null]; Null, 
               VilTeX`Private`currentPlotType == "ParametricPlot3D_Curve", 
               VilTeX`Private`paramFuncs = 
                Part[VilTeX`Private`currentGraph, 1]; 
               VilTeX`Private`tRange = Part[VilTeX`Private`currentGraph, 2]; 
               Module[{
                 VilTeX`Private`tVar, VilTeX`Private`tMin, 
                  VilTeX`Private`tMax, VilTeX`Private`tVals, 
                  VilTeX`Private`xFunc, VilTeX`Private`yFunc, 
                  VilTeX`Private`zFunc, 
                  VilTeX`Private`curvePoints}, {
                   VilTeX`Private`tVar, VilTeX`Private`tMin, 
                    VilTeX`Private`tMax} = 
                  VilTeX`Private`tRange; {
                   VilTeX`Private`xFunc, VilTeX`Private`yFunc, 
                    VilTeX`Private`zFunc} = VilTeX`Private`paramFuncs; 
                 VilTeX`Private`curvePoints = 
                  If[VilTeX`Private`multipleGraphs, 
                    Min[VilTeX`Private`adjustedSamples 2, 100], 
                    VilTeX`Private`adjustedSamples 4]; 
                 VilTeX`Private`tVals = 
                  Table[VilTeX`Private`tMin + (VilTeX`Private`tMax - 
                    VilTeX`Private`tMin) (VilTeX`Private`i/(
                    VilTeX`Private`curvePoints - 1)), {
                    VilTeX`Private`i, 0, VilTeX`Private`curvePoints - 1}]; 
                 Do[
                   
                   Module[{
                    VilTeX`Private`xVal, VilTeX`Private`yVal, 
                    VilTeX`Private`zVal}, 
                    VilTeX`Private`xVal = 
                    ReplaceAll[
                    VilTeX`Private`xFunc, VilTeX`Private`tVar -> 
                    Part[VilTeX`Private`tVals, VilTeX`Private`i]]; 
                    VilTeX`Private`yVal = 
                    ReplaceAll[
                    VilTeX`Private`yFunc, VilTeX`Private`tVar -> 
                    Part[VilTeX`Private`tVals, VilTeX`Private`i]]; 
                    VilTeX`Private`zVal = 
                    ReplaceAll[
                    VilTeX`Private`zFunc, VilTeX`Private`tVar -> 
                    Part[VilTeX`Private`tVals, VilTeX`Private`i]]; If[
                    And[
                    
                    AllTrue[{
                    VilTeX`Private`xVal, VilTeX`Private`yVal, 
                    VilTeX`Private`zVal}, NumericQ], 
                    
                    AllTrue[{
                    VilTeX`Private`xVal, VilTeX`Private`yVal, 
                    VilTeX`Private`zVal}, VilTeX`Private`validNumber]], 
                    VilTeX`Private`currentData = 
                    Append[VilTeX`Private`currentData, {
                    VilTeX`Private`xVal, VilTeX`Private`yVal, 
                    VilTeX`Private`zVal}]; Null]; Null], {VilTeX`Private`i, 
                    Length[VilTeX`Private`tVals]}]; Null]; 
               If[Length[VilTeX`Private`currentData] > 0, 
                 VilTeX`Private`allLimits = Append[VilTeX`Private`allLimits, 
                    VilTeX`Private`calculateExtendedLimits[
                    VilTeX`Private`currentData]]; 
                 VilTeX`Private`allPlotData = 
                  Append[VilTeX`Private`allPlotData, {
                    VilTeX`Private`currentPlotType, 
                    VilTeX`Private`currentData, VilTeX`Private`currentGraph}]; 
                 VilTeX`Private`allValidData = 
                  Join[VilTeX`Private`allValidData, 
                    VilTeX`Private`currentData]; Null]; Null, 
               VilTeX`Private`currentPlotType == "ParametricPlot3D_Surface", 
               VilTeX`Private`paramFuncs = 
                Part[VilTeX`Private`currentGraph, 1]; 
               VilTeX`Private`xRange = Part[VilTeX`Private`currentGraph, 2]; 
               VilTeX`Private`yRange = Part[VilTeX`Private`currentGraph, 3]; 
               Module[{
                 VilTeX`Private`uVar, VilTeX`Private`uMin, 
                  VilTeX`Private`uMax, VilTeX`Private`vVar, 
                  VilTeX`Private`vMin, VilTeX`Private`vMax, 
                  VilTeX`Private`uVals, VilTeX`Private`vVals, 
                  VilTeX`Private`xFunc, VilTeX`Private`yFunc, 
                  VilTeX`Private`zFunc}, {
                   VilTeX`Private`uVar, VilTeX`Private`uMin, 
                    VilTeX`Private`uMax} = 
                  VilTeX`Private`xRange; {
                   VilTeX`Private`vVar, VilTeX`Private`vMin, 
                    VilTeX`Private`vMax} = 
                  VilTeX`Private`yRange; {
                   VilTeX`Private`xFunc, VilTeX`Private`yFunc, 
                    VilTeX`Private`zFunc} = VilTeX`Private`paramFuncs; 
                 VilTeX`Private`uVals = 
                  Table[VilTeX`Private`uMin + (VilTeX`Private`uMax - 
                    VilTeX`Private`uMin) (VilTeX`Private`i/(
                    VilTeX`Private`adjustedSamples - 1)), {
                    VilTeX`Private`i, 0, VilTeX`Private`adjustedSamples - 1}]; 
                 VilTeX`Private`vVals = 
                  Table[VilTeX`Private`vMin + (VilTeX`Private`vMax - 
                    VilTeX`Private`vMin) (VilTeX`Private`j/(
                    VilTeX`Private`adjustedSamples - 1)), {
                    VilTeX`Private`j, 0, VilTeX`Private`adjustedSamples - 1}]; 
                 Do[
                   
                   Module[{
                    VilTeX`Private`xVal, VilTeX`Private`yVal, 
                    VilTeX`Private`zVal}, 
                    VilTeX`Private`xVal = 
                    ReplaceAll[
                    VilTeX`Private`xFunc, {
                    VilTeX`Private`uVar -> 
                    Part[VilTeX`Private`uVals, VilTeX`Private`i], 
                    VilTeX`Private`vVar -> 
                    Part[VilTeX`Private`vVals, VilTeX`Private`j]}]; 
                    VilTeX`Private`yVal = 
                    ReplaceAll[
                    VilTeX`Private`yFunc, {
                    VilTeX`Private`uVar -> 
                    Part[VilTeX`Private`uVals, VilTeX`Private`i], 
                    VilTeX`Private`vVar -> 
                    Part[VilTeX`Private`vVals, VilTeX`Private`j]}]; 
                    VilTeX`Private`zVal = 
                    ReplaceAll[
                    VilTeX`Private`zFunc, {
                    VilTeX`Private`uVar -> 
                    Part[VilTeX`Private`uVals, VilTeX`Private`i], 
                    VilTeX`Private`vVar -> 
                    Part[VilTeX`Private`vVals, VilTeX`Private`j]}]; If[
                    And[
                    
                    AllTrue[{
                    VilTeX`Private`xVal, VilTeX`Private`yVal, 
                    VilTeX`Private`zVal}, NumericQ], 
                    
                    AllTrue[{
                    VilTeX`Private`xVal, VilTeX`Private`yVal, 
                    VilTeX`Private`zVal}, VilTeX`Private`validNumber]], 
                    VilTeX`Private`currentSurfaceData = 
                    Append[VilTeX`Private`currentSurfaceData, {
                    VilTeX`Private`xVal, VilTeX`Private`yVal, 
                    VilTeX`Private`zVal}]; Null]; Null], {VilTeX`Private`j, 
                    Length[VilTeX`Private`vVals]}, {VilTeX`Private`i, 
                    Length[VilTeX`Private`uVals]}]; Null]; 
               If[Length[VilTeX`Private`currentSurfaceData] > 0, 
                 VilTeX`Private`allLimits = Append[VilTeX`Private`allLimits, 
                    VilTeX`Private`calculateExtendedLimits[
                    VilTeX`Private`currentSurfaceData]]; 
                 VilTeX`Private`allPlotData = 
                  Append[VilTeX`Private`allPlotData, {
                    VilTeX`Private`currentPlotType, 
                    VilTeX`Private`currentSurfaceData, 
                    VilTeX`Private`currentGraph}]; 
                 VilTeX`Private`allValidData = 
                  Join[VilTeX`Private`allValidData, 
                    VilTeX`Private`currentSurfaceData]; Null]; Null]; Null, {
             VilTeX`Private`graphIdx, 
              Length[VilTeX`Private`graphList]}]; Null]; 
         If[Length[VilTeX`Private`allValidData] == 0, 
           Print["Error: No se generaron datos v\[AAcute]lidos para ning\
\[UAcute]n gr\[AAcute]fico"]; Return[$Failed]; Null]; 
         VilTeX`Private`globalLimits = 
          VilTeX`Private`combineGlobalLimits[VilTeX`Private`allLimits]; 
         VilTeX`Private`folderName = FileBaseName[VilTeX`Private`filename]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", 
             VilTeX`Private`folderName}]; If[
           Not[
            DirectoryQ[VilTeX`Private`folderPath]], 
           CreateDirectory[VilTeX`Private`folderPath]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         VilTeX`Private`combinedTikzCode = ""; Do[
           
           Module[{VilTeX`Private`plotType, VilTeX`Private`graphData, 
             VilTeX`Private`graphArgs, VilTeX`Private`tikzPlot, 
             VilTeX`Private`validPoints, VilTeX`Private`plotStyle, 
             VilTeX`Private`meshData, 
             VilTeX`Private`currentColor}, {
              VilTeX`Private`plotType, VilTeX`Private`graphData, 
               VilTeX`Private`graphArgs} = 
             Part[VilTeX`Private`allPlotData, VilTeX`Private`plotIdx]; 
            VilTeX`Private`currentColor = If[
               And[
               VilTeX`Private`multipleGraphs, VilTeX`Private`plotIdx <= 
                Length[VilTeX`Private`colors]], 
               Part[VilTeX`Private`colors, VilTeX`Private`plotIdx], 
               VilTeX`Private`color]; 
            Which[VilTeX`Private`plotType == "ImplicitPlot3D", 
              VilTeX`Private`validPoints = 
               Select[VilTeX`Private`graphData, And[Length[#] == 3, 
                  AllTrue[#, VilTeX`Private`validNumber]]& ]; 
              If[Length[VilTeX`Private`validPoints] > 0, 
                VilTeX`Private`plotStyle = 
                 If[Length[VilTeX`Private`validPoints] > 2000, 
                   "only marks, mark=*, mark size=0.5pt", 
                   "only marks, mark=*, mark size=0.8pt"]; 
                VilTeX`Private`tikzPlot = (((((("\\addplot3[" <> 
                    VilTeX`Private`currentColor) <> ", ") <> 
                    VilTeX`Private`plotStyle) <> VilTeX`Private`opacityStyle) <> 
                    "] coordinates {\n") <> StringRiffle[
                    Table[((((("  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`validPoints, VilTeX`Private`i, 1]]) <> 
                    ",") <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`validPoints, VilTeX`Private`i, 2]]) <> 
                    ",") <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`validPoints, VilTeX`Private`i, 3]]) <> 
                    ")", {VilTeX`Private`i, 
                    Length[VilTeX`Private`validPoints]}], "\n"]) <> "\n};\n"; 
                VilTeX`Private`combinedTikzCode = 
                 VilTeX`Private`combinedTikzCode <> VilTeX`Private`tikzPlot; 
                Null]; Null, VilTeX`Private`plotType == "Plot3D", 
              Module[{VilTeX`Private`xVar, VilTeX`Private`xMin, 
                 VilTeX`Private`xMax, VilTeX`Private`yVar, 
                 VilTeX`Private`yMin, 
                 VilTeX`Private`yMax}, {
                  VilTeX`Private`xVar, VilTeX`Private`xMin, 
                   VilTeX`Private`xMax} = 
                 Part[VilTeX`Private`graphArgs, 2]; {
                  VilTeX`Private`yVar, VilTeX`Private`yMin, 
                   VilTeX`Private`yMax} = Part[VilTeX`Private`graphArgs, 3]; 
                VilTeX`Private`meshData = ""; Do[Do[
                    
                    Module[{
                    VilTeX`Private`xVal, VilTeX`Private`yVal, 
                    VilTeX`Private`zVal}, 
                    VilTeX`Private`xVal = 
                    VilTeX`Private`xMin + (VilTeX`Private`xMax - 
                    VilTeX`Private`xMin) (VilTeX`Private`i/(
                    VilTeX`Private`samples - 1)); 
                    VilTeX`Private`yVal = 
                    VilTeX`Private`yMin + (VilTeX`Private`yMax - 
                    VilTeX`Private`yMin) (VilTeX`Private`j/(
                    VilTeX`Private`samples - 1)); 
                    VilTeX`Private`zVal = ReplaceAll[
                    Part[VilTeX`Private`graphArgs, 1], {
                    VilTeX`Private`xVar -> VilTeX`Private`xVal, 
                    VilTeX`Private`yVar -> VilTeX`Private`yVal}]; If[
                    And[
                    NumericQ[VilTeX`Private`zVal], 
                    VilTeX`Private`validNumber[VilTeX`Private`zVal]], 
                    VilTeX`Private`meshData = ((((((VilTeX`Private`meshData <> 
                    "(") <> VilTeX`Private`formatNumber[VilTeX`Private`xVal]) <> 
                    ",") <> VilTeX`Private`formatNumber[VilTeX`Private`yVal]) <> 
                    ",") <> VilTeX`Private`formatNumber[VilTeX`Private`zVal]) <> 
                    ")\n"; Null]; Null], {
                    VilTeX`Private`i, 0, VilTeX`Private`samples - 1}]; 
                  VilTeX`Private`meshData = VilTeX`Private`meshData <> "\n"; 
                  Null, {VilTeX`Private`j, 0, VilTeX`Private`samples - 1}]; 
                If[StringLength[VilTeX`Private`meshData] > 10, 
                  VilTeX`Private`tikzPlot = (((((((("\\addplot3[" <> 
                    VilTeX`Private`currentColor) <> ", surf, mesh/rows=") <> 
                    ToString[VilTeX`Private`samples]) <> ", mesh/cols=") <> 
                    ToString[VilTeX`Private`samples]) <> 
                    VilTeX`Private`opacityStyle) <> "] coordinates {\n") <> 
                    VilTeX`Private`meshData) <> "};\n"; 
                  VilTeX`Private`combinedTikzCode = 
                   VilTeX`Private`combinedTikzCode <> VilTeX`Private`tikzPlot; 
                  Null]; Null]; Null, VilTeX`Private`plotType == 
              "ParametricPlot3D_Curve", 
              If[Length[VilTeX`Private`graphData] > 0, 
                VilTeX`Private`tikzPlot = ((("\\addplot3[" <> 
                    VilTeX`Private`currentColor) <> 
                    ", thick, no marks] coordinates {\n") <> StringRiffle[
                    Table[((((("  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`graphData, VilTeX`Private`i, 1]]) <> 
                    ",") <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`graphData, VilTeX`Private`i, 2]]) <> 
                    ",") <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`graphData, VilTeX`Private`i, 3]]) <> 
                    ")", {VilTeX`Private`i, 
                    Length[VilTeX`Private`graphData]}], "\n"]) <> "\n};\n"; 
                VilTeX`Private`combinedTikzCode = 
                 VilTeX`Private`combinedTikzCode <> VilTeX`Private`tikzPlot; 
                Null]; Null, VilTeX`Private`plotType == 
              "ParametricPlot3D_Surface", 
              Module[{VilTeX`Private`uVar, VilTeX`Private`uMin, 
                 VilTeX`Private`uMax, VilTeX`Private`vVar, 
                 VilTeX`Private`vMin, 
                 VilTeX`Private`vMax}, {
                  VilTeX`Private`uVar, VilTeX`Private`uMin, 
                   VilTeX`Private`uMax} = 
                 Part[VilTeX`Private`graphArgs, 2]; {
                  VilTeX`Private`vVar, VilTeX`Private`vMin, 
                   VilTeX`Private`vMax} = Part[VilTeX`Private`graphArgs, 3]; 
                VilTeX`Private`meshData = ""; Do[Do[
                    
                    Module[{
                    VilTeX`Private`uVal, VilTeX`Private`vVal, 
                    VilTeX`Private`xVal, VilTeX`Private`yVal, 
                    VilTeX`Private`zVal}, 
                    VilTeX`Private`uVal = 
                    VilTeX`Private`uMin + (VilTeX`Private`uMax - 
                    VilTeX`Private`uMin) (VilTeX`Private`i/(
                    VilTeX`Private`samples - 1)); 
                    VilTeX`Private`vVal = 
                    VilTeX`Private`vMin + (VilTeX`Private`vMax - 
                    VilTeX`Private`vMin) (VilTeX`Private`j/(
                    VilTeX`Private`samples - 1)); 
                    VilTeX`Private`xVal = ReplaceAll[
                    Part[VilTeX`Private`graphArgs, 1, 1], {
                    VilTeX`Private`uVar -> VilTeX`Private`uVal, 
                    VilTeX`Private`vVar -> VilTeX`Private`vVal}]; 
                    VilTeX`Private`yVal = ReplaceAll[
                    Part[VilTeX`Private`graphArgs, 1, 2], {
                    VilTeX`Private`uVar -> VilTeX`Private`uVal, 
                    VilTeX`Private`vVar -> VilTeX`Private`vVal}]; 
                    VilTeX`Private`zVal = ReplaceAll[
                    Part[VilTeX`Private`graphArgs, 1, 3], {
                    VilTeX`Private`uVar -> VilTeX`Private`uVal, 
                    VilTeX`Private`vVar -> VilTeX`Private`vVal}]; If[
                    And[
                    
                    AllTrue[{
                    VilTeX`Private`xVal, VilTeX`Private`yVal, 
                    VilTeX`Private`zVal}, NumericQ], 
                    
                    AllTrue[{
                    VilTeX`Private`xVal, VilTeX`Private`yVal, 
                    VilTeX`Private`zVal}, VilTeX`Private`validNumber]], 
                    VilTeX`Private`meshData = ((((((VilTeX`Private`meshData <> 
                    "(") <> VilTeX`Private`formatNumber[VilTeX`Private`xVal]) <> 
                    ",") <> VilTeX`Private`formatNumber[VilTeX`Private`yVal]) <> 
                    ",") <> VilTeX`Private`formatNumber[VilTeX`Private`zVal]) <> 
                    ")\n"; Null]; Null], {
                    VilTeX`Private`i, 0, VilTeX`Private`samples - 1}]; 
                  VilTeX`Private`meshData = VilTeX`Private`meshData <> "\n"; 
                  Null, {VilTeX`Private`j, 0, VilTeX`Private`samples - 1}]; 
                If[StringLength[VilTeX`Private`meshData] > 10, 
                  VilTeX`Private`tikzPlot = (((((((("\\addplot3[" <> 
                    VilTeX`Private`currentColor) <> ", surf, mesh/rows=") <> 
                    ToString[VilTeX`Private`samples]) <> ", mesh/cols=") <> 
                    ToString[VilTeX`Private`samples]) <> 
                    VilTeX`Private`opacityStyle) <> "] coordinates {\n") <> 
                    VilTeX`Private`meshData) <> "};\n"; 
                  VilTeX`Private`combinedTikzCode = 
                   VilTeX`Private`combinedTikzCode <> VilTeX`Private`tikzPlot; 
                  Null]; Null]; Null]; Null], {VilTeX`Private`plotIdx, 
            Length[VilTeX`Private`allPlotData]}]; 
         VilTeX`Private`textTikzCode = ""; 
         If[Length[VilTeX`Private`textAnnotations] > 0, 
           Module[{VilTeX`Private`processedAnnotations = {}}, Do[
               
               Module[{
                VilTeX`Private`annotation, VilTeX`Private`text, 
                 VilTeX`Private`coords, VilTeX`Private`options, 
                 VilTeX`Private`xPos, VilTeX`Private`yPos, 
                 VilTeX`Private`zPos, VilTeX`Private`textOptions, 
                 VilTeX`Private`validCoords}, 
                VilTeX`Private`annotation = 
                 Part[VilTeX`Private`textAnnotations, VilTeX`Private`i]; 
                VilTeX`Private`text = ""; VilTeX`Private`textOptions = ""; 
                VilTeX`Private`validCoords = False; If[
                  And[
                   ListQ[VilTeX`Private`annotation], 
                   Length[VilTeX`Private`annotation] >= 2], If[
                    StringQ[
                    Part[VilTeX`Private`annotation, 1]], 
                    VilTeX`Private`text = Part[VilTeX`Private`annotation, 1]; 
                    Null]; If[
                    And[
                    ListQ[
                    Part[VilTeX`Private`annotation, 2]], Length[
                    Part[VilTeX`Private`annotation, 2]] == 3], 
                    VilTeX`Private`coords = 
                    Part[VilTeX`Private`annotation, 2]; If[
                    AllTrue[
                    VilTeX`Private`coords, 
                    NumericQ], {
                    VilTeX`Private`xPos, VilTeX`Private`yPos, 
                    VilTeX`Private`zPos} = N[VilTeX`Private`coords]; 
                    VilTeX`Private`validCoords = True; Null]; Null]; If[
                    And[Length[VilTeX`Private`annotation] >= 3, 
                    ListQ[
                    Part[VilTeX`Private`annotation, 3]]], 
                    VilTeX`Private`options = 
                    Part[VilTeX`Private`annotation, 3]; Do[
                    If[
                    And[
                    ListQ[
                    Part[VilTeX`Private`options, VilTeX`Private`j]], Length[
                    Part[VilTeX`Private`options, VilTeX`Private`j]] >= 2], 
                    Module[{VilTeX`Private`key, VilTeX`Private`val}, 
                    VilTeX`Private`key = ToString[
                    Part[
                    Part[VilTeX`Private`options, VilTeX`Private`j], 1]]; 
                    VilTeX`Private`val = ToString[
                    Part[
                    Part[VilTeX`Private`options, VilTeX`Private`j], 2]]; 
                    Which[VilTeX`Private`key == "color", 
                    VilTeX`Private`textOptions = ((VilTeX`Private`textOptions <> 
                    "text=") <> VilTeX`Private`val) <> ",", 
                    VilTeX`Private`key == "size", 
                    VilTeX`Private`textOptions = ((VilTeX`Private`textOptions <> 
                    "font=") <> VilTeX`Private`val) <> ",", 
                    VilTeX`Private`key == "anchor", 
                    VilTeX`Private`textOptions = ((VilTeX`Private`textOptions <> 
                    "anchor=") <> VilTeX`Private`val) <> ",", 
                    VilTeX`Private`key == "rotate", 
                    VilTeX`Private`textOptions = ((VilTeX`Private`textOptions <> 
                    "rotate=") <> VilTeX`Private`val) <> ",", True, 
                    VilTeX`Private`textOptions = (((
                    VilTeX`Private`textOptions <> VilTeX`Private`key) <> "=") <> 
                    VilTeX`Private`val) <> ","]; Null]; Null], {
                    VilTeX`Private`j, 
                    Length[VilTeX`Private`options]}]; Null]; Null]; If[
                  And[
                   StringQ[VilTeX`Private`text], VilTeX`Private`text != "", 
                   VilTeX`Private`validCoords, 
                   
                   AllTrue[{
                    VilTeX`Private`xPos, VilTeX`Private`yPos, 
                    VilTeX`Private`zPos}, NumericQ]], If[
                    And[
                    StringLength[VilTeX`Private`textOptions] > 0, 
                    StringTake[VilTeX`Private`textOptions, -1] == ","], 
                    VilTeX`Private`textOptions = 
                    StringDrop[VilTeX`Private`textOptions, -1]; Null]; 
                  AppendTo[
                   VilTeX`Private`processedAnnotations, {
                    VilTeX`Private`text, VilTeX`Private`xPos, 
                    VilTeX`Private`yPos, VilTeX`Private`zPos, 
                    VilTeX`Private`textOptions}]; Null]; Null], {
               VilTeX`Private`i, 
                Length[VilTeX`Private`textAnnotations]}]; Do[
               
               Module[{
                VilTeX`Private`text, VilTeX`Private`x, VilTeX`Private`y, 
                 VilTeX`Private`z, 
                 VilTeX`Private`opts}, {
                  VilTeX`Private`text, VilTeX`Private`x, VilTeX`Private`y, 
                   VilTeX`Private`z, VilTeX`Private`opts} = 
                 Part[VilTeX`Private`processedAnnotations, VilTeX`Private`j]; 
                VilTeX`Private`textTikzCode = ((((((((((
                    VilTeX`Private`textTikzCode <> "\\node[") <> 
                    VilTeX`Private`opts) <> "] at (axis cs:") <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`x]) <> ",") <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`y]) <> ",") <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`z]) <> ") {") <> 
                   VilTeX`Private`text) <> "};\n"; Null], {VilTeX`Private`j, 
                Length[VilTeX`Private`processedAnnotations]}]; Null]; Null]; 
         If[StringLength[VilTeX`Private`combinedTikzCode] < 10, 
           Print["Error: No se gener\[OAcute] c\[OAcute]digo TikZ \
v\[AAcute]lido"]; Return[$Failed]; Null]; 
         VilTeX`Private`tikzCode = ((((((((((((((((((((
                    "\\begin{tikzpicture}\n" <> "\\begin{axis}[\n") <> 
                    "  xlabel={$x$},\n") <> "  ylabel={$y$},\n") <> 
                    "  zlabel={$z$},\n") <> "  ") <> 
                    VilTeX`Private`colormapStyle) <> ",\n") <> 
                    If[VilTeX`Private`grid, "  grid=major,\n", ""]) <> 
                    "  view={60}{30},\n") <> "  ") <> 
                    VilTeX`Private`axisConfiguration) <> ",\n") <> 
                   VilTeX`Private`generateAxisLimitsString[
                    VilTeX`Private`globalLimits]) <> "  axis equal=false,\n") <> 
                 "  samples=50,\n") <> "  point meta=z\n") <> "]\n") <> 
              VilTeX`Private`combinedTikzCode) <> 
             VilTeX`Private`textTikzCode) <> "\\end{axis}\n") <> 
           "\\end{tikzpicture}"; 
         VilTeX`Private`fullDocument = (((((((((
                    "\\documentclass[border=5mm]{standalone}\n" <> 
                    "\\usepackage{tikz}\n") <> "\\usepackage{pgfplots}\n") <> 
                  "\\usepackage{amsmath}\n") <> "\\usepackage{amssymb}\n") <> 
                "\\pgfplotsset{compat=1.18}\n") <> 
               "\\usepgfplotslibrary{colorbrewer}\n") <> 
              "\\usepgfplotslibrary{colormaps}\n") <> 
             "\n\\begin{document}\n") <> VilTeX`Private`tikzCode) <> 
           "\n\\end{document}"; 
         Export[VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, 
           "Text"]; VilTeX`Private`downloadPath]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "VilTeX`ExportToTikZ3D"|>, False]]], "Output",
 CellChangeTimes->{3.9671910972227993`*^9, 3.9671923711837063`*^9, 
  3.9672007758886147`*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"0eaa7428-6bb2-5f4d-9b3d-31b8dbbe3402"]
}, Open  ]],

Cell[TextData[{
 "Podr\[IAcute]a no compilar si la resoluci\[OAcute]n es muy alta, o bien, en \
una gr\[AAcute]fica impl\[IAcute]cita si se usan muchos puntos (se excede la \
memoria en ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}],
    SingleLetterItalics->False], TraditionalForm]],ExpressionUUID->
  "762b1585-40b6-4a7d-ba77-da1de0e25d3e"],
 "). Al emplear ContourPlot3D la gr\[AAcute]fica se genera mediante puntos."
}], "Text",
 CellChangeTimes->{{3.9671983907229347`*^9, 3.9671984113435555`*^9}, {
  3.9671986684042053`*^9, 3.9671986958634205`*^9}, {3.967202093408886*^9, 
  3.9672021270911064`*^9}},ExpressionUUID->"925f3268-56a0-834a-8747-\
874692695feb"],

Cell[CellGroupData[{

Cell["Ejemplo 1", "Subsection",
 CellChangeTimes->{{3.967118818547166*^9, 
  3.967118820248961*^9}},ExpressionUUID->"397ebf03-dab5-41d6-839c-\
c473343b3eb8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"Opacity", "[", "0.7", "]"}]}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"ColorData", "[", "\"\<Gradients\>\"", "]"}], "]"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<color=\>\"", ",", 
      RowBox[{"color", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
          ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
          ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"",
           ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"",
           ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
          ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<white\>\"", 
          ",", "\"\<yellow\>\"", ",", "\"\<blue!50!red\>\"", 
          ",", "\"\<green!70!black\>\"", ",", "\"\<red!20!blue!80!green\>\"", 
          ",", "\"\<yellow!75!red\>\""}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"10", ",", "60"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<mapacolor=\>\"", ",", 
      RowBox[{"mapacolor", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<viridis\>\"", ",", "\"\<cool\>\"", ",", "\"\<hot\>\"", 
          ",", "\"\<jet\>\"", ",", "\"\<hsv\>\"", ",", "\"\<spring\>\"", 
          ",", "\"\<summer\>\"", ",", "\"\<autumn\>\"", ",", "\"\<winter\>\"",
           ",", "\"\<gray\>\"", ",", "\"\<blackwhite\>\""}], "}"}], "]"}]}]}],
      "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.2", ",", "1"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<puntossuperimpli=\>\"", ",", 
      RowBox[{"puntossuperimpli", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"8000", ",", "13000"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", "}"}]}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], 
    ",", "\"\<grafica3D1.tex\>\"", ",", "grid", ",", "color", ",", 
    "resolucion", ",", "estiloejes", ",", "mapacolor", ",", "opacidad", ",", 
    "extensionejes", ",", "puntossuperimpli", ",", "texto"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9671190571431417`*^9, 3.967119057714198*^9}, {
   3.967119097392273*^9, 3.967119127049708*^9}, {3.967192606183653*^9, 
   3.9671926200483074`*^9}, 3.967192669734415*^9, {3.9671938188038845`*^9, 
   3.9671938217178764`*^9}, {3.9671938551467953`*^9, 3.967193855518343*^9}, {
   3.967194295803877*^9, 3.9671943369437923`*^9}, 3.967194830518736*^9, 
   3.9671948654101276`*^9, {3.967194984034279*^9, 3.9671952796885033`*^9}, {
   3.9671953269269505`*^9, 3.967195327494194*^9}, {3.967195547768524*^9, 
   3.9671955525364647`*^9}, {3.9671957847395344`*^9, 
   3.9671958482391644`*^9}, {3.9671963892438526`*^9, 
   3.9671963919362564`*^9}, {3.9671970494888744`*^9, 3.967197153807743*^9}, {
   3.9671972720064125`*^9, 3.9671973231729527`*^9}, {3.9671973749538994`*^9, 
   3.9671973859172115`*^9}, 3.9671982552543545`*^9, {3.9671986603993454`*^9, 
   3.9671986621848125`*^9}, 3.9672001163365574`*^9, {3.967274863003241*^9, 
   3.967274896410275*^9}, {3.967274932591558*^9, 3.967275144101754*^9}, {
   3.9672753482166452`*^9, 3.967275371012121*^9}, {3.967275831763562*^9, 
   3.967275832028604*^9}},ExpressionUUID->"40dfa70f-c4cb-4303-806e-\
913a748258fe"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1nXucllW1x81LKpiY4SU00BgvaB2sgxeQXKcoBQ3ziKmdTAs1MR25aKl4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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.7], EdgeForm[None], 
       Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJw1mQn8FtPbxp+Zc0bZFUWKJG3aN61atKosbSQhLbJnzdJuragUIaWkDUm2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            "]], Polygon3DBox[CompressedData["
1:eJwtmncAVtMfxu8Zr+yRJCkNGZUmpaJIQyppaCArI3tnZhQyki1+ZJUtKluD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            "]], Polygon3DBox[CompressedData["
1:eJwt13m8TfUWAPBzz7mXlNLLLENKpsxDyZikokGmlCFCMkbGTCEyRAkhUiqZ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            "]], 
           Polygon3DBox[{{1112, 600, 397, 396, 709, 1046}, {994, 588, 706, 
            1161, 834, 835}, {987, 581, 702, 1159, 820, 821}}]},
          Annotation[#, "Charting`Private`Tag$40661#1"]& ]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0ssqhVEUAODtnOPOQZIk5J7ERBnxBCQZkokZiSl5AFKm5AF4Ap6AJ3A7
7vc7IwPXAd8ug/V/a/W3117733/92PTQVFYIYUmkJTEv8LjhaSKEUj6zjl/s
ZF4yhF5Wsp8tHGFDKoQfdqsnGJsNymelo1zgJFc4x3UucpOr3GatHm8stXaX
RUyIS7GnvuI+r3nAG2Z4y0Pe8YjHZk3K78WxOsUHcSJ/5CmfeBbPx3O+8IKv
cT/u6fHOMvUVi5ktNsy6o17nFle4wQWucZbLnOA8W50py7qZ+K3kvxzwbpxd
HGYT+1jBHuawgx9mqI3fw7oHluhTwkJ+s51ptrE47sUiNrOQjSxgPfOZ0e8r
3qE4kH+yxrtcVjOHVfGc8X6ZijPROKE83gX3PT7+/5c/JaRCkA==
        "],
        VertexColors->None]}, 
      {GrayLevel[0.2], 
       Line3DBox[{732, 1037, 493, 731, 1166, 949, 733, 1167, 950, 734, 1168, 
        951, 735, 1169, 952, 736, 1170, 953, 737, 698, 1064, 1358, 738, 1038, 
        1171, 954, 739, 1172, 955, 740, 1173, 956, 741, 1174, 957, 742, 1175, 
        958, 743, 1176, 959, 744, 1359, 1039, 960, 1040},
        VertexColors->None], 
       Line3DBox[{746, 1065, 1261, 745, 507, 747, 1177, 961, 748, 1178, 962, 
        749, 1179, 963, 750, 1180, 964, 751, 1181, 1066, 1262, 752, 1067, 
        1263, 753, 1182, 965, 754, 1183, 966, 755, 1184, 967, 756, 1185, 968, 
        757, 1186, 969, 758, 1187, 970, 759},
        VertexColors->None], 
       Line3DBox[{761, 1068, 1264, 760, 1069, 1265, 762, 523, 763, 1188, 971, 
        764, 1189, 972, 765, 1190, 973, 766, 1191, 1070, 1266, 767, 1071, 
        1267, 768, 1072, 1268, 769, 531, 770, 1192, 974, 771, 1193, 975, 772, 
        1194, 976, 773, 1195, 977, 774},
        VertexColors->None], 
       Line3DBox[{776, 1073, 1269, 775, 1074, 1270, 777, 1075, 1271, 778, 539,
         779, 1196, 978, 780, 1197, 979, 781, 1198, 1076, 1272, 782, 1077, 
        1273, 783, 1078, 1274, 784, 1079, 1275, 785, 547, 786, 1199, 980, 787,
         1200, 981, 788, 1201, 982, 789},
        VertexColors->None], 
       Line3DBox[{791, 1080, 1276, 790, 1081, 1277, 792, 1082, 1278, 793, 
        1083, 1279, 794, 555, 795, 1202, 983, 796, 1203, 1084, 1280, 797, 
        1085, 1281, 798, 1086, 1282, 799, 1087, 1283, 800, 1088, 1284, 801, 
        1089, 1285, 802, 1204, 984, 803, 1205, 985, 804},
        VertexColors->None], 
       Line3DBox[{806, 1090, 1286, 805, 1091, 1287, 807, 1092, 1288, 808, 
        1093, 1289, 809, 1094, 1290, 810, 571, 811, 1206, 1095, 1291, 812, 
        1096, 1292, 813, 1097, 1293, 814, 1098, 1294, 815, 1099, 1295, 816, 
        1100, 1296, 817, 579, 818, 1207, 986, 819},
        VertexColors->None], 
       Line3DBox[{822, 1042, 1208, 987, 821, 1209, 988, 824, 1210, 989, 826, 
        1211, 990, 828, 1212, 991, 830, 1213, 992, 832, 1160, 1214, 1060, 
        1367, 993, 1059, 1045, 1061, 1368, 994, 835, 1215, 995, 837, 1216, 
        996, 839, 1217, 997, 841, 1218, 998, 843, 1219, 999, 845, 1162, 1220, 
        1000, 1062},
        VertexColors->None], 
       Line3DBox[{846, 1049, 1048, 1362, 844, 1308, 1110, 842, 1307, 1109, 
        840, 1306, 1108, 838, 1305, 1107, 836, 1304, 1106, 834, 1161, 1303, 
        1044, 833, 1366, 1043, 703, 831, 1302, 1105, 829, 1301, 1104, 827, 
        1300, 1103, 825, 1299, 1102, 823, 1298, 1101, 820, 1159, 1297, 1041, 
        1058},
        VertexColors->None], 
       Line3DBox[{848, 1050, 1111, 1363, 847, 1221, 1001, 849, 1222, 1002, 
        850, 1223, 1003, 851, 1224, 1004, 852, 1225, 1005, 853, 1361, 1046, 
        1112, 1360, 1051, 1047, 601, 854, 1226, 1006, 855, 1227, 1007, 856, 
        1228, 1008, 857, 1229, 1009, 858, 1230, 1010, 859, 1364, 1052, 1011, 
        1063},
        VertexColors->None], 
       Line3DBox[{861, 1113, 1309, 860, 1114, 1310, 862, 1231, 1012, 863, 
        1232, 1013, 864, 1233, 1014, 865, 1234, 1015, 866, 1235, 1115, 1311, 
        867, 1116, 1312, 868, 616, 869, 1236, 1016, 870, 1237, 1017, 871, 
        1238, 1018, 872, 1239, 1019, 873, 1240, 1020, 874},
        VertexColors->None], 
       Line3DBox[{876, 1117, 1313, 875, 1118, 1314, 877, 624, 878, 1241, 1021,
         879, 1242, 1022, 880, 1243, 1023, 881, 1244, 1119, 1315, 882, 1120, 
        1316, 883, 1121, 1317, 884, 632, 885, 1245, 1024, 886, 1246, 1025, 
        887, 1247, 1026, 888, 1248, 1027, 889},
        VertexColors->None], 
       Line3DBox[{891, 1122, 1318, 890, 1123, 1319, 892, 1124, 1320, 893, 640,
         894, 1249, 1028, 895, 1250, 1029, 896, 1251, 1125, 1321, 897, 1126, 
        1322, 898, 1127, 1323, 899, 1128, 1324, 900, 648, 901, 1252, 1030, 
        902, 1253, 1031, 903, 1254, 1032, 904},
        VertexColors->None], 
       Line3DBox[{906, 1129, 1325, 905, 1130, 1326, 907, 1131, 1327, 908, 
        1132, 1328, 909, 656, 910, 1255, 1033, 911, 1256, 1133, 1329, 912, 
        1134, 1330, 913, 1135, 1331, 914, 1136, 1332, 915, 1137, 1333, 916, 
        664, 917, 1257, 1034, 918, 1258, 1035, 919},
        VertexColors->None], 
       Line3DBox[{921, 1138, 1334, 920, 1139, 1335, 922, 1140, 1336, 923, 
        1141, 1337, 924, 1142, 1338, 925, 672, 926, 1259, 1143, 1339, 927, 
        1144, 1340, 928, 1145, 1341, 929, 1146, 1342, 930, 1147, 1343, 931, 
        1148, 1344, 932, 680, 933, 1260, 1036, 934},
        VertexColors->None], 
       Line3DBox[{948, 1057, 722, 947, 1357, 1158, 946, 1356, 1157, 945, 1355,
         1156, 944, 1354, 1155, 943, 1353, 1154, 942, 1165, 1352, 1056, 941, 
        1365, 1055, 1351, 1164, 940, 1350, 1153, 939, 1349, 1152, 938, 1348, 
        1151, 937, 1347, 1150, 936, 1346, 1149, 935, 1163, 1345, 1053, 1054},
        VertexColors->None]}, 
      {GrayLevel[0.2], 
       Line3DBox[{275, 494, 1166, 276, 507, 302, 1265, 522, 317, 1270, 537, 
        332, 1277, 552, 347, 1287, 567, 362, 1298, 582, 1209, 377, 595, 1221, 
        391, 1310, 608, 406, 1314, 623, 421, 1319, 638, 436, 1326, 653, 451, 
        1335, 668, 466, 1346, 683, 481},
        VertexColors->None], 
       Line3DBox[{277, 495, 1167, 278, 508, 1177, 303, 523, 318, 1271, 538, 
        333, 1278, 553, 348, 1288, 568, 363, 1299, 583, 1210, 378, 596, 1222, 
        392, 609, 1231, 407, 624, 422, 1320, 639, 437, 1327, 654, 452, 1336, 
        669, 467, 1347, 684, 482},
        VertexColors->None], 
       Line3DBox[{279, 496, 1168, 280, 509, 1178, 304, 524, 1188, 319, 539, 
        334, 1279, 554, 349, 1289, 569, 364, 1300, 584, 1211, 379, 597, 1223, 
        393, 610, 1232, 408, 625, 1241, 423, 640, 438, 1328, 655, 453, 1337, 
        670, 468, 1348, 685, 483},
        VertexColors->None], 
       Line3DBox[{281, 497, 1169, 282, 510, 1179, 305, 525, 1189, 320, 540, 
        1196, 335, 555, 350, 1290, 570, 365, 1301, 585, 1212, 380, 598, 1224, 
        394, 611, 1233, 409, 626, 1242, 424, 641, 1249, 439, 656, 454, 1338, 
        671, 469, 1349, 686, 484},
        VertexColors->None], 
       Line3DBox[{283, 498, 1170, 284, 511, 1180, 306, 526, 1190, 321, 541, 
        1197, 336, 556, 1202, 351, 571, 366, 1302, 586, 1213, 381, 599, 1225, 
        395, 612, 1234, 410, 627, 1243, 425, 642, 1250, 440, 657, 1255, 455, 
        672, 470, 1350, 687, 485},
        VertexColors->None], 
       Line3DBox[{285, 696, 698, 286, 512, 1181, 307, 527, 1191, 322, 542, 
        1198, 337, 557, 1203, 352, 572, 1206, 367, 703, 705, 1214, 729, 707, 
        1361, 709, 396, 613, 1235, 411, 628, 1244, 426, 643, 1251, 441, 658, 
        1256, 456, 673, 1259, 471, 1351, 718, 720, 730},
        VertexColors->None], 
       Line3DBox[{289, 501, 1172, 290, 515, 1182, 310, 1268, 530, 325, 1274, 
        545, 340, 1282, 560, 355, 1293, 575, 370, 1304, 589, 1215, 384, 602, 
        1226, 399, 616, 414, 1317, 631, 429, 1323, 646, 444, 1331, 661, 459, 
        1341, 676, 474, 1353, 690, 488},
        VertexColors->None], 
       Line3DBox[{291, 502, 1173, 292, 516, 1183, 311, 531, 326, 1275, 546, 
        341, 1283, 561, 356, 1294, 576, 371, 1305, 590, 1216, 385, 603, 1227, 
        400, 617, 1236, 415, 632, 430, 1324, 647, 445, 1332, 662, 460, 1342, 
        677, 475, 1354, 691, 489},
        VertexColors->None], 
       Line3DBox[{293, 503, 1174, 294, 517, 1184, 312, 532, 1192, 327, 547, 
        342, 1284, 562, 357, 1295, 577, 372, 1306, 591, 1217, 386, 604, 1228, 
        401, 618, 1237, 416, 633, 1245, 431, 648, 446, 1333, 663, 461, 1343, 
        678, 476, 1355, 692, 490},
        VertexColors->None], 
       Line3DBox[{295, 504, 1175, 296, 518, 1185, 313, 533, 1193, 328, 548, 
        1199, 343, 1285, 563, 358, 1296, 578, 373, 1307, 592, 1218, 387, 605, 
        1229, 402, 619, 1238, 417, 634, 1246, 432, 649, 1252, 447, 664, 462, 
        1344, 679, 477, 1356, 693, 491},
        VertexColors->None], 
       Line3DBox[{297, 505, 1176, 298, 519, 1186, 314, 534, 1194, 329, 549, 
        1200, 344, 564, 1204, 359, 579, 374, 1308, 593, 1219, 388, 606, 1230, 
        403, 620, 1239, 418, 635, 1247, 433, 650, 1253, 448, 665, 1257, 463, 
        680, 478, 1357, 694, 492},
        VertexColors->None], 
       Line3DBox[{299, 700, 1359, 701, 300, 520, 1187, 315, 535, 1195, 330, 
        550, 1201, 345, 565, 1205, 360, 580, 1207, 375, 711, 1362, 712, 1220, 
        389, 715, 1364, 716, 404, 621, 1240, 419, 636, 1248, 434, 651, 1254, 
        449, 666, 1258, 464, 681, 1260, 479, 722, 723, 724},
        VertexColors->None], 
       Line3DBox[{480, 682, 717, 1345, 465, 667, 1334, 450, 652, 1325, 435, 
        637, 1318, 420, 622, 1313, 405, 607, 1309, 390, 594, 1363, 713, 376, 
        1208, 581, 702, 1297, 361, 566, 1286, 346, 551, 1276, 331, 536, 1269, 
        316, 521, 1264, 301, 506, 1261, 274, 493, 695, 725},
        VertexColors->None], 
       Line3DBox[{486, 688, 1365, 719, 472, 674, 1339, 457, 659, 1329, 442, 
        644, 1321, 427, 629, 1315, 412, 614, 1311, 397, 600, 1360, 714, 708, 
        382, 1367, 587, 728, 1366, 704, 368, 573, 1291, 353, 558, 1280, 338, 
        543, 1272, 323, 528, 1266, 308, 513, 1262, 287, 499, 1358, 697, 726},
        VertexColors->None], 
       Line3DBox[{487, 689, 721, 1352, 473, 675, 1340, 458, 660, 1330, 443, 
        645, 1322, 428, 630, 1316, 413, 615, 1312, 398, 601, 710, 383, 1368, 
        588, 706, 1303, 369, 574, 1292, 354, 559, 1281, 339, 544, 1273, 324, 
        529, 1267, 309, 514, 1263, 288, 1171, 500, 699, 727},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJztXXdQ1Mm2xpwAZVVUVFR0TYiCWRSOOSKgq4JgxLAqK6IYyLKiYs4ZA66Y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     "],
    VertexNormals->CompressedData["
1:eJx1fHdYVEnzNYoKqBhQMeecUIyAaCmIcc2CGUEUFRPm7Bow56yIIipgBiPm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     "]], {}},
  Axes->True,
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotInteractivity:>True,
  PlotRange->{{-1, 1}, {-1, 1}, {0., 1.9999994285714693`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.9672754075959663`*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"90966d60-5395-4847-9ea4-2eb4a83c5e79"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"color=\"", "\"lightgray\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "21"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"box\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"mapacolor=\"", "\"hot\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.671008314241291`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.22766517782742002`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"puntossuperimpli=\"", "12178"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", "}"}]},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{3.9672754076028748`*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"9967c63b-4b49-4163-a6ec-38168c690e95"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9672754076406603`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"400a2041-487b-4b1a-bcd2-d2247f4b3063"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.96727540764139*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"16bb5c1c-1094-4bca-a8f4-8477acab2637"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967275407641925*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"1479f248-4f53-437e-a477-33bbd05b0617"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967275407642261*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"299abc2e-4985-4035-acac-6aa3a2149fc5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.967275407642593*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"a571ea0e-56ee-4a10-937e-49fb0e88073e"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.967275407703437*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"a0a87bff-d79b-4cde-b7ce-48197c3ef82f"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.967275408710664*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"60fd3310-0e85-4553-bbe5-6ea302385234"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D1/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D1/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.967275408716728*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"600c8074-c5bd-494b-a849-e56016b41719"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafica3D1\"\>"}],
  SequenceForm["Archivo: ", "grafica3D1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96727540871943*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"478f89a4-2be5-49e0-9d9d-bfde21e30b11"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.967275409849978*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"24af6fb8-8357-4db1-bc51-4ebb45ad0161"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D1/grafica3D1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D1/grafica3D1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9672754098508663`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[77]:=",ExpressionUUID->"c3b913cb-f87c-45fe-94ab-c8b5f12e8055"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafica3D1/\
grafica3D1.pdf\"\>"], "Output",
 CellChangeTimes->{3.967275409865141*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"29844962-de12-4f13-9318-7e44b8d44ae0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2", "Subsection",
 CellChangeTimes->{{3.967118818547166*^9, 3.967118820248961*^9}, {
   3.967118917479865*^9, 3.967118917731667*^9}, 
   3.967122045741542*^9},ExpressionUUID->"0afdc8ac-89c1-43eb-9767-\
df89fd5f5679"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"Opacity", "[", "0.7", "]"}]}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"ColorData", "[", "\"\<Gradients\>\"", "]"}], "]"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<color=\>\"", ",", 
      RowBox[{"color", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
          ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
          ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"",
           ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"",
           ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
          ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<white\>\"", 
          ",", "\"\<yellow\>\"", ",", "\"\<blue!50!red\>\"", 
          ",", "\"\<green!70!black\>\"", ",", "\"\<red!20!blue!80!green\>\"", 
          ",", "\"\<yellow!75!red\>\""}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"10", ",", "60"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<mapacolor=\>\"", ",", 
      RowBox[{"mapacolor", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<viridis\>\"", ",", "\"\<cool\>\"", ",", "\"\<hot\>\"", 
          ",", "\"\<jet\>\"", ",", "\"\<hsv\>\"", ",", "\"\<spring\>\"", 
          ",", "\"\<summer\>\"", ",", "\"\<autumn\>\"", ",", "\"\<winter\>\"",
           ",", "\"\<gray\>\"", ",", "\"\<blackwhite\>\""}], "}"}], "]"}]}]}],
      "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.2", ",", "1"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<puntossuperimpli=\>\"", ",", 
      RowBox[{"puntossuperimpli", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"8000", ",", "13000"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Centro\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<color\>\"", ",", 
              RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
         "}"}], "}"}]}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], 
    ",", "\"\<grafica3D2.tex\>\"", ",", "grid", ",", "color", ",", 
    "resolucion", ",", "estiloejes", ",", "mapacolor", ",", "opacidad", ",", 
    "extensionejes", ",", "puntossuperimpli", ",", "texto"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967121969279134*^9, 3.967121974336254*^9}, {
   3.96712205473982*^9, 3.9671220634819727`*^9}, {3.967192698549799*^9, 
   3.967192698991289*^9}, {3.9671938683754673`*^9, 3.9671938688048763`*^9}, {
   3.967195340711294*^9, 3.9671953414864616`*^9}, {3.967195523171383*^9, 
   3.9671955281161385`*^9}, {3.9671958720832233`*^9, 
   3.9671958893658104`*^9}, {3.967196523380808*^9, 3.9671965256985664`*^9}, {
   3.967196832346752*^9, 3.9671968660268116`*^9}, {3.9671969086716385`*^9, 
   3.9671969356610184`*^9}, {3.967196998723686*^9, 3.9671970083811226`*^9}, {
   3.9671973972480927`*^9, 3.967197446945938*^9}, {3.9671975211256065`*^9, 
   3.967197554804426*^9}, {3.967197676560629*^9, 3.967197708647457*^9}, 
   3.9671978112861786`*^9, {3.967197858723898*^9, 3.9671978591484375`*^9}, 
   3.9671987652925987`*^9, {3.9671997242104473`*^9, 3.9671997347096634`*^9}, {
   3.967200096909439*^9, 3.967200098338396*^9}, {3.9672010372781982`*^9, 
   3.967201065359661*^9}, 3.967201120725054*^9, {3.9672754690703363`*^9, 
   3.967275470045315*^9}, {3.967275508400938*^9, 3.967275509225943*^9}, {
   3.967275548139709*^9, 3.967275565389317*^9}, {3.967275614095038*^9, 
   3.9672756712362537`*^9}, {3.9672758193858757`*^9, 3.967275819659506*^9}, 
   3.967276099444305*^9},ExpressionUUID->"2cd5fc06-0978-4988-8df0-\
023b4d2cabf7"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1nXucllW1x81LKpiY4SU00BgvaB2sgxeQXKcoBQ3ziKmdTAs1MR25aKl4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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.7], EdgeForm[None], 
       Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJw1mQn8FtPbxp+Zc0bZFUWKJG3aN61atKosbSQhLbJnzdJuragUIaWkDUm2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            "]], Polygon3DBox[CompressedData["
1:eJwtmncAVtMfxu8Zr+yRJCkNGZUmpaJIQyppaCArI3tnZhQyki1+ZJUtKluD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            "]], Polygon3DBox[CompressedData["
1:eJwt13m8TfUWAPBzz7mXlNLLLENKpsxDyZikokGmlCFCMkbGTCEyRAkhUiqZ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            "]], 
           Polygon3DBox[{{1112, 600, 397, 396, 709, 1046}, {994, 588, 706, 
            1161, 834, 835}, {987, 581, 702, 1159, 820, 821}}]},
          Annotation[#, "Charting`Private`Tag$43452#1"]& ]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0ssqhVEUAODtnOPOQZIk5J7ERBnxBCQZkokZiSl5AFKm5AF4Ap6AJ3A7
7vc7IwPXAd8ug/V/a/W3117733/92PTQVFYIYUmkJTEv8LjhaSKEUj6zjl/s
ZF4yhF5Wsp8tHGFDKoQfdqsnGJsNymelo1zgJFc4x3UucpOr3GatHm8stXaX
RUyIS7GnvuI+r3nAG2Z4y0Pe8YjHZk3K78WxOsUHcSJ/5CmfeBbPx3O+8IKv
cT/u6fHOMvUVi5ktNsy6o17nFle4wQWucZbLnOA8W50py7qZ+K3kvxzwbpxd
HGYT+1jBHuawgx9mqI3fw7oHluhTwkJ+s51ptrE47sUiNrOQjSxgPfOZ0e8r
3qE4kH+yxrtcVjOHVfGc8X6ZijPROKE83gX3PT7+/5c/JaRCkA==
        "],
        VertexColors->None]}, 
      {GrayLevel[0.2], 
       Line3DBox[{732, 1037, 493, 731, 1166, 949, 733, 1167, 950, 734, 1168, 
        951, 735, 1169, 952, 736, 1170, 953, 737, 698, 1064, 1358, 738, 1038, 
        1171, 954, 739, 1172, 955, 740, 1173, 956, 741, 1174, 957, 742, 1175, 
        958, 743, 1176, 959, 744, 1359, 1039, 960, 1040},
        VertexColors->None], 
       Line3DBox[{746, 1065, 1261, 745, 507, 747, 1177, 961, 748, 1178, 962, 
        749, 1179, 963, 750, 1180, 964, 751, 1181, 1066, 1262, 752, 1067, 
        1263, 753, 1182, 965, 754, 1183, 966, 755, 1184, 967, 756, 1185, 968, 
        757, 1186, 969, 758, 1187, 970, 759},
        VertexColors->None], 
       Line3DBox[{761, 1068, 1264, 760, 1069, 1265, 762, 523, 763, 1188, 971, 
        764, 1189, 972, 765, 1190, 973, 766, 1191, 1070, 1266, 767, 1071, 
        1267, 768, 1072, 1268, 769, 531, 770, 1192, 974, 771, 1193, 975, 772, 
        1194, 976, 773, 1195, 977, 774},
        VertexColors->None], 
       Line3DBox[{776, 1073, 1269, 775, 1074, 1270, 777, 1075, 1271, 778, 539,
         779, 1196, 978, 780, 1197, 979, 781, 1198, 1076, 1272, 782, 1077, 
        1273, 783, 1078, 1274, 784, 1079, 1275, 785, 547, 786, 1199, 980, 787,
         1200, 981, 788, 1201, 982, 789},
        VertexColors->None], 
       Line3DBox[{791, 1080, 1276, 790, 1081, 1277, 792, 1082, 1278, 793, 
        1083, 1279, 794, 555, 795, 1202, 983, 796, 1203, 1084, 1280, 797, 
        1085, 1281, 798, 1086, 1282, 799, 1087, 1283, 800, 1088, 1284, 801, 
        1089, 1285, 802, 1204, 984, 803, 1205, 985, 804},
        VertexColors->None], 
       Line3DBox[{806, 1090, 1286, 805, 1091, 1287, 807, 1092, 1288, 808, 
        1093, 1289, 809, 1094, 1290, 810, 571, 811, 1206, 1095, 1291, 812, 
        1096, 1292, 813, 1097, 1293, 814, 1098, 1294, 815, 1099, 1295, 816, 
        1100, 1296, 817, 579, 818, 1207, 986, 819},
        VertexColors->None], 
       Line3DBox[{822, 1042, 1208, 987, 821, 1209, 988, 824, 1210, 989, 826, 
        1211, 990, 828, 1212, 991, 830, 1213, 992, 832, 1160, 1214, 1060, 
        1367, 993, 1059, 1045, 1061, 1368, 994, 835, 1215, 995, 837, 1216, 
        996, 839, 1217, 997, 841, 1218, 998, 843, 1219, 999, 845, 1162, 1220, 
        1000, 1062},
        VertexColors->None], 
       Line3DBox[{846, 1049, 1048, 1362, 844, 1308, 1110, 842, 1307, 1109, 
        840, 1306, 1108, 838, 1305, 1107, 836, 1304, 1106, 834, 1161, 1303, 
        1044, 833, 1366, 1043, 703, 831, 1302, 1105, 829, 1301, 1104, 827, 
        1300, 1103, 825, 1299, 1102, 823, 1298, 1101, 820, 1159, 1297, 1041, 
        1058},
        VertexColors->None], 
       Line3DBox[{848, 1050, 1111, 1363, 847, 1221, 1001, 849, 1222, 1002, 
        850, 1223, 1003, 851, 1224, 1004, 852, 1225, 1005, 853, 1361, 1046, 
        1112, 1360, 1051, 1047, 601, 854, 1226, 1006, 855, 1227, 1007, 856, 
        1228, 1008, 857, 1229, 1009, 858, 1230, 1010, 859, 1364, 1052, 1011, 
        1063},
        VertexColors->None], 
       Line3DBox[{861, 1113, 1309, 860, 1114, 1310, 862, 1231, 1012, 863, 
        1232, 1013, 864, 1233, 1014, 865, 1234, 1015, 866, 1235, 1115, 1311, 
        867, 1116, 1312, 868, 616, 869, 1236, 1016, 870, 1237, 1017, 871, 
        1238, 1018, 872, 1239, 1019, 873, 1240, 1020, 874},
        VertexColors->None], 
       Line3DBox[{876, 1117, 1313, 875, 1118, 1314, 877, 624, 878, 1241, 1021,
         879, 1242, 1022, 880, 1243, 1023, 881, 1244, 1119, 1315, 882, 1120, 
        1316, 883, 1121, 1317, 884, 632, 885, 1245, 1024, 886, 1246, 1025, 
        887, 1247, 1026, 888, 1248, 1027, 889},
        VertexColors->None], 
       Line3DBox[{891, 1122, 1318, 890, 1123, 1319, 892, 1124, 1320, 893, 640,
         894, 1249, 1028, 895, 1250, 1029, 896, 1251, 1125, 1321, 897, 1126, 
        1322, 898, 1127, 1323, 899, 1128, 1324, 900, 648, 901, 1252, 1030, 
        902, 1253, 1031, 903, 1254, 1032, 904},
        VertexColors->None], 
       Line3DBox[{906, 1129, 1325, 905, 1130, 1326, 907, 1131, 1327, 908, 
        1132, 1328, 909, 656, 910, 1255, 1033, 911, 1256, 1133, 1329, 912, 
        1134, 1330, 913, 1135, 1331, 914, 1136, 1332, 915, 1137, 1333, 916, 
        664, 917, 1257, 1034, 918, 1258, 1035, 919},
        VertexColors->None], 
       Line3DBox[{921, 1138, 1334, 920, 1139, 1335, 922, 1140, 1336, 923, 
        1141, 1337, 924, 1142, 1338, 925, 672, 926, 1259, 1143, 1339, 927, 
        1144, 1340, 928, 1145, 1341, 929, 1146, 1342, 930, 1147, 1343, 931, 
        1148, 1344, 932, 680, 933, 1260, 1036, 934},
        VertexColors->None], 
       Line3DBox[{948, 1057, 722, 947, 1357, 1158, 946, 1356, 1157, 945, 1355,
         1156, 944, 1354, 1155, 943, 1353, 1154, 942, 1165, 1352, 1056, 941, 
        1365, 1055, 1351, 1164, 940, 1350, 1153, 939, 1349, 1152, 938, 1348, 
        1151, 937, 1347, 1150, 936, 1346, 1149, 935, 1163, 1345, 1053, 1054},
        VertexColors->None]}, 
      {GrayLevel[0.2], 
       Line3DBox[{275, 494, 1166, 276, 507, 302, 1265, 522, 317, 1270, 537, 
        332, 1277, 552, 347, 1287, 567, 362, 1298, 582, 1209, 377, 595, 1221, 
        391, 1310, 608, 406, 1314, 623, 421, 1319, 638, 436, 1326, 653, 451, 
        1335, 668, 466, 1346, 683, 481},
        VertexColors->None], 
       Line3DBox[{277, 495, 1167, 278, 508, 1177, 303, 523, 318, 1271, 538, 
        333, 1278, 553, 348, 1288, 568, 363, 1299, 583, 1210, 378, 596, 1222, 
        392, 609, 1231, 407, 624, 422, 1320, 639, 437, 1327, 654, 452, 1336, 
        669, 467, 1347, 684, 482},
        VertexColors->None], 
       Line3DBox[{279, 496, 1168, 280, 509, 1178, 304, 524, 1188, 319, 539, 
        334, 1279, 554, 349, 1289, 569, 364, 1300, 584, 1211, 379, 597, 1223, 
        393, 610, 1232, 408, 625, 1241, 423, 640, 438, 1328, 655, 453, 1337, 
        670, 468, 1348, 685, 483},
        VertexColors->None], 
       Line3DBox[{281, 497, 1169, 282, 510, 1179, 305, 525, 1189, 320, 540, 
        1196, 335, 555, 350, 1290, 570, 365, 1301, 585, 1212, 380, 598, 1224, 
        394, 611, 1233, 409, 626, 1242, 424, 641, 1249, 439, 656, 454, 1338, 
        671, 469, 1349, 686, 484},
        VertexColors->None], 
       Line3DBox[{283, 498, 1170, 284, 511, 1180, 306, 526, 1190, 321, 541, 
        1197, 336, 556, 1202, 351, 571, 366, 1302, 586, 1213, 381, 599, 1225, 
        395, 612, 1234, 410, 627, 1243, 425, 642, 1250, 440, 657, 1255, 455, 
        672, 470, 1350, 687, 485},
        VertexColors->None], 
       Line3DBox[{285, 696, 698, 286, 512, 1181, 307, 527, 1191, 322, 542, 
        1198, 337, 557, 1203, 352, 572, 1206, 367, 703, 705, 1214, 729, 707, 
        1361, 709, 396, 613, 1235, 411, 628, 1244, 426, 643, 1251, 441, 658, 
        1256, 456, 673, 1259, 471, 1351, 718, 720, 730},
        VertexColors->None], 
       Line3DBox[{289, 501, 1172, 290, 515, 1182, 310, 1268, 530, 325, 1274, 
        545, 340, 1282, 560, 355, 1293, 575, 370, 1304, 589, 1215, 384, 602, 
        1226, 399, 616, 414, 1317, 631, 429, 1323, 646, 444, 1331, 661, 459, 
        1341, 676, 474, 1353, 690, 488},
        VertexColors->None], 
       Line3DBox[{291, 502, 1173, 292, 516, 1183, 311, 531, 326, 1275, 546, 
        341, 1283, 561, 356, 1294, 576, 371, 1305, 590, 1216, 385, 603, 1227, 
        400, 617, 1236, 415, 632, 430, 1324, 647, 445, 1332, 662, 460, 1342, 
        677, 475, 1354, 691, 489},
        VertexColors->None], 
       Line3DBox[{293, 503, 1174, 294, 517, 1184, 312, 532, 1192, 327, 547, 
        342, 1284, 562, 357, 1295, 577, 372, 1306, 591, 1217, 386, 604, 1228, 
        401, 618, 1237, 416, 633, 1245, 431, 648, 446, 1333, 663, 461, 1343, 
        678, 476, 1355, 692, 490},
        VertexColors->None], 
       Line3DBox[{295, 504, 1175, 296, 518, 1185, 313, 533, 1193, 328, 548, 
        1199, 343, 1285, 563, 358, 1296, 578, 373, 1307, 592, 1218, 387, 605, 
        1229, 402, 619, 1238, 417, 634, 1246, 432, 649, 1252, 447, 664, 462, 
        1344, 679, 477, 1356, 693, 491},
        VertexColors->None], 
       Line3DBox[{297, 505, 1176, 298, 519, 1186, 314, 534, 1194, 329, 549, 
        1200, 344, 564, 1204, 359, 579, 374, 1308, 593, 1219, 388, 606, 1230, 
        403, 620, 1239, 418, 635, 1247, 433, 650, 1253, 448, 665, 1257, 463, 
        680, 478, 1357, 694, 492},
        VertexColors->None], 
       Line3DBox[{299, 700, 1359, 701, 300, 520, 1187, 315, 535, 1195, 330, 
        550, 1201, 345, 565, 1205, 360, 580, 1207, 375, 711, 1362, 712, 1220, 
        389, 715, 1364, 716, 404, 621, 1240, 419, 636, 1248, 434, 651, 1254, 
        449, 666, 1258, 464, 681, 1260, 479, 722, 723, 724},
        VertexColors->None], 
       Line3DBox[{480, 682, 717, 1345, 465, 667, 1334, 450, 652, 1325, 435, 
        637, 1318, 420, 622, 1313, 405, 607, 1309, 390, 594, 1363, 713, 376, 
        1208, 581, 702, 1297, 361, 566, 1286, 346, 551, 1276, 331, 536, 1269, 
        316, 521, 1264, 301, 506, 1261, 274, 493, 695, 725},
        VertexColors->None], 
       Line3DBox[{486, 688, 1365, 719, 472, 674, 1339, 457, 659, 1329, 442, 
        644, 1321, 427, 629, 1315, 412, 614, 1311, 397, 600, 1360, 714, 708, 
        382, 1367, 587, 728, 1366, 704, 368, 573, 1291, 353, 558, 1280, 338, 
        543, 1272, 323, 528, 1266, 308, 513, 1262, 287, 499, 1358, 697, 726},
        VertexColors->None], 
       Line3DBox[{487, 689, 721, 1352, 473, 675, 1340, 458, 660, 1330, 443, 
        645, 1322, 428, 630, 1316, 413, 615, 1312, 398, 601, 710, 383, 1368, 
        588, 706, 1303, 369, 574, 1292, 354, 559, 1281, 339, 544, 1273, 324, 
        529, 1267, 309, 514, 1263, 288, 1171, 500, 699, 727},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJztXWdQVcm2RsE4qIComAYVIyYUEcPgMmJArxEwK4oOmDNiwIAJA4I6KogR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     "],
    VertexNormals->CompressedData["
1:eJx1fHdYVEnzNYoKqBhQMeecUIyAaCmIcc2CGUEUFRPm7Bow56yIIipgBiPm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     "]], {}},
  Axes->True,
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotInteractivity:>True,
  PlotRange->{{-1, 1}, {-1, 1}, {0., 1.9999994285714693`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967196783238928*^9, 3.967196868945837*^9, {3.967196942816492*^9, 
   3.9671969663837223`*^9}, 3.967197558758089*^9, 3.9671977136551914`*^9, {
   3.967197782606735*^9, 3.9671978124527683`*^9}, 3.967197860828697*^9, 
   3.9671985047158737`*^9, 3.967198536765646*^9, 3.9671985783491325`*^9, 
   3.9671993793388805`*^9, {3.96719947410359*^9, 3.9671994946929283`*^9}, 
   3.9671995453189735`*^9, 3.967200957198887*^9, {3.967201050278511*^9, 
   3.9672010664224033`*^9}, 3.967275681815621*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"2ffc9463-9ac5-4984-8bbe-d63d0d5402e0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"color=\"", "\"lime\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "28"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"box\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"mapacolor=\"", "\"winter\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.6308622406665472`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.2596545861142236`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"puntossuperimpli=\"", "10758"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Centro\"", ",", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"brown\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\normalsize\""}], "}"}], ",", 
               
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"north\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "309.53062875316033`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967196783238928*^9, 3.967196868945837*^9, {3.967196942816492*^9, 
   3.9671969663837223`*^9}, 3.967197558758089*^9, 3.9671977136551914`*^9, {
   3.967197782606735*^9, 3.9671978124527683`*^9}, 3.967197860828697*^9, 
   3.9671985047158737`*^9, 3.967198536765646*^9, 3.9671985783491325`*^9, 
   3.9671993793388805`*^9, {3.96719947410359*^9, 3.9671994946929283`*^9}, 
   3.9671995453189735`*^9, 3.967200957198887*^9, {3.967201050278511*^9, 
   3.9672010664224033`*^9}, 3.967275681820771*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"2a3d1f33-0cdd-4e05-ac77-7452ad2e2e0e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9671967844801865`*^9, 3.9671968692749825`*^9, {3.9671969431484184`*^9, 
   3.9671969667491302`*^9}, 3.9671975593624725`*^9, 3.9671977140272865`*^9, {
   3.967197784459526*^9, 3.9671978133926983`*^9}, 3.967197861139641*^9, 
   3.967198505076103*^9, 3.967198537785879*^9, 3.9671985791388035`*^9, 
   3.967199379649481*^9, {3.9671994744739323`*^9, 3.967199495037508*^9}, 
   3.9671995456169987`*^9, 3.9672009575149593`*^9, {3.9672010506339397`*^9, 
   3.967201066728037*^9}, 3.967275681867086*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"bfbb0f20-8814-49e4-bdff-cc1f6a2733bf"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.9671967844801865`*^9, 3.9671968692749825`*^9, {3.9671969431484184`*^9, 
   3.9671969667491302`*^9}, 3.9671975593624725`*^9, 3.9671977140272865`*^9, {
   3.967197784459526*^9, 3.9671978133926983`*^9}, 3.967197861139641*^9, 
   3.967198505076103*^9, 3.967198537785879*^9, 3.9671985791388035`*^9, 
   3.967199379649481*^9, {3.9671994744739323`*^9, 3.967199495037508*^9}, 
   3.9671995456169987`*^9, 3.9672009575149593`*^9, {3.9672010506339397`*^9, 
   3.967201066728037*^9}, 3.96727568186793*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"79698ac3-b475-4ad5-9f9b-81d07bd73d65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9671967844801865`*^9, 3.9671968692749825`*^9, {3.9671969431484184`*^9, 
   3.9671969667491302`*^9}, 3.9671975593624725`*^9, 3.9671977140272865`*^9, {
   3.967197784459526*^9, 3.9671978133926983`*^9}, 3.967197861139641*^9, 
   3.967198505076103*^9, 3.967198537785879*^9, 3.9671985791388035`*^9, 
   3.967199379649481*^9, {3.9671994744739323`*^9, 3.967199495037508*^9}, 
   3.9671995456169987`*^9, 3.9672009575149593`*^9, {3.9672010506339397`*^9, 
   3.967201066728037*^9}, 3.967275681868466*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"3719aee7-3f28-4477-bd5c-2c74221dfa69"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9671967844801865`*^9, 3.9671968692749825`*^9, {3.9671969431484184`*^9, 
   3.9671969667491302`*^9}, 3.9671975593624725`*^9, 3.9671977140272865`*^9, {
   3.967197784459526*^9, 3.9671978133926983`*^9}, 3.967197861139641*^9, 
   3.967198505076103*^9, 3.967198537785879*^9, 3.9671985791388035`*^9, 
   3.967199379649481*^9, {3.9671994744739323`*^9, 3.967199495037508*^9}, 
   3.9671995456169987`*^9, 3.9672009575149593`*^9, {3.9672010506339397`*^9, 
   3.967201066728037*^9}, 3.9672756818687973`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"f8ecc019-4443-4b7b-8753-425e170e1c9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9671967844801865`*^9, 3.9671968692749825`*^9, {3.9671969431484184`*^9, 
   3.9671969667491302`*^9}, 3.9671975593624725`*^9, 3.9671977140272865`*^9, {
   3.967197784459526*^9, 3.9671978133926983`*^9}, 3.967197861139641*^9, 
   3.967198505076103*^9, 3.967198537785879*^9, 3.9671985791388035`*^9, 
   3.967199379649481*^9, {3.9671994744739323`*^9, 3.967199495037508*^9}, 
   3.9671995456169987`*^9, 3.9672009575149593`*^9, {3.9672010506339397`*^9, 
   3.967201066728037*^9}, 3.9672756818691187`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"ef1d20e1-7ec9-4644-96bf-dab0fd54ceba"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.9671967844801865`*^9, 3.9671968692749825`*^9, {3.9671969431484184`*^9, 
   3.9671969667491302`*^9}, 3.9671975593624725`*^9, 3.9671977140272865`*^9, {
   3.967197784459526*^9, 3.9671978133926983`*^9}, 3.967197861139641*^9, 
   3.967198505076103*^9, 3.967198537785879*^9, 3.9671985791388035`*^9, 
   3.967199379649481*^9, {3.9671994744739323`*^9, 3.967199495037508*^9}, 
   3.9671995456169987`*^9, 3.9672009575149593`*^9, {3.9672010506339397`*^9, 
   3.967201066728037*^9}, 3.9672756819357433`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"afb4ff18-c9cf-40a1-96e3-931e11a92903"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.9671967844801865`*^9, 3.9671968692749825`*^9, {3.9671969431484184`*^9, 
   3.9671969667491302`*^9}, 3.9671975593624725`*^9, 3.9671977140272865`*^9, {
   3.967197784459526*^9, 3.9671978133926983`*^9}, 3.967197861139641*^9, 
   3.967198505076103*^9, 3.967198537785879*^9, 3.9671985791388035`*^9, 
   3.967199379649481*^9, {3.9671994744739323`*^9, 3.967199495037508*^9}, 
   3.9671995456169987`*^9, 3.9672009575149593`*^9, {3.9672010506339397`*^9, 
   3.967201066728037*^9}, 3.967275682942981*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"28387987-c822-4340-a7df-6c152d4b6268"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D2/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D2/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9671967844801865`*^9, 3.9671968692749825`*^9, {3.9671969431484184`*^9, 
   3.9671969667491302`*^9}, 3.9671975593624725`*^9, 3.9671977140272865`*^9, {
   3.967197784459526*^9, 3.9671978133926983`*^9}, 3.967197861139641*^9, 
   3.967198505076103*^9, 3.967198537785879*^9, 3.9671985791388035`*^9, 
   3.967199379649481*^9, {3.9671994744739323`*^9, 3.967199495037508*^9}, 
   3.9671995456169987`*^9, 3.9672009575149593`*^9, {3.9672010506339397`*^9, 
   3.967201066728037*^9}, 3.967275682947887*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"5bcb4ac4-b711-423e-904e-d4116b7eaedf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafica3D2\"\>"}],
  SequenceForm["Archivo: ", "grafica3D2"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9671967844801865`*^9, 3.9671968692749825`*^9, {3.9671969431484184`*^9, 
   3.9671969667491302`*^9}, 3.9671975593624725`*^9, 3.9671977140272865`*^9, {
   3.967197784459526*^9, 3.9671978133926983`*^9}, 3.967197861139641*^9, 
   3.967198505076103*^9, 3.967198537785879*^9, 3.9671985791388035`*^9, 
   3.967199379649481*^9, {3.9671994744739323`*^9, 3.967199495037508*^9}, 
   3.9671995456169987`*^9, 3.9672009575149593`*^9, {3.9672010506339397`*^9, 
   3.967201066728037*^9}, 3.967275682950302*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"c0db8790-fbd1-443c-bbc3-d02508bc4bff"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.9671967844801865`*^9, 3.9671968692749825`*^9, {3.9671969431484184`*^9, 
   3.9671969667491302`*^9}, 3.9671975593624725`*^9, 3.9671977140272865`*^9, {
   3.967197784459526*^9, 3.9671978133926983`*^9}, 3.967197861139641*^9, 
   3.967198505076103*^9, 3.967198537785879*^9, 3.9671985791388035`*^9, 
   3.967199379649481*^9, {3.9671994744739323`*^9, 3.967199495037508*^9}, 
   3.9671995456169987`*^9, 3.9672009575149593`*^9, {3.9672010506339397`*^9, 
   3.967201066728037*^9}, 3.967275684584923*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"d1b5b9d6-9e5e-426b-b100-705ddc6da98d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D2/grafica3D2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D2/grafica3D2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9671967844801865`*^9, 3.9671968692749825`*^9, {3.9671969431484184`*^9, 
   3.9671969667491302`*^9}, 3.9671975593624725`*^9, 3.9671977140272865`*^9, {
   3.967197784459526*^9, 3.9671978133926983`*^9}, 3.967197861139641*^9, 
   3.967198505076103*^9, 3.967198537785879*^9, 3.9671985791388035`*^9, 
   3.967199379649481*^9, {3.9671994744739323`*^9, 3.967199495037508*^9}, 
   3.9671995456169987`*^9, 3.9672009575149593`*^9, {3.9672010506339397`*^9, 
   3.967201066728037*^9}, 3.9672756845858393`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[81]:=",ExpressionUUID->"2003fa8e-96ce-49d1-9318-c9d492e15178"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafica3D2/\
grafica3D2.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967196783238928*^9, 3.967196868945837*^9, {3.967196942816492*^9, 
   3.9671969663837223`*^9}, 3.967197558758089*^9, 3.9671977136551914`*^9, {
   3.967197782606735*^9, 3.9671978124527683`*^9}, 3.967197860828697*^9, 
   3.9671985047158737`*^9, 3.967198536765646*^9, 3.9671985783491325`*^9, 
   3.9671993793388805`*^9, {3.96719947410359*^9, 3.9671994946929283`*^9}, 
   3.9671995453189735`*^9, 3.967200957198887*^9, {3.967201050278511*^9, 
   3.9672010664224033`*^9}, 3.967275684599272*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"11108f1c-6330-4d55-8939-75d31ae3f06f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3", "Subsection",
 CellChangeTimes->{{3.967118818547166*^9, 3.967118843849774*^9}, 
   3.967122077092573*^9},ExpressionUUID->"4bde18f3-5ff3-4a95-8513-\
bd077a116973"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"Opacity", "[", "0.7", "]"}]}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"ColorData", "[", "\"\<Gradients\>\"", "]"}], "]"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<color=\>\"", ",", 
      RowBox[{"color", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
          ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
          ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"",
           ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"",
           ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
          ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<white\>\"", 
          ",", "\"\<yellow\>\"", ",", "\"\<blue!50!red\>\"", 
          ",", "\"\<green!70!black\>\"", ",", "\"\<red!20!blue!80!green\>\"", 
          ",", "\"\<yellow!75!red\>\""}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"10", ",", "60"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<mapacolor=\>\"", ",", 
      RowBox[{"mapacolor", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<viridis\>\"", ",", "\"\<cool\>\"", ",", "\"\<hot\>\"", 
          ",", "\"\<jet\>\"", ",", "\"\<hsv\>\"", ",", "\"\<spring\>\"", 
          ",", "\"\<summer\>\"", ",", "\"\<autumn\>\"", ",", "\"\<winter\>\"",
           ",", "\"\<gray\>\"", ",", "\"\<blackwhite\>\""}], "}"}], "]"}]}]}],
      "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.2", ",", "1"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<puntossuperimpli=\>\"", ",", 
      RowBox[{"puntossuperimpli", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"8000", ",", "13000"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Origen\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<color\>\"", ",", 
               RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}]}], "}"}]}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<M\[AAcute]ximo local\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"\"\<color\>\"", ",", 
              RowBox[{"colortexto", "[", "]"}]}], "}"}], "}"}]}], "}"}], ",", 
         
         RowBox[{"{", 
          RowBox[{"\"\<Punto $A$\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", 
             RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
          "}"}]}], "}"}]}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}], 
    ",", "\"\<grafica3D3.tex\>\"", ",", "grid", ",", "color", ",", 
    "resolucion", ",", "estiloejes", ",", "mapacolor", ",", "opacidad", ",", 
    "extensionejes", ",", "puntossuperimpli", ",", "texto"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967122081095276*^9, 3.967122087013865*^9}, {
   3.9671927034651394`*^9, 3.967192704015421*^9}, {3.9671938753022537`*^9, 
   3.967193875721403*^9}, {3.967195346474716*^9, 3.967195347274269*^9}, {
   3.9671955082595673`*^9, 3.967195513832258*^9}, {3.967195906507654*^9, 
   3.9671959145808296`*^9}, {3.9671965304335117`*^9, 3.9671965322497215`*^9}, 
   3.967198773493784*^9, {3.9671997647620773`*^9, 3.9671998567510624`*^9}, {
   3.9671999559761124`*^9, 3.967199956399599*^9}, {3.9671999946676407`*^9, 
   3.967200000684679*^9}, {3.9672000855674534`*^9, 3.9672000860062046`*^9}, 
   3.967201143908346*^9, {3.9672058436410904`*^9, 3.967205844734951*^9}, {
   3.967275768163669*^9, 3.967275768558622*^9}, {3.9672758058598623`*^9, 
   3.9672758064288054`*^9}, {3.967275890232108*^9, 3.967275896398939*^9}, {
   3.9672760820301037`*^9, 3.9672760903086767`*^9}, 
   3.967278973480751*^9},ExpressionUUID->"656fd96a-62d4-49b2-af02-\
003b6c1e2a19"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1nXucllW1x81LKpiY4SU00BgvaB2sgxeQXKcoBQ3ziKmdTAs1MR25aKl4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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.7], EdgeForm[None], 
       Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJw1mQn8FtPbxp+Zc0bZFUWKJG3aN61atKosbSQhLbJnzdJuragUIaWkDUm2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            "]], Polygon3DBox[CompressedData["
1:eJwtmncAVtMfxu8Zr+yRJCkNGZUmpaJIQyppaCArI3tnZhQyki1+ZJUtKluD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            "]], Polygon3DBox[CompressedData["
1:eJwt13m8TfUWAPBzz7mXlNLLLENKpsxDyZikokGmlCFCMkbGTCEyRAkhUiqZ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            "]], 
           Polygon3DBox[{{1112, 600, 397, 396, 709, 1046}, {994, 588, 706, 
            1161, 834, 835}, {987, 581, 702, 1159, 820, 821}}]},
          Annotation[#, "Charting`Private`Tag$47968#1"]& ]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0ssqhVEUAODtnOPOQZIk5J7ERBnxBCQZkokZiSl5AFKm5AF4Ap6AJ3A7
7vc7IwPXAd8ug/V/a/W3117733/92PTQVFYIYUmkJTEv8LjhaSKEUj6zjl/s
ZF4yhF5Wsp8tHGFDKoQfdqsnGJsNymelo1zgJFc4x3UucpOr3GatHm8stXaX
RUyIS7GnvuI+r3nAG2Z4y0Pe8YjHZk3K78WxOsUHcSJ/5CmfeBbPx3O+8IKv
cT/u6fHOMvUVi5ktNsy6o17nFle4wQWucZbLnOA8W50py7qZ+K3kvxzwbpxd
HGYT+1jBHuawgx9mqI3fw7oHluhTwkJ+s51ptrE47sUiNrOQjSxgPfOZ0e8r
3qE4kH+yxrtcVjOHVfGc8X6ZijPROKE83gX3PT7+/5c/JaRCkA==
        "],
        VertexColors->None]}, 
      {GrayLevel[0.2], 
       Line3DBox[{732, 1037, 493, 731, 1166, 949, 733, 1167, 950, 734, 1168, 
        951, 735, 1169, 952, 736, 1170, 953, 737, 698, 1064, 1358, 738, 1038, 
        1171, 954, 739, 1172, 955, 740, 1173, 956, 741, 1174, 957, 742, 1175, 
        958, 743, 1176, 959, 744, 1359, 1039, 960, 1040},
        VertexColors->None], 
       Line3DBox[{746, 1065, 1261, 745, 507, 747, 1177, 961, 748, 1178, 962, 
        749, 1179, 963, 750, 1180, 964, 751, 1181, 1066, 1262, 752, 1067, 
        1263, 753, 1182, 965, 754, 1183, 966, 755, 1184, 967, 756, 1185, 968, 
        757, 1186, 969, 758, 1187, 970, 759},
        VertexColors->None], 
       Line3DBox[{761, 1068, 1264, 760, 1069, 1265, 762, 523, 763, 1188, 971, 
        764, 1189, 972, 765, 1190, 973, 766, 1191, 1070, 1266, 767, 1071, 
        1267, 768, 1072, 1268, 769, 531, 770, 1192, 974, 771, 1193, 975, 772, 
        1194, 976, 773, 1195, 977, 774},
        VertexColors->None], 
       Line3DBox[{776, 1073, 1269, 775, 1074, 1270, 777, 1075, 1271, 778, 539,
         779, 1196, 978, 780, 1197, 979, 781, 1198, 1076, 1272, 782, 1077, 
        1273, 783, 1078, 1274, 784, 1079, 1275, 785, 547, 786, 1199, 980, 787,
         1200, 981, 788, 1201, 982, 789},
        VertexColors->None], 
       Line3DBox[{791, 1080, 1276, 790, 1081, 1277, 792, 1082, 1278, 793, 
        1083, 1279, 794, 555, 795, 1202, 983, 796, 1203, 1084, 1280, 797, 
        1085, 1281, 798, 1086, 1282, 799, 1087, 1283, 800, 1088, 1284, 801, 
        1089, 1285, 802, 1204, 984, 803, 1205, 985, 804},
        VertexColors->None], 
       Line3DBox[{806, 1090, 1286, 805, 1091, 1287, 807, 1092, 1288, 808, 
        1093, 1289, 809, 1094, 1290, 810, 571, 811, 1206, 1095, 1291, 812, 
        1096, 1292, 813, 1097, 1293, 814, 1098, 1294, 815, 1099, 1295, 816, 
        1100, 1296, 817, 579, 818, 1207, 986, 819},
        VertexColors->None], 
       Line3DBox[{822, 1042, 1208, 987, 821, 1209, 988, 824, 1210, 989, 826, 
        1211, 990, 828, 1212, 991, 830, 1213, 992, 832, 1160, 1214, 1060, 
        1367, 993, 1059, 1045, 1061, 1368, 994, 835, 1215, 995, 837, 1216, 
        996, 839, 1217, 997, 841, 1218, 998, 843, 1219, 999, 845, 1162, 1220, 
        1000, 1062},
        VertexColors->None], 
       Line3DBox[{846, 1049, 1048, 1362, 844, 1308, 1110, 842, 1307, 1109, 
        840, 1306, 1108, 838, 1305, 1107, 836, 1304, 1106, 834, 1161, 1303, 
        1044, 833, 1366, 1043, 703, 831, 1302, 1105, 829, 1301, 1104, 827, 
        1300, 1103, 825, 1299, 1102, 823, 1298, 1101, 820, 1159, 1297, 1041, 
        1058},
        VertexColors->None], 
       Line3DBox[{848, 1050, 1111, 1363, 847, 1221, 1001, 849, 1222, 1002, 
        850, 1223, 1003, 851, 1224, 1004, 852, 1225, 1005, 853, 1361, 1046, 
        1112, 1360, 1051, 1047, 601, 854, 1226, 1006, 855, 1227, 1007, 856, 
        1228, 1008, 857, 1229, 1009, 858, 1230, 1010, 859, 1364, 1052, 1011, 
        1063},
        VertexColors->None], 
       Line3DBox[{861, 1113, 1309, 860, 1114, 1310, 862, 1231, 1012, 863, 
        1232, 1013, 864, 1233, 1014, 865, 1234, 1015, 866, 1235, 1115, 1311, 
        867, 1116, 1312, 868, 616, 869, 1236, 1016, 870, 1237, 1017, 871, 
        1238, 1018, 872, 1239, 1019, 873, 1240, 1020, 874},
        VertexColors->None], 
       Line3DBox[{876, 1117, 1313, 875, 1118, 1314, 877, 624, 878, 1241, 1021,
         879, 1242, 1022, 880, 1243, 1023, 881, 1244, 1119, 1315, 882, 1120, 
        1316, 883, 1121, 1317, 884, 632, 885, 1245, 1024, 886, 1246, 1025, 
        887, 1247, 1026, 888, 1248, 1027, 889},
        VertexColors->None], 
       Line3DBox[{891, 1122, 1318, 890, 1123, 1319, 892, 1124, 1320, 893, 640,
         894, 1249, 1028, 895, 1250, 1029, 896, 1251, 1125, 1321, 897, 1126, 
        1322, 898, 1127, 1323, 899, 1128, 1324, 900, 648, 901, 1252, 1030, 
        902, 1253, 1031, 903, 1254, 1032, 904},
        VertexColors->None], 
       Line3DBox[{906, 1129, 1325, 905, 1130, 1326, 907, 1131, 1327, 908, 
        1132, 1328, 909, 656, 910, 1255, 1033, 911, 1256, 1133, 1329, 912, 
        1134, 1330, 913, 1135, 1331, 914, 1136, 1332, 915, 1137, 1333, 916, 
        664, 917, 1257, 1034, 918, 1258, 1035, 919},
        VertexColors->None], 
       Line3DBox[{921, 1138, 1334, 920, 1139, 1335, 922, 1140, 1336, 923, 
        1141, 1337, 924, 1142, 1338, 925, 672, 926, 1259, 1143, 1339, 927, 
        1144, 1340, 928, 1145, 1341, 929, 1146, 1342, 930, 1147, 1343, 931, 
        1148, 1344, 932, 680, 933, 1260, 1036, 934},
        VertexColors->None], 
       Line3DBox[{948, 1057, 722, 947, 1357, 1158, 946, 1356, 1157, 945, 1355,
         1156, 944, 1354, 1155, 943, 1353, 1154, 942, 1165, 1352, 1056, 941, 
        1365, 1055, 1351, 1164, 940, 1350, 1153, 939, 1349, 1152, 938, 1348, 
        1151, 937, 1347, 1150, 936, 1346, 1149, 935, 1163, 1345, 1053, 1054},
        VertexColors->None]}, 
      {GrayLevel[0.2], 
       Line3DBox[{275, 494, 1166, 276, 507, 302, 1265, 522, 317, 1270, 537, 
        332, 1277, 552, 347, 1287, 567, 362, 1298, 582, 1209, 377, 595, 1221, 
        391, 1310, 608, 406, 1314, 623, 421, 1319, 638, 436, 1326, 653, 451, 
        1335, 668, 466, 1346, 683, 481},
        VertexColors->None], 
       Line3DBox[{277, 495, 1167, 278, 508, 1177, 303, 523, 318, 1271, 538, 
        333, 1278, 553, 348, 1288, 568, 363, 1299, 583, 1210, 378, 596, 1222, 
        392, 609, 1231, 407, 624, 422, 1320, 639, 437, 1327, 654, 452, 1336, 
        669, 467, 1347, 684, 482},
        VertexColors->None], 
       Line3DBox[{279, 496, 1168, 280, 509, 1178, 304, 524, 1188, 319, 539, 
        334, 1279, 554, 349, 1289, 569, 364, 1300, 584, 1211, 379, 597, 1223, 
        393, 610, 1232, 408, 625, 1241, 423, 640, 438, 1328, 655, 453, 1337, 
        670, 468, 1348, 685, 483},
        VertexColors->None], 
       Line3DBox[{281, 497, 1169, 282, 510, 1179, 305, 525, 1189, 320, 540, 
        1196, 335, 555, 350, 1290, 570, 365, 1301, 585, 1212, 380, 598, 1224, 
        394, 611, 1233, 409, 626, 1242, 424, 641, 1249, 439, 656, 454, 1338, 
        671, 469, 1349, 686, 484},
        VertexColors->None], 
       Line3DBox[{283, 498, 1170, 284, 511, 1180, 306, 526, 1190, 321, 541, 
        1197, 336, 556, 1202, 351, 571, 366, 1302, 586, 1213, 381, 599, 1225, 
        395, 612, 1234, 410, 627, 1243, 425, 642, 1250, 440, 657, 1255, 455, 
        672, 470, 1350, 687, 485},
        VertexColors->None], 
       Line3DBox[{285, 696, 698, 286, 512, 1181, 307, 527, 1191, 322, 542, 
        1198, 337, 557, 1203, 352, 572, 1206, 367, 703, 705, 1214, 729, 707, 
        1361, 709, 396, 613, 1235, 411, 628, 1244, 426, 643, 1251, 441, 658, 
        1256, 456, 673, 1259, 471, 1351, 718, 720, 730},
        VertexColors->None], 
       Line3DBox[{289, 501, 1172, 290, 515, 1182, 310, 1268, 530, 325, 1274, 
        545, 340, 1282, 560, 355, 1293, 575, 370, 1304, 589, 1215, 384, 602, 
        1226, 399, 616, 414, 1317, 631, 429, 1323, 646, 444, 1331, 661, 459, 
        1341, 676, 474, 1353, 690, 488},
        VertexColors->None], 
       Line3DBox[{291, 502, 1173, 292, 516, 1183, 311, 531, 326, 1275, 546, 
        341, 1283, 561, 356, 1294, 576, 371, 1305, 590, 1216, 385, 603, 1227, 
        400, 617, 1236, 415, 632, 430, 1324, 647, 445, 1332, 662, 460, 1342, 
        677, 475, 1354, 691, 489},
        VertexColors->None], 
       Line3DBox[{293, 503, 1174, 294, 517, 1184, 312, 532, 1192, 327, 547, 
        342, 1284, 562, 357, 1295, 577, 372, 1306, 591, 1217, 386, 604, 1228, 
        401, 618, 1237, 416, 633, 1245, 431, 648, 446, 1333, 663, 461, 1343, 
        678, 476, 1355, 692, 490},
        VertexColors->None], 
       Line3DBox[{295, 504, 1175, 296, 518, 1185, 313, 533, 1193, 328, 548, 
        1199, 343, 1285, 563, 358, 1296, 578, 373, 1307, 592, 1218, 387, 605, 
        1229, 402, 619, 1238, 417, 634, 1246, 432, 649, 1252, 447, 664, 462, 
        1344, 679, 477, 1356, 693, 491},
        VertexColors->None], 
       Line3DBox[{297, 505, 1176, 298, 519, 1186, 314, 534, 1194, 329, 549, 
        1200, 344, 564, 1204, 359, 579, 374, 1308, 593, 1219, 388, 606, 1230, 
        403, 620, 1239, 418, 635, 1247, 433, 650, 1253, 448, 665, 1257, 463, 
        680, 478, 1357, 694, 492},
        VertexColors->None], 
       Line3DBox[{299, 700, 1359, 701, 300, 520, 1187, 315, 535, 1195, 330, 
        550, 1201, 345, 565, 1205, 360, 580, 1207, 375, 711, 1362, 712, 1220, 
        389, 715, 1364, 716, 404, 621, 1240, 419, 636, 1248, 434, 651, 1254, 
        449, 666, 1258, 464, 681, 1260, 479, 722, 723, 724},
        VertexColors->None], 
       Line3DBox[{480, 682, 717, 1345, 465, 667, 1334, 450, 652, 1325, 435, 
        637, 1318, 420, 622, 1313, 405, 607, 1309, 390, 594, 1363, 713, 376, 
        1208, 581, 702, 1297, 361, 566, 1286, 346, 551, 1276, 331, 536, 1269, 
        316, 521, 1264, 301, 506, 1261, 274, 493, 695, 725},
        VertexColors->None], 
       Line3DBox[{486, 688, 1365, 719, 472, 674, 1339, 457, 659, 1329, 442, 
        644, 1321, 427, 629, 1315, 412, 614, 1311, 397, 600, 1360, 714, 708, 
        382, 1367, 587, 728, 1366, 704, 368, 573, 1291, 353, 558, 1280, 338, 
        543, 1272, 323, 528, 1266, 308, 513, 1262, 287, 499, 1358, 697, 726},
        VertexColors->None], 
       Line3DBox[{487, 689, 721, 1352, 473, 675, 1340, 458, 660, 1330, 443, 
        645, 1322, 428, 630, 1316, 413, 615, 1312, 398, 601, 710, 383, 1368, 
        588, 706, 1303, 369, 574, 1292, 354, 559, 1281, 339, 544, 1273, 324, 
        529, 1267, 309, 514, 1263, 288, 1171, 500, 699, 727},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJztXWdQlVmTBnMAUcEAKqIYUBFwHHNoURHFMKKYc8Cso6OAYA6gYgAUFEFR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     "],
    VertexNormals->CompressedData["
1:eJx1fHdYVEnzNYoKqBhQMeecUIyAaCmIcc2CGUEUFRPm7Bow56yIIipgBiPm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     "]], {}},
  Axes->True,
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotInteractivity:>True,
  PlotRange->{{-1, 1}, {-1, 1}, {0., 1.9999994285714693`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967199866189596*^9, {3.967199934841591*^9, 3.967199959720953*^9}, 
   3.9672000018035164`*^9, 3.9672009859630146`*^9, 3.967201167689125*^9, 
   3.967275904401135*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"d9aa3a37-d77b-403f-9c94-cb85ff192301"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"color=\"", "\"teal\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "12"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"box\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"mapacolor=\"", "\"jet\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.6753284173346757`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.18548858328351378`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"puntossuperimpli=\"", "10312"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"Origen\"", ",", 
             RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"pink\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\Large\""}], "}"}]}], 
               "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"M\[AAcute]ximo local\"", ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"lime\""}], "}"}], "}"}]}], 
           "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Punto $A$\"", ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"-", "1"}], ",", 
                 RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"north east\""}], "}"}], ",", 
                 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "30.062327375158482`"}], 
                   "}"}]}], "}"}]}], "}"}]}], "}"}]},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967199866189596*^9, {3.967199934841591*^9, 3.967199959720953*^9}, 
   3.9672000018035164`*^9, 3.9672009859630146`*^9, 3.967201167689125*^9, 
   3.9672759044061117`*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"0fd87574-051d-4fec-99c0-462b77d4e842"],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafica3D3/\
grafica3D3.tex\"\>"], "Output",
 CellChangeTimes->{
  3.967199866189596*^9, {3.967199934841591*^9, 3.967199959720953*^9}, 
   3.9672000018035164`*^9, 3.9672009859630146`*^9, 3.967201167689125*^9, 
   3.967275904442643*^9},
 CellLabel->"Out[89]=",ExpressionUUID->"f14c6d13-a7b1-4aff-92f3-64134bc290ae"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9671999600634575`*^9, 3.9672000021407337`*^9, 
  3.967200986323759*^9, 3.96720116803401*^9, 3.9672759044435453`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[86]:=",ExpressionUUID->"27b35af3-f368-4878-af6e-c7de709bb719"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9671999600634575`*^9, 3.9672000021407337`*^9, 
  3.967200986323759*^9, 3.96720116803401*^9, 3.9672759044439783`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[86]:=",ExpressionUUID->"72def960-0e70-4ec4-b7e6-a1bbb6b7c403"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9671999600634575`*^9, 3.9672000021407337`*^9, 
  3.967200986323759*^9, 3.96720116803401*^9, 3.967275904444501*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[86]:=",ExpressionUUID->"793a8bbd-e90d-49a4-b35a-e4cd2c41caa9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9671999600634575`*^9, 3.9672000021407337`*^9, 
  3.967200986323759*^9, 3.96720116803401*^9, 3.967275904444832*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[86]:=",ExpressionUUID->"117b5bfc-9ffe-4dd0-bbe1-2cac8eaf8212"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9671999600634575`*^9, 3.9672000021407337`*^9, 
  3.967200986323759*^9, 3.96720116803401*^9, 3.967275904445162*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[86]:=",ExpressionUUID->"f86d636d-c322-402a-a685-de881941bc73"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9671999600634575`*^9, 3.9672000021407337`*^9, 
  3.967200986323759*^9, 3.96720116803401*^9, 3.967275904500454*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[86]:=",ExpressionUUID->"645b9621-0d8d-42eb-8a30-5f824d044d26"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9671999600634575`*^9, 3.9672000021407337`*^9, 
  3.967200986323759*^9, 3.96720116803401*^9, 3.967275905506925*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[86]:=",ExpressionUUID->"629d6748-8995-4ea9-8490-7caf5cd810b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D3/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D3/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9671999600634575`*^9, 3.9672000021407337`*^9, 
  3.967200986323759*^9, 3.96720116803401*^9, 3.967275905510795*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[86]:=",ExpressionUUID->"178df092-fb1d-490b-86ab-8a1b99745392"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafica3D3\"\>"}],
  SequenceForm["Archivo: ", "grafica3D3"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9671999600634575`*^9, 3.9672000021407337`*^9, 
  3.967200986323759*^9, 3.96720116803401*^9, 3.967275905512566*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[86]:=",ExpressionUUID->"06fed1b3-af3e-42af-b6a4-94b165b1ed0a"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9671999600634575`*^9, 3.9672000021407337`*^9, 
  3.967200986323759*^9, 3.96720116803401*^9, 3.96727590635754*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[86]:=",ExpressionUUID->"2e433018-896b-4cf7-a54b-829937f7f411"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D3/grafica3D3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D3/grafica3D3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9671999600634575`*^9, 3.9672000021407337`*^9, 
  3.967200986323759*^9, 3.96720116803401*^9, 3.9672759063586493`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[86]:=",ExpressionUUID->"5d8dd1ab-d7d2-4408-bf0f-02571feb22dd"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafica3D3/\
grafica3D3.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967199866189596*^9, {3.967199934841591*^9, 3.967199959720953*^9}, 
   3.9672000018035164`*^9, 3.9672009859630146`*^9, 3.967201167689125*^9, 
   3.9672759063712378`*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"247db2f5-08f7-4f19-9a87-7c99c56c24b6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4", "Subsection",
 CellChangeTimes->{{3.967118818547166*^9, 3.967118843849774*^9}, 
   3.967122106294924*^9},ExpressionUUID->"6b3455e7-c63f-454b-bd37-\
4e844b32fc2f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "*", 
     RowBox[{"Cos", "[", "y", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"Opacity", "[", "0.7", "]"}]}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"ColorData", "[", "\"\<Gradients\>\"", "]"}], "]"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<color=\>\"", ",", 
      RowBox[{"color", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
          ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
          ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"",
           ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"",
           ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
          ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<white\>\"", 
          ",", "\"\<yellow\>\"", ",", "\"\<blue!50!red\>\"", 
          ",", "\"\<green!70!black\>\"", ",", "\"\<red!20!blue!80!green\>\"", 
          ",", "\"\<yellow!75!red\>\""}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"10", ",", "60"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<mapacolor=\>\"", ",", 
      RowBox[{"mapacolor", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<viridis\>\"", ",", "\"\<cool\>\"", ",", "\"\<hot\>\"", 
          ",", "\"\<jet\>\"", ",", "\"\<hsv\>\"", ",", "\"\<spring\>\"", 
          ",", "\"\<summer\>\"", ",", "\"\<autumn\>\"", ",", "\"\<winter\>\"",
           ",", "\"\<gray\>\"", ",", "\"\<blackwhite\>\""}], "}"}], "]"}]}]}],
      "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.2", ",", "1"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<puntossuperimpli=\>\"", ",", 
      RowBox[{"puntossuperimpli", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"8000", ",", "13000"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<$f(x,y)=sen(x)cos(y)$\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<color\>\"", ",", 
              RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
         "}"}], "}"}]}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "*", 
       RowBox[{"Cos", "[", "y", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "}"}], 
    ",", "\"\<grafica3D4.tex\>\"", ",", "grid", ",", "color", ",", 
    "resolucion", ",", "estiloejes", ",", "mapacolor", ",", "opacidad", ",", 
    "extensionejes", ",", "puntossuperimpli", ",", "texto"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967119075407069*^9, 3.967119130007597*^9}, 
   3.9671221101664543`*^9, {3.967192713731291*^9, 3.9671927143006344`*^9}, {
   3.9671938801512947`*^9, 3.96719388060721*^9}, {3.9671953506520596`*^9, 
   3.967195351275154*^9}, {3.967195492027487*^9, 3.9671954977644653`*^9}, {
   3.967195968830553*^9, 3.9671959698377457`*^9}, 3.9671988127787704`*^9, 
   3.967200131602562*^9, {3.9672012212207146`*^9, 3.96720132770529*^9}, {
   3.967201357984089*^9, 3.9672013678030205`*^9}, {3.967201432607956*^9, 
   3.967201445386923*^9}, {3.967275968147891*^9, 3.9672759863184633`*^9}, 
   3.967276121703878*^9},ExpressionUUID->"c20cfc46-e140-4c79-a38d-\
04e8b6e3b43f"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1XXmcjtUXn7GvodSPZN93UaHG3KfNli37WoTs2SJSSPZsWbJnC4lKJSY0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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.7], EdgeForm[None], 
       Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJw1m3ccV9P/xz93nitRSEVR9qgkkcqorKIie4ZSGUVShJRK1teKrKxI9h7R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            "]], Polygon3DBox[CompressedData["
1:eJw1nAf8V+P7xs85zxlfRBGSRDu7IVEqLTSkITNaKokyykhDS4WyChll7xlC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            "]], Polygon3DBox[CompressedData["
1:eJwt13m8zmUax/FnznOe55hmaipaUGjSnjAtKmEKqUhlrFk7dopIhA6Rg3Ci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            "]], 
           Polygon3DBox[{{1578, 968, 671, 672, 969, 1579}, {1622, 1016, 755, 
            756, 1017, 1623}}]},
          Annotation[#, "Charting`Private`Tag$49295#1"]& ]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0k1LlFEYh/F7HMdxfEvEFm4KaxEoCoEgikqTgVJCYZlZi0AJcSBFpNSd
row+QK0CEWrbJpeCoAS1q3xLM9Mv4LZlv0Mw91zX/z4vzznPTPP4zPB0JiLe
qYdlEcmH8SppyEXUy014GW/qX+Ht/BZv5b18KB8xIA/xfr0naQ8s4ThOqEW+
gK/wtrnL/G1ay1/zD/yefe7K63xNbxv/VkR8c5ZH+j/kB9iostmIHbkcd3HH
nBzf43u8gu/zzfKIA/mA5/V+YiUeYgGr1BGvxl94ZG4NP+bHvJb/5p/tcyKf
8Dq9P/hF71RvzHlO5RG8qDac/bv8EbfSvfRW+Sc+4I435PfpHfI+/oYvGV/B
eXypFvhTnErr8TEOmlvkd3jR2h65h/fxbt7Gm41fwknvrcvZRvUvyPfxXH6B
dfIc1mKn3iyvSfdynw65Or0Pfp1X8efGC1jCKVWZ9kePjWfoUdFm7gTPpd/E
2hYZIuPrGs+m+xj3ia96Z5n//7d/qvpACg==
        "],
        VertexColors->None]}, 
      {GrayLevel[0.2], 
       Line3DBox[{1298, 1626, 783, 1297, 1627, 1789, 2144, 1470, 1788, 1628, 
        1791, 2145, 1471, 1790, 1630, 1793, 2146, 1472, 1792, 1928, 1975, 
        1473, 1299, 1976, 1474, 1300, 1977, 1475, 1301, 1978, 1876, 2018, 
        1302, 1633, 1795, 2147, 1476, 1794, 1634, 1797, 2148, 1477, 1796, 
        1636, 1799, 2149, 1478, 1798, 1929, 1979, 1479, 1303, 1980, 1480, 
        1304, 1930, 1981, 1481, 1639},
        VertexColors->None], 
       Line3DBox[{1305, 1538, 1641, 1877, 2073, 1640, 1629, 1643, 796, 1642, 
        1631, 1800, 2150, 1482, 1644, 1632, 1982, 1483, 1306, 1983, 1484, 
        1307, 1984, 1485, 1308, 2074, 1539, 1486, 1309, 2076, 1540, 1647, 
        1878, 2075, 1646, 1635, 1649, 802, 1648, 1637, 1801, 2151, 1487, 1650,
         1638, 1985, 1488, 1310, 1986, 1489, 1311, 1987, 1490, 1312, 2077, 
        1541, 1491, 1313},
        VertexColors->None], 
       Line3DBox[{1314, 1866, 1542, 1653, 1879, 2078, 1652, 1543, 1655, 1880, 
        2079, 1654, 1645, 809, 1315, 1988, 1492, 1316, 1989, 1493, 1317, 2080,
         1544, 1494, 1318, 2081, 1545, 1657, 1836, 1837, 1656, 2138, 1848, 
        1546, 1659, 1881, 2082, 1658, 1547, 1661, 1882, 2083, 1660, 1651, 
        1883, 2137, 1319, 1990, 1495, 1320, 1991, 1496, 1321, 2084, 1548, 
        1497, 1322, 2085, 1549, 1662, 1855, 1856, 1854},
        VertexColors->None], 
       Line3DBox[{1323, 1867, 1550, 1664, 1838, 2086, 1966, 1663, 1551, 1884, 
        2087, 1324, 1885, 2019, 1325, 820, 1326, 1992, 1498, 1327, 2088, 1552,
         1667, 1499, 1666, 1970, 2174, 1553, 1670, 1839, 1840, 1669, 1971, 
        2175, 1554, 1673, 1841, 2089, 1967, 1672, 1555, 1886, 2090, 1328, 
        1887, 2020, 1329, 1888, 2021, 1330, 1993, 1500, 1331, 2091, 1556, 
        1676, 1501, 1675, 1972, 2176, 1557, 1678, 1858, 1859, 1857},
        VertexColors->None], 
       Line3DBox[{1345, 1869, 1573, 1679, 1572, 2099, 1344, 1571, 1677, 1570, 
        2098, 1343, 1684, 2026, 1932, 1342, 2025, 1892, 1341, 2024, 1891, 
        1340, 2097, 1569, 1568, 1339, 2096, 1567, 1674, 1566, 1850, 2177, 
        1338, 1849, 1565, 1671, 1564, 2095, 1337, 1563, 1668, 1562, 2094, 
        1336, 1680, 1071, 1335, 2023, 1890, 1334, 2022, 1889, 1333, 2093, 
        1561, 1560, 1332, 2092, 1559, 1665, 1558, 1874, 1868},
        VertexColors->None], 
       Line3DBox[{1347, 1574, 1575, 2100, 1346, 1893, 2027, 1348, 1894, 2028, 
        1349, 1689, 2029, 1934, 1350, 1931, 2152, 1802, 1681, 1351, 1077, 
        1803, 1682, 1352, 2101, 1576, 1683, 1577, 1353, 2103, 1578, 1579, 
        2102, 1354, 1895, 2030, 1355, 1896, 2031, 1356, 1693, 2032, 1938, 
        1357, 1933, 2153, 1804, 1685, 1358, 2139, 1686, 1805, 1687, 1359, 
        2104, 1580, 1688, 1581, 1360},
        VertexColors->None], 
       Line3DBox[{1362, 1897, 2033, 1361, 1898, 2034, 1363, 1697, 2035, 1942, 
        1364, 1690, 1806, 2036, 1935, 1365, 1936, 2154, 1807, 1691, 1366, 
        1937, 2155, 1808, 1692, 1367, 847, 1368, 1994, 1899, 2037, 1369, 1900,
         2038, 1370, 1703, 2039, 1947, 1371, 1694, 1809, 2040, 1939, 1372, 
        1940, 2156, 1810, 1695, 1373, 1941, 2157, 1811, 1696, 1374, 1901, 
        2041, 1375},
        VertexColors->None], 
       Line3DBox[{1379, 1995, 1502, 1377, 1710, 1818, 2160, 1503, 1711, 1699, 
        1819, 2161, 1504, 1713, 1701, 1820, 2162, 1505, 1715, 1946, 1996, 
        1506, 1384, 1997, 1507, 1386, 1998, 1508, 1388, 1999, 861, 1390, 1718,
         1821, 2163, 1509, 1719, 1705, 1822, 2164, 1510, 1721, 1707, 1823, 
        2165, 1511, 1723, 1951, 2000, 1512, 1395, 2001, 1513, 1397, 2002, 
        1514, 1399},
        VertexColors->None], 
       Line3DBox[{1398, 2053, 1906, 1396, 2052, 1905, 1394, 1708, 1817, 2159, 
        1950, 1393, 1949, 2051, 1816, 1706, 1392, 1948, 2050, 1815, 1704, 
        1391, 1953, 2049, 1717, 1389, 2048, 860, 1387, 2047, 1904, 1385, 2046,
         1903, 1383, 1702, 1814, 2158, 1945, 1382, 1944, 2045, 1813, 1700, 
        1381, 1943, 2044, 1812, 1698, 1380, 1952, 2043, 1709, 1376, 2042, 
        1902, 1378},
        VertexColors->None], 
       Line3DBox[{1400, 1582, 1726, 1907, 2105, 1725, 1712, 1728, 2140, 1515, 
        1727, 1714, 1824, 2166, 1516, 1729, 1716, 2003, 1517, 1401, 2004, 
        1518, 1402, 2005, 1519, 1403, 2106, 1583, 1520, 1404, 2108, 1584, 
        1732, 1908, 2107, 1731, 1720, 1734, 874, 1733, 1722, 1825, 2167, 1521,
         1735, 1724, 2006, 1522, 1405, 2007, 1523, 1406, 2008, 1524, 1407, 
        2109, 1585, 1525, 1408},
        VertexColors->None], 
       Line3DBox[{1409, 1870, 1586, 1738, 1909, 2110, 1737, 1587, 1740, 1910, 
        2111, 1739, 1730, 2009, 1526, 1410, 2010, 1527, 1411, 2011, 1528, 
        1412, 2112, 1588, 1529, 1413, 2113, 1589, 1742, 1842, 1843, 1741, 
        2141, 1851, 1590, 1744, 1911, 2114, 1743, 1591, 1746, 1912, 2115, 
        1745, 1736, 886, 1414, 2012, 1530, 1415, 2013, 1531, 1416, 2116, 1592,
         1532, 1417, 2117, 1593, 1747, 1861, 1862, 1860},
        VertexColors->None], 
       Line3DBox[{1418, 1871, 1594, 1749, 1844, 2118, 1968, 1748, 1595, 1913, 
        2119, 1419, 1914, 2054, 1420, 2014, 1533, 1421, 2015, 1534, 1422, 
        2120, 1596, 1752, 1535, 1751, 1973, 2178, 1597, 1755, 1845, 1846, 
        1754, 1290, 1598, 1758, 1847, 2121, 1969, 1757, 1599, 1915, 2122, 
        1423, 1916, 2055, 1424, 897, 1425, 2016, 1536, 1426, 2123, 1600, 1761,
         1537, 1760, 1974, 2179, 1601, 1763, 1864, 1865, 1863},
        VertexColors->None], 
       Line3DBox[{1440, 1873, 1617, 1764, 1616, 2131, 1439, 1615, 1762, 1614, 
        2130, 1438, 1770, 1181, 1437, 2059, 1920, 1436, 2058, 1919, 1435, 
        2129, 1613, 1612, 1434, 2128, 1611, 1759, 1610, 1853, 2180, 1433, 
        1852, 1609, 1756, 1608, 2127, 1432, 1607, 1753, 1606, 2126, 1431, 
        1766, 1765, 2142, 1430, 2057, 1918, 1429, 2056, 1917, 1428, 2125, 
        1605, 1604, 1427, 2124, 1603, 1750, 1602, 1875, 1872},
        VertexColors->None], 
       Line3DBox[{1442, 1618, 1619, 2132, 1441, 1921, 2060, 1443, 1922, 2061, 
        1444, 1774, 2062, 1956, 1445, 1954, 2168, 1826, 1767, 1446, 1177, 
        1827, 1768, 1447, 2133, 1620, 1769, 1621, 1448, 2135, 1622, 1623, 
        2134, 1449, 1923, 2063, 1450, 1924, 2064, 1451, 1778, 2065, 1960, 
        1452, 1955, 2169, 1828, 1771, 1453, 1187, 1829, 1772, 1454, 2136, 
        1624, 1773, 1625, 1455},
        VertexColors->None], 
       Line3DBox[{1469, 1787, 1223, 1468, 1781, 1835, 2173, 1963, 1467, 1780, 
        1834, 2172, 1962, 1466, 1961, 2072, 1833, 1779, 1465, 1965, 2071, 
        1786, 1464, 2070, 1927, 1463, 2069, 1926, 2017, 1462, 919, 1461, 1777,
         1832, 2171, 1959, 1460, 1776, 1831, 2170, 1958, 1459, 1957, 2068, 
        1830, 1775, 1458, 1964, 2067, 1785, 1457, 2066, 1925, 1456, 2143, 
        1783, 1782, 1784},
        VertexColors->None]}, 
      {GrayLevel[0.2], 
       Line3DBox[{607, 1022, 1227, 784, 2144, 608, 1024, 1045, 796, 632, 934, 
        1054, 2079, 808, 646, 946, 2087, 818, 658, 953, 2093, 828, 668, 2027, 
        836, 677, 2034, 844, 688, 2043, 1128, 1129, 855, 2160, 701, 1130, 
        1145, 868, 2140, 716, 982, 1154, 2111, 880, 730, 994, 2119, 890, 742, 
        1001, 2125, 900, 752, 2060, 908, 761, 2066, 916, 772},
        VertexColors->None], 
       Line3DBox[{611, 1029, 1230, 1030, 1975, 612, 799, 1983, 635, 811, 1989,
         649, 821, 1992, 661, 1071, 1072, 1235, 2152, 1074, 1092, 1075, 1239, 
        2154, 1095, 1114, 1096, 1243, 2158, 1117, 1134, 1118, 1996, 704, 871, 
        2004, 719, 883, 2011, 733, 893, 2015, 745, 1171, 2142, 1172, 1245, 
        2168, 1174, 1192, 1175, 1249, 2170, 1195, 1214, 1196, 1216},
        VertexColors->None], 
       Line3DBox[{613, 787, 1976, 614, 800, 1984, 636, 935, 2080, 936, 650, 
        947, 2088, 948, 1063, 954, 2094, 1073, 955, 1236, 1077, 1094, 1078, 
        1240, 2155, 1098, 1116, 1099, 691, 2046, 858, 1997, 705, 872, 2005, 
        720, 983, 2112, 984, 734, 995, 2120, 996, 1163, 1002, 2126, 1173, 
        1003, 1246, 1177, 1194, 1178, 1250, 2171, 1198, 1215, 1199, 775},
        VertexColors->None], 
       Line3DBox[{615, 788, 1977, 616, 926, 2074, 927, 637, 937, 2081, 938, 
        1056, 1261, 1262, 1062, 2174, 1264, 1263, 1065, 956, 2095, 1076, 957, 
        1080, 966, 2101, 1097, 967, 680, 847, 692, 2047, 859, 1998, 706, 974, 
        2106, 975, 721, 985, 2113, 986, 1156, 1281, 1282, 1162, 2178, 1284, 
        1283, 1165, 1004, 2127, 1176, 1005, 1180, 1014, 2133, 1197, 1015, 764,
         919, 776},
        VertexColors->None], 
       Line3DBox[{617, 789, 1978, 619, 928, 2076, 930, 1049, 939, 1055, 1258, 
        2138, 1257, 1058, 1265, 1266, 1064, 2175, 1270, 1269, 1067, 1275, 
        2177, 1276, 1079, 959, 671, 968, 2103, 970, 681, 848, 1994, 693, 860, 
        1999, 707, 976, 2108, 978, 1149, 987, 1155, 1278, 2141, 1277, 1158, 
        1285, 1286, 1164, 1290, 1289, 1167, 1295, 2180, 1296, 1179, 1007, 755,
         1016, 2135, 1018, 765, 920, 2017, 777},
        VertexColors->None], 
       Line3DBox[{621, 1032, 1231, 791, 2147, 622, 1034, 1050, 802, 639, 941, 
        1059, 2083, 813, 652, 949, 2090, 823, 663, 960, 2097, 832, 673, 2030, 
        840, 683, 2038, 850, 695, 2049, 1136, 1137, 862, 2163, 709, 1138, 
        1150, 874, 723, 989, 1159, 2115, 885, 736, 997, 2122, 895, 747, 1008, 
        2129, 904, 757, 2063, 912, 767, 2070, 922, 779},
        VertexColors->None], 
       Line3DBox[{625, 1039, 1234, 1040, 1979, 626, 805, 1986, 642, 816, 1991,
         655, 826, 1993, 666, 2026, 1081, 1082, 1237, 2153, 1084, 1102, 1085, 
        1241, 2156, 1105, 1123, 1106, 1244, 2159, 1126, 1142, 1127, 2000, 712,
         877, 2007, 726, 888, 2013, 739, 898, 2016, 750, 1181, 1182, 1247, 
        2169, 1184, 1202, 1185, 1251, 2172, 1205, 1220, 1206, 1222},
        VertexColors->None], 
       Line3DBox[{627, 794, 1980, 628, 806, 1987, 643, 942, 2084, 943, 656, 
        950, 2091, 951, 1069, 961, 2098, 1083, 962, 1238, 1087, 2139, 1104, 
        1088, 1242, 2157, 1108, 1125, 1109, 698, 2052, 865, 2001, 713, 878, 
        2008, 727, 990, 2116, 991, 740, 998, 2123, 999, 1169, 1009, 2130, 
        1183, 1010, 1248, 1187, 1204, 1188, 1252, 2173, 1208, 1221, 1209, 782},
        VertexColors->None], 
       Line3DBox[{629, 1042, 1043, 1981, 630, 931, 2077, 932, 644, 944, 2085, 
        945, 1060, 1271, 1272, 1068, 2176, 1274, 1273, 1070, 963, 2099, 1086, 
        964, 1089, 971, 2104, 1107, 972, 686, 2041, 853, 699, 2053, 866, 2002,
         714, 979, 2109, 980, 728, 992, 2117, 993, 1160, 1291, 1292, 1168, 
        2179, 1294, 1293, 1170, 1011, 2131, 1186, 1012, 1189, 1019, 2136, 
        1207, 1020, 770, 1223, 1224, 1225},
        VertexColors->None], 
       Line3DBox[{771, 915, 2143, 1210, 760, 907, 2132, 1013, 751, 899, 2124, 
        1000, 741, 889, 1255, 2118, 1161, 1280, 1279, 729, 879, 2110, 1153, 
        981, 715, 867, 2105, 1144, 973, 700, 1995, 854, 2042, 687, 843, 2033, 
        676, 835, 2100, 965, 667, 827, 2092, 952, 657, 817, 1253, 2086, 1061, 
        1260, 1259, 645, 807, 2078, 1053, 933, 631, 795, 2073, 1044, 925, 606,
         783, 1021, 1226},
        VertexColors->None], 
       Line3DBox[{773, 917, 1212, 1211, 2067, 762, 909, 2061, 753, 901, 2056, 
        743, 891, 2054, 731, 2009, 881, 1147, 717, 2166, 869, 1146, 1132, 702,
         2161, 856, 1131, 1112, 2044, 689, 845, 1111, 1110, 2035, 678, 837, 
        2028, 669, 829, 2022, 659, 819, 2019, 647, 809, 1047, 633, 2150, 797, 
        1046, 1027, 609, 2145, 785, 1228, 1023, 1025},
        VertexColors->None], 
       Line3DBox[{774, 918, 1213, 1193, 2068, 763, 910, 1191, 1190, 2062, 754,
         902, 2057, 744, 2014, 892, 732, 2010, 882, 718, 2003, 870, 1135, 703,
         2162, 857, 1133, 1115, 2045, 690, 846, 1113, 1093, 2036, 679, 838, 
        1091, 1090, 2029, 670, 830, 2023, 660, 820, 648, 1988, 810, 634, 1982,
         798, 1031, 610, 2146, 786, 1229, 1026, 1028},
        VertexColors->None], 
       Line3DBox[{778, 921, 2069, 766, 911, 2134, 1017, 756, 903, 2128, 1006, 
        746, 894, 1256, 2121, 1166, 1288, 1287, 735, 884, 2114, 1157, 988, 
        722, 873, 2107, 1148, 977, 708, 861, 2048, 694, 849, 2037, 682, 839, 
        2102, 969, 672, 831, 2096, 958, 662, 822, 1254, 2089, 1066, 1268, 
        1267, 651, 812, 2082, 1057, 940, 638, 801, 2075, 1048, 929, 620, 790, 
        2018, 618},
        VertexColors->None], 
       Line3DBox[{780, 923, 1218, 1217, 2071, 768, 913, 2064, 758, 905, 2058, 
        748, 896, 2055, 737, 886, 1152, 724, 2167, 875, 1151, 1140, 710, 2164,
         863, 1139, 1121, 2050, 696, 851, 1120, 1119, 2039, 684, 841, 2031, 
        674, 833, 2024, 664, 824, 2020, 653, 814, 2137, 1052, 640, 2151, 803, 
        1051, 1037, 623, 2148, 792, 1232, 1033, 1035},
        VertexColors->None], 
       Line3DBox[{781, 924, 1219, 1203, 2072, 769, 914, 1201, 1200, 2065, 759,
         906, 2059, 749, 897, 738, 2012, 887, 725, 2006, 876, 1143, 711, 2165,
         864, 1141, 1124, 2051, 697, 852, 1122, 1103, 2040, 685, 842, 1101, 
        1100, 2032, 675, 834, 2025, 665, 825, 2021, 654, 1990, 815, 641, 1985,
         804, 1041, 624, 2149, 793, 1233, 1036, 1038},
        VertexColors->None]}, {}, {}}},
    VertexColors->CompressedData["
1:eJzsvXkw1m/7Pq4oaUGSpSwtQkhIWtClIqWikiWVopC9EBUtRIsKFUqWItqk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     "],
    VertexNormals->CompressedData["
1:eJytfXdcz9/3eLZkb5lZkVFGEdW1iiIUWSkje0dRRkYpM5WRkSijkJUZed1k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     "]], {}},
  Axes->True,
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  Lighting->"Neutral",
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotInteractivity:>True,
  PlotRange->
   NCache[{{-Pi, Pi}, {-Pi, Pi}, {-0.9999999999999748, 
     0.9999999999999748}}, {{-3.141592653589793, 
    3.141592653589793}, {-3.141592653589793, 
    3.141592653589793}, {-0.9999999999999748, 0.9999999999999748}}],
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.967201278191801*^9, 3.967201328566723*^9}, 
   3.967201373116045*^9, 3.96720144671694*^9, 3.9672014813402424`*^9, 
   3.967276018123468*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"2edc5fd4-5fa3-4489-9c21-4bba92831bde"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"color=\"", "\"olive\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "14"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"box\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"mapacolor=\"", "\"jet\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.20877474703413407`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.3301704447625347`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"puntossuperimpli=\"", "12495"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"$f(x,y)=sen(x)cos(y)$\"", ",", 
           RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"lime\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\small\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"west\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "133.59850804276874`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.967201278191801*^9, 3.967201328566723*^9}, 
   3.967201373116045*^9, 3.96720144671694*^9, 3.9672014813402424`*^9, 
   3.96727601812932*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"3c874327-05a0-4db6-b39d-cb6bf09be358"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672012789133472`*^9, 3.967201329010988*^9}, 
   3.967201373755207*^9, 3.967201447277508*^9, 3.967201481785986*^9, 
   3.967276018177019*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"4936b728-367e-4a96-ba41-75e8ab36dffb"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9672012789133472`*^9, 3.967201329010988*^9}, 
   3.967201373755207*^9, 3.967201447277508*^9, 3.967201481785986*^9, 
   3.9672760181779327`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"cee21156-5669-4961-825d-c0abaf8e898b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672012789133472`*^9, 3.967201329010988*^9}, 
   3.967201373755207*^9, 3.967201447277508*^9, 3.967201481785986*^9, 
   3.967276018178525*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"9a467011-f51e-4cd7-8788-301074c38f1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672012789133472`*^9, 3.967201329010988*^9}, 
   3.967201373755207*^9, 3.967201447277508*^9, 3.967201481785986*^9, 
   3.967276018178903*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"6d007289-8998-4e58-b7ba-668a17936bf7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672012789133472`*^9, 3.967201329010988*^9}, 
   3.967201373755207*^9, 3.967201447277508*^9, 3.967201481785986*^9, 
   3.967276018179302*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"b1a1e6e1-691f-41fe-9b16-60dcad6d6ae1"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9672012789133472`*^9, 3.967201329010988*^9}, 
   3.967201373755207*^9, 3.967201447277508*^9, 3.967201481785986*^9, 
   3.967276018236436*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"7521f1f9-d09c-47d6-8931-e22162b69a5b"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9672012789133472`*^9, 3.967201329010988*^9}, 
   3.967201373755207*^9, 3.967201447277508*^9, 3.967201481785986*^9, 
   3.967276019243334*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"3656a7f3-4f0e-404e-af79-12a1bb35a84a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D4/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D4/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672012789133472`*^9, 3.967201329010988*^9}, 
   3.967201373755207*^9, 3.967201447277508*^9, 3.967201481785986*^9, 
   3.967276019248619*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"4b78bf17-3db8-4480-bbb0-4f1321f01fa2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafica3D4\"\>"}],
  SequenceForm["Archivo: ", "grafica3D4"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672012789133472`*^9, 3.967201329010988*^9}, 
   3.967201373755207*^9, 3.967201447277508*^9, 3.967201481785986*^9, 
   3.967276019250628*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"a2623b94-d6fc-4636-a87c-2259b8068f1e"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9672012789133472`*^9, 3.967201329010988*^9}, 
   3.967201373755207*^9, 3.967201447277508*^9, 3.967201481785986*^9, 
   3.967276020180532*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"981060a6-f9d1-4266-8073-ae1f164df951"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D4/grafica3D4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D4/grafica3D4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672012789133472`*^9, 3.967201329010988*^9}, 
   3.967201373755207*^9, 3.967201447277508*^9, 3.967201481785986*^9, 
   3.967276020181469*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"7d46315b-7281-4e52-8f4a-e7fa2ccc5400"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafica3D4/\
grafica3D4.pdf\"\>"], "Output",
 CellChangeTimes->{{3.967201278191801*^9, 3.967201328566723*^9}, 
   3.967201373116045*^9, 3.96720144671694*^9, 3.9672014813402424`*^9, 
   3.967276020194174*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"d7da5d18-b609-4497-933a-d183ab8ad5a7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5", "Subsection",
 CellChangeTimes->{{3.967118818547166*^9, 3.9671188498965883`*^9}, 
   3.967122114164361*^9},ExpressionUUID->"4433656b-3ad4-4d05-990f-\
6b200e4d18a7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", "v", ",", 
      RowBox[{
       RowBox[{"Sin", "[", "u", "]"}], "*", 
       RowBox[{"Cos", "[", "v", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", 
      RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", 
      RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"Opacity", "[", "0.7", "]"}]}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"ColorData", "[", "\"\<Gradients\>\"", "]"}], "]"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<color=\>\"", ",", 
      RowBox[{"color", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
          ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
          ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"",
           ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"",
           ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
          ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<white\>\"", 
          ",", "\"\<yellow\>\"", ",", "\"\<blue!50!red\>\"", 
          ",", "\"\<green!70!black\>\"", ",", "\"\<red!20!blue!80!green\>\"", 
          ",", "\"\<yellow!75!red\>\""}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"10", ",", "60"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<mapacolor=\>\"", ",", 
      RowBox[{"mapacolor", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<viridis\>\"", ",", "\"\<cool\>\"", ",", "\"\<hot\>\"", 
          ",", "\"\<jet\>\"", ",", "\"\<hsv\>\"", ",", "\"\<spring\>\"", 
          ",", "\"\<summer\>\"", ",", "\"\<autumn\>\"", ",", "\"\<winter\>\"",
           ",", "\"\<gray\>\"", ",", "\"\<blackwhite\>\""}], "}"}], "]"}]}]}],
      "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.2", ",", "1"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<puntossuperimpli=\>\"", ",", 
      RowBox[{"puntossuperimpli", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"8000", ",", "13000"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<$f(u,v)=\\\\sin u \\\\cdot \\\\cos v$\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<color\>\"", ",", 
              RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
         "}"}], "}"}]}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u", ",", "v", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "u", "]"}], "*", 
         RowBox[{"Cos", "[", "v", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "}"}], 
    ",", "\"\<grafica3D5.tex\>\"", ",", "grid", ",", "color", ",", 
    "resolucion", ",", "estiloejes", ",", "mapacolor", ",", "opacidad", ",", 
    "extensionejes", ",", "puntossuperimpli", ",", "texto"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9671191417212048`*^9, 3.967119150933209*^9}, 
   3.9671221185516777`*^9, {3.9671927192743397`*^9, 3.9671927196531353`*^9}, {
   3.9671938856041317`*^9, 3.96719388605867*^9}, {3.967195354152651*^9, 
   3.9671953560640945`*^9}, {3.9671954767222843`*^9, 3.967195482489933*^9}, 
   3.967195979773306*^9, {3.967196538345106*^9, 3.9671965409457664`*^9}, 
   3.9671988191783695`*^9, 3.9672001428804626`*^9, {3.9672015345328407`*^9, 
   3.9672015937868595`*^9}, {3.967201667106695*^9, 3.9672016797189903`*^9}, {
   3.967276146829946*^9, 3.96727616789021*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"8502bade-729b-4f50-930f-863a4015498a"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1XXm8TlX3v2ZCNHvTICKFDBXF7e7T8FIqQ4NSKsqUUor8IiSRyPwSUjI1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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[2], Opacity[
       0.7], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJwtm3fgV9Mbx+89997P/SgSkpS0jKYoEkXRsIs0NKVBSWU1pKmMVHZkz6aQ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            "]], Polygon3DBox[CompressedData["
1:eJw1nAn8F9P7xWc+d5ZPkh+JNqloE4rspY1WQrJLC2WLFtlaqbRYUpKyZElZ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            "]], Polygon3DBox[CompressedData["
1:eJwt13mg1mMaxvG3c07nxQxjqVChRpQ9Q4NCQ2VpQ0NJC9oLpV2l0qZd0iIq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            "]], 
           Polygon3DBox[{{1623, 1622, 1016, 755, 756, 1017}, {1579, 1578, 968,
             671, 672, 969}}]},
          Annotation[#, "Charting`Private`Tag$50876#1"]& ]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {{}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{607, 1022, 1227, 784, 2144, 608, 1024, 1045, 796, 632, 934, 
        1054, 2079, 808, 646, 946, 2087, 818, 658, 953, 2093, 828, 668, 2027, 
        836, 677, 2034, 844, 688, 2043, 1128, 1129, 855, 2160, 701, 1130, 
        1145, 868, 2140, 716, 982, 1154, 2111, 880, 730, 994, 2119, 890, 742, 
        1001, 2125, 900, 752, 2060, 908, 761, 2066, 916, 772},
        VertexColors->None], 
       Line3DBox[{611, 1029, 1230, 1030, 1975, 612, 799, 1983, 635, 811, 1989,
         649, 821, 1992, 661, 1071, 1072, 1235, 2152, 1074, 1092, 1075, 1239, 
        2154, 1095, 1114, 1096, 1243, 2158, 1117, 1134, 1118, 1996, 704, 871, 
        2004, 719, 883, 2011, 733, 893, 2015, 745, 1171, 2142, 1172, 1245, 
        2168, 1174, 1192, 1175, 1249, 2170, 1195, 1214, 1196, 1216},
        VertexColors->None], 
       Line3DBox[{613, 787, 1976, 614, 800, 1984, 636, 935, 2080, 936, 650, 
        947, 2088, 948, 1063, 954, 2094, 1073, 955, 1236, 1077, 1094, 1078, 
        1240, 2155, 1098, 1116, 1099, 691, 2046, 858, 1997, 705, 872, 2005, 
        720, 983, 2112, 984, 734, 995, 2120, 996, 1163, 1002, 2126, 1173, 
        1003, 1246, 1177, 1194, 1178, 1250, 2171, 1198, 1215, 1199, 775},
        VertexColors->None], 
       Line3DBox[{615, 788, 1977, 616, 926, 2074, 927, 637, 937, 2081, 938, 
        1056, 1261, 1262, 1062, 2174, 1264, 1263, 1065, 956, 2095, 1076, 957, 
        1080, 966, 2101, 1097, 967, 680, 847, 692, 2047, 859, 1998, 706, 974, 
        2106, 975, 721, 985, 2113, 986, 1156, 1281, 1282, 1162, 2178, 1284, 
        1283, 1165, 1004, 2127, 1176, 1005, 1180, 1014, 2133, 1197, 1015, 764,
         919, 776},
        VertexColors->None], 
       Line3DBox[{617, 789, 1978, 619, 928, 2076, 930, 1049, 939, 1055, 1258, 
        2138, 1257, 1058, 1265, 1266, 1064, 2175, 1270, 1269, 1067, 1275, 
        2177, 1276, 1079, 959, 671, 968, 2103, 970, 681, 848, 1994, 693, 860, 
        1999, 707, 976, 2108, 978, 1149, 987, 1155, 1278, 2141, 1277, 1158, 
        1285, 1286, 1164, 1290, 1289, 1167, 1295, 2180, 1296, 1179, 1007, 755,
         1016, 2135, 1018, 765, 920, 2017, 777},
        VertexColors->None], 
       Line3DBox[{621, 1032, 1231, 791, 2147, 622, 1034, 1050, 802, 639, 941, 
        1059, 2083, 813, 652, 949, 2090, 823, 663, 960, 2097, 832, 673, 2030, 
        840, 683, 2038, 850, 695, 2049, 1136, 1137, 862, 2163, 709, 1138, 
        1150, 874, 723, 989, 1159, 2115, 885, 736, 997, 2122, 895, 747, 1008, 
        2129, 904, 757, 2063, 912, 767, 2070, 922, 779},
        VertexColors->None], 
       Line3DBox[{625, 1039, 1234, 1040, 1979, 626, 805, 1986, 642, 816, 1991,
         655, 826, 1993, 666, 2026, 1081, 1082, 1237, 2153, 1084, 1102, 1085, 
        1241, 2156, 1105, 1123, 1106, 1244, 2159, 1126, 1142, 1127, 2000, 712,
         877, 2007, 726, 888, 2013, 739, 898, 2016, 750, 1181, 1182, 1247, 
        2169, 1184, 1202, 1185, 1251, 2172, 1205, 1220, 1206, 1222},
        VertexColors->None], 
       Line3DBox[{627, 794, 1980, 628, 806, 1987, 643, 942, 2084, 943, 656, 
        950, 2091, 951, 1069, 961, 2098, 1083, 962, 1238, 1087, 2139, 1104, 
        1088, 1242, 2157, 1108, 1125, 1109, 698, 2052, 865, 2001, 713, 878, 
        2008, 727, 990, 2116, 991, 740, 998, 2123, 999, 1169, 1009, 2130, 
        1183, 1010, 1248, 1187, 1204, 1188, 1252, 2173, 1208, 1221, 1209, 782},
        VertexColors->None], 
       Line3DBox[{629, 1042, 1043, 1981, 630, 931, 2077, 932, 644, 944, 2085, 
        945, 1060, 1271, 1272, 1068, 2176, 1274, 1273, 1070, 963, 2099, 1086, 
        964, 1089, 971, 2104, 1107, 972, 686, 2041, 853, 699, 2053, 866, 2002,
         714, 979, 2109, 980, 728, 992, 2117, 993, 1160, 1291, 1292, 1168, 
        2179, 1294, 1293, 1170, 1011, 2131, 1186, 1012, 1189, 1019, 2136, 
        1207, 1020, 770, 1223, 1224, 1225},
        VertexColors->None], 
       Line3DBox[{771, 915, 2143, 1210, 760, 907, 2132, 1013, 751, 899, 2124, 
        1000, 741, 889, 1255, 2118, 1161, 1280, 1279, 729, 879, 2110, 1153, 
        981, 715, 867, 2105, 1144, 973, 700, 1995, 854, 2042, 687, 843, 2033, 
        676, 835, 2100, 965, 667, 827, 2092, 952, 657, 817, 1253, 2086, 1061, 
        1260, 1259, 645, 807, 2078, 1053, 933, 631, 795, 2073, 1044, 925, 606,
         783, 1021, 1226},
        VertexColors->None], 
       Line3DBox[{773, 917, 1212, 1211, 2067, 762, 909, 2061, 753, 901, 2056, 
        743, 891, 2054, 731, 2009, 881, 1147, 717, 2166, 869, 1146, 1132, 702,
         2161, 856, 1131, 1112, 2044, 689, 845, 1111, 1110, 2035, 678, 837, 
        2028, 669, 829, 2022, 659, 819, 2019, 647, 809, 1047, 633, 2150, 797, 
        1046, 1027, 609, 2145, 785, 1228, 1023, 1025},
        VertexColors->None], 
       Line3DBox[{774, 918, 1213, 1193, 2068, 763, 910, 1191, 1190, 2062, 754,
         902, 2057, 744, 2014, 892, 732, 2010, 882, 718, 2003, 870, 1135, 703,
         2162, 857, 1133, 1115, 2045, 690, 846, 1113, 1093, 2036, 679, 838, 
        1091, 1090, 2029, 670, 830, 2023, 660, 820, 648, 1988, 810, 634, 1982,
         798, 1031, 610, 2146, 786, 1229, 1026, 1028},
        VertexColors->None], 
       Line3DBox[{778, 921, 2069, 766, 911, 2134, 1017, 756, 903, 2128, 1006, 
        746, 894, 1256, 2121, 1166, 1288, 1287, 735, 884, 2114, 1157, 988, 
        722, 873, 2107, 1148, 977, 708, 861, 2048, 694, 849, 2037, 682, 839, 
        2102, 969, 672, 831, 2096, 958, 662, 822, 1254, 2089, 1066, 1268, 
        1267, 651, 812, 2082, 1057, 940, 638, 801, 2075, 1048, 929, 620, 790, 
        2018, 618},
        VertexColors->None], 
       Line3DBox[{780, 923, 1218, 1217, 2071, 768, 913, 2064, 758, 905, 2058, 
        748, 896, 2055, 737, 886, 1152, 724, 2167, 875, 1151, 1140, 710, 2164,
         863, 1139, 1121, 2050, 696, 851, 1120, 1119, 2039, 684, 841, 2031, 
        674, 833, 2024, 664, 824, 2020, 653, 814, 2137, 1052, 640, 2151, 803, 
        1051, 1037, 623, 2148, 792, 1232, 1033, 1035},
        VertexColors->None], 
       Line3DBox[{781, 924, 1219, 1203, 2072, 769, 914, 1201, 1200, 2065, 759,
         906, 2059, 749, 897, 738, 2012, 887, 725, 2006, 876, 1143, 711, 2165,
         864, 1141, 1124, 2051, 697, 852, 1122, 1103, 2040, 685, 842, 1101, 
        1100, 2032, 675, 834, 2025, 665, 825, 2021, 654, 1990, 815, 641, 1985,
         804, 1041, 624, 2149, 793, 1233, 1036, 1038},
        VertexColors->None]}, 
      {GrayLevel[0.2], 
       Line3DBox[{1298, 1626, 783, 1297, 1627, 1789, 2144, 1470, 1788, 1628, 
        1791, 2145, 1471, 1790, 1630, 1793, 2146, 1472, 1792, 1928, 1975, 
        1473, 1299, 1976, 1474, 1300, 1977, 1475, 1301, 1978, 1876, 2018, 
        1302, 1633, 1795, 2147, 1476, 1794, 1634, 1797, 2148, 1477, 1796, 
        1636, 1799, 2149, 1478, 1798, 1929, 1979, 1479, 1303, 1980, 1480, 
        1304, 1930, 1981, 1481, 1639},
        VertexColors->None], 
       Line3DBox[{1305, 1538, 1641, 1877, 2073, 1640, 1629, 1643, 796, 1642, 
        1631, 1800, 2150, 1482, 1644, 1632, 1982, 1483, 1306, 1983, 1484, 
        1307, 1984, 1485, 1308, 2074, 1539, 1486, 1309, 2076, 1540, 1647, 
        1878, 2075, 1646, 1635, 1649, 802, 1648, 1637, 1801, 2151, 1487, 1650,
         1638, 1985, 1488, 1310, 1986, 1489, 1311, 1987, 1490, 1312, 2077, 
        1541, 1491, 1313},
        VertexColors->None], 
       Line3DBox[{1314, 1866, 1542, 1653, 1879, 2078, 1652, 1543, 1655, 1880, 
        2079, 1654, 1645, 809, 1315, 1988, 1492, 1316, 1989, 1493, 1317, 2080,
         1544, 1494, 1318, 2081, 1545, 1657, 1836, 1837, 1656, 2138, 1848, 
        1546, 1659, 1881, 2082, 1658, 1547, 1661, 1882, 2083, 1660, 1651, 
        1883, 2137, 1319, 1990, 1495, 1320, 1991, 1496, 1321, 2084, 1548, 
        1497, 1322, 2085, 1549, 1662, 1855, 1856, 1854},
        VertexColors->None], 
       Line3DBox[{1323, 1867, 1550, 1664, 1838, 2086, 1966, 1663, 1551, 1884, 
        2087, 1324, 1885, 2019, 1325, 820, 1326, 1992, 1498, 1327, 2088, 1552,
         1667, 1499, 1666, 1970, 2174, 1553, 1670, 1839, 1840, 1669, 1971, 
        2175, 1554, 1673, 1841, 2089, 1967, 1672, 1555, 1886, 2090, 1328, 
        1887, 2020, 1329, 1888, 2021, 1330, 1993, 1500, 1331, 2091, 1556, 
        1676, 1501, 1675, 1972, 2176, 1557, 1678, 1858, 1859, 1857},
        VertexColors->None], 
       Line3DBox[{1345, 1869, 1573, 1679, 1572, 2099, 1344, 1571, 1677, 1570, 
        2098, 1343, 1684, 2026, 1932, 1342, 2025, 1892, 1341, 2024, 1891, 
        1340, 2097, 1569, 1568, 1339, 2096, 1567, 1674, 1566, 1850, 2177, 
        1338, 1849, 1565, 1671, 1564, 2095, 1337, 1563, 1668, 1562, 2094, 
        1336, 1680, 1071, 1335, 2023, 1890, 1334, 2022, 1889, 1333, 2093, 
        1561, 1560, 1332, 2092, 1559, 1665, 1558, 1874, 1868},
        VertexColors->None], 
       Line3DBox[{1347, 1574, 1575, 2100, 1346, 1893, 2027, 1348, 1894, 2028, 
        1349, 1689, 2029, 1934, 1350, 1931, 2152, 1802, 1681, 1351, 1077, 
        1803, 1682, 1352, 2101, 1576, 1683, 1577, 1353, 2103, 1578, 1579, 
        2102, 1354, 1895, 2030, 1355, 1896, 2031, 1356, 1693, 2032, 1938, 
        1357, 1933, 2153, 1804, 1685, 1358, 2139, 1686, 1805, 1687, 1359, 
        2104, 1580, 1688, 1581, 1360},
        VertexColors->None], 
       Line3DBox[{1362, 1897, 2033, 1361, 1898, 2034, 1363, 1697, 2035, 1942, 
        1364, 1690, 1806, 2036, 1935, 1365, 1936, 2154, 1807, 1691, 1366, 
        1937, 2155, 1808, 1692, 1367, 847, 1368, 1994, 1899, 2037, 1369, 1900,
         2038, 1370, 1703, 2039, 1947, 1371, 1694, 1809, 2040, 1939, 1372, 
        1940, 2156, 1810, 1695, 1373, 1941, 2157, 1811, 1696, 1374, 1901, 
        2041, 1375},
        VertexColors->None], 
       Line3DBox[{1379, 1995, 1502, 1377, 1710, 1818, 2160, 1503, 1711, 1699, 
        1819, 2161, 1504, 1713, 1701, 1820, 2162, 1505, 1715, 1946, 1996, 
        1506, 1384, 1997, 1507, 1386, 1998, 1508, 1388, 1999, 861, 1390, 1718,
         1821, 2163, 1509, 1719, 1705, 1822, 2164, 1510, 1721, 1707, 1823, 
        2165, 1511, 1723, 1951, 2000, 1512, 1395, 2001, 1513, 1397, 2002, 
        1514, 1399},
        VertexColors->None], 
       Line3DBox[{1398, 2053, 1906, 1396, 2052, 1905, 1394, 1708, 1817, 2159, 
        1950, 1393, 1949, 2051, 1816, 1706, 1392, 1948, 2050, 1815, 1704, 
        1391, 1953, 2049, 1717, 1389, 2048, 860, 1387, 2047, 1904, 1385, 2046,
         1903, 1383, 1702, 1814, 2158, 1945, 1382, 1944, 2045, 1813, 1700, 
        1381, 1943, 2044, 1812, 1698, 1380, 1952, 2043, 1709, 1376, 2042, 
        1902, 1378},
        VertexColors->None], 
       Line3DBox[{1400, 1582, 1726, 1907, 2105, 1725, 1712, 1728, 2140, 1515, 
        1727, 1714, 1824, 2166, 1516, 1729, 1716, 2003, 1517, 1401, 2004, 
        1518, 1402, 2005, 1519, 1403, 2106, 1583, 1520, 1404, 2108, 1584, 
        1732, 1908, 2107, 1731, 1720, 1734, 874, 1733, 1722, 1825, 2167, 1521,
         1735, 1724, 2006, 1522, 1405, 2007, 1523, 1406, 2008, 1524, 1407, 
        2109, 1585, 1525, 1408},
        VertexColors->None], 
       Line3DBox[{1409, 1870, 1586, 1738, 1909, 2110, 1737, 1587, 1740, 1910, 
        2111, 1739, 1730, 2009, 1526, 1410, 2010, 1527, 1411, 2011, 1528, 
        1412, 2112, 1588, 1529, 1413, 2113, 1589, 1742, 1842, 1843, 1741, 
        2141, 1851, 1590, 1744, 1911, 2114, 1743, 1591, 1746, 1912, 2115, 
        1745, 1736, 886, 1414, 2012, 1530, 1415, 2013, 1531, 1416, 2116, 1592,
         1532, 1417, 2117, 1593, 1747, 1861, 1862, 1860},
        VertexColors->None], 
       Line3DBox[{1418, 1871, 1594, 1749, 1844, 2118, 1968, 1748, 1595, 1913, 
        2119, 1419, 1914, 2054, 1420, 2014, 1533, 1421, 2015, 1534, 1422, 
        2120, 1596, 1752, 1535, 1751, 1973, 2178, 1597, 1755, 1845, 1846, 
        1754, 1290, 1598, 1758, 1847, 2121, 1969, 1757, 1599, 1915, 2122, 
        1423, 1916, 2055, 1424, 897, 1425, 2016, 1536, 1426, 2123, 1600, 1761,
         1537, 1760, 1974, 2179, 1601, 1763, 1864, 1865, 1863},
        VertexColors->None], 
       Line3DBox[{1440, 1873, 1617, 1764, 1616, 2131, 1439, 1615, 1762, 1614, 
        2130, 1438, 1770, 1181, 1437, 2059, 1920, 1436, 2058, 1919, 1435, 
        2129, 1613, 1612, 1434, 2128, 1611, 1759, 1610, 1853, 2180, 1433, 
        1852, 1609, 1756, 1608, 2127, 1432, 1607, 1753, 1606, 2126, 1431, 
        1766, 1765, 2142, 1430, 2057, 1918, 1429, 2056, 1917, 1428, 2125, 
        1605, 1604, 1427, 2124, 1603, 1750, 1602, 1875, 1872},
        VertexColors->None], 
       Line3DBox[{1442, 1618, 1619, 2132, 1441, 1921, 2060, 1443, 1922, 2061, 
        1444, 1774, 2062, 1956, 1445, 1954, 2168, 1826, 1767, 1446, 1177, 
        1827, 1768, 1447, 2133, 1620, 1769, 1621, 1448, 2135, 1622, 1623, 
        2134, 1449, 1923, 2063, 1450, 1924, 2064, 1451, 1778, 2065, 1960, 
        1452, 1955, 2169, 1828, 1771, 1453, 1187, 1829, 1772, 1454, 2136, 
        1624, 1773, 1625, 1455},
        VertexColors->None], 
       Line3DBox[{1469, 1787, 1223, 1468, 1781, 1835, 2173, 1963, 1467, 1780, 
        1834, 2172, 1962, 1466, 1961, 2072, 1833, 1779, 1465, 1965, 2071, 
        1786, 1464, 2070, 1927, 1463, 2069, 1926, 2017, 1462, 919, 1461, 1777,
         1832, 2171, 1959, 1460, 1776, 1831, 2170, 1958, 1459, 1957, 2068, 
        1830, 1775, 1458, 1964, 2067, 1785, 1457, 2066, 1925, 1456, 2143, 
        1783, 1782, 1784},
        VertexColors->None]}}},
    VertexColors->CompressedData["
1:eJzsvXlUz1HXNo4iEUUJERElhRTJeJBKIUNmopQmoUiDVIhMoUimzEqJRCSS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     "],
    VertexNormals->CompressedData["
1:eJytvXlcztsTOG4n2XdZs0WWshRRz3FRFKHIlrJk36MolyylrKksWRJlKWTL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     "]], {}},
  Axes->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImagePadding->Automatic,
  Lighting->"Neutral",
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}},
  PlotInteractivity:>True,
  PlotRange->{{-3.1415922047908427`, 
   3.1415922047908427`}, {-3.1415922047908427`, 
   3.1415922047908427`}, {-0.9999999999999748, 0.9999999999999748}},
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.967201597197962*^9, 3.9672016279694214`*^9, 
  3.9672016880064945`*^9, 3.9672017204050083`*^9, 3.967276192185958*^9},
 CellLabel->"Out[96]=",ExpressionUUID->"22de3632-74d9-4821-b93a-a4835f49e0ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"color=\"", "\"gray\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "59"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"center\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"mapacolor=\"", "\"winter\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.2923071218242029`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.15868307510461366`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"puntossuperimpli=\"", "12042"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"$f(u,v)=\\\\sin u \\\\cdot \\\\cos v$\"", ",", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"lime\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\huge\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"south east\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "2.6949675550341556`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{3.967201597197962*^9, 3.9672016279694214`*^9, 
  3.9672016880064945`*^9, 3.9672017204050083`*^9, 3.967276192191629*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"cfe596e8-e13b-4bb5-81ce-c95520582d1f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9672015978856564`*^9, 3.9672016292098007`*^9, 
  3.967201688406931*^9, 3.967201720955015*^9, 3.967276192842216*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[96]:=",ExpressionUUID->"8c1f45fe-1530-4b40-8fb9-b2e2d1564fea"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.9672015978856564`*^9, 3.9672016292098007`*^9, 
  3.967201688406931*^9, 3.967201720955015*^9, 3.967276192843237*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[96]:=",ExpressionUUID->"2231cab9-dc90-4f3e-b1bb-828bad7831dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9672015978856564`*^9, 3.9672016292098007`*^9, 
  3.967201688406931*^9, 3.967201720955015*^9, 3.967276192843937*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[96]:=",ExpressionUUID->"253ce271-3213-484d-a9bf-a07c9f18d8f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9672015978856564`*^9, 3.9672016292098007`*^9, 
  3.967201688406931*^9, 3.967201720955015*^9, 3.967276192844372*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[96]:=",ExpressionUUID->"cb023347-1751-4cdd-8276-c387f0007ccc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.9672015978856564`*^9, 3.9672016292098007`*^9, 
  3.967201688406931*^9, 3.967201720955015*^9, 3.967276192844798*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[96]:=",ExpressionUUID->"44782391-3725-4688-961f-78190ecaa041"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.9672015978856564`*^9, 3.9672016292098007`*^9, 
  3.967201688406931*^9, 3.967201720955015*^9, 3.967276192890655*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[96]:=",ExpressionUUID->"55126bc3-2b50-4c2f-8b36-489600570316"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.9672015978856564`*^9, 3.9672016292098007`*^9, 
  3.967201688406931*^9, 3.967201720955015*^9, 3.967276193896461*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[96]:=",ExpressionUUID->"5c63b61f-465f-4625-8c1e-615532d85fbc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D5/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D5/"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9672015978856564`*^9, 3.9672016292098007`*^9, 
  3.967201688406931*^9, 3.967201720955015*^9, 3.9672761938994827`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[96]:=",ExpressionUUID->"a0083259-cb2a-470c-ac57-7a8f9a475748"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafica3D5\"\>"}],
  SequenceForm["Archivo: ", "grafica3D5"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9672015978856564`*^9, 3.9672016292098007`*^9, 
  3.967201688406931*^9, 3.967201720955015*^9, 3.967276193900999*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[96]:=",ExpressionUUID->"fd3428be-a845-442e-b1bc-a09291786972"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.9672015978856564`*^9, 3.9672016292098007`*^9, 
  3.967201688406931*^9, 3.967201720955015*^9, 3.9672761990147963`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[96]:=",ExpressionUUID->"a998b5ca-d652-43d2-bbf9-b9d9910ca8cb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D5/grafica3D5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D5/grafica3D5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.9672015978856564`*^9, 3.9672016292098007`*^9, 
  3.967201688406931*^9, 3.967201720955015*^9, 3.967276199015704*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[96]:=",ExpressionUUID->"971c028c-da08-4aad-8152-ac7321044ee8"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafica3D5/\
grafica3D5.pdf\"\>"], "Output",
 CellChangeTimes->{3.967201597197962*^9, 3.9672016279694214`*^9, 
  3.9672016880064945`*^9, 3.9672017204050083`*^9, 3.967276199028677*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"ba3d05d9-b9ab-41ea-ac77-82b43fa79266"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 6", "Subsection",
 CellChangeTimes->{{3.967118818547166*^9, 3.967118820248961*^9}, 
   3.967118852011038*^9, 
   3.967122120950706*^9},ExpressionUUID->"5de8add7-281f-4318-bdbf-\
acc99d1502f9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "u", "]"}], " ", 
       RowBox[{"Sin", "[", "v", "]"}]}], ",", 
      RowBox[{
       RowBox[{"Sin", "[", "u", "]"}], " ", 
       RowBox[{"Sin", "[", "v", "]"}]}], ",", 
      RowBox[{"Cos", "[", "v", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "0", ",", 
      RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "0", ",", "Pi"}], "}"}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"Opacity", "[", "0.7", "]"}]}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"ColorData", "[", "\"\<Gradients\>\"", "]"}], "]"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<color=\>\"", ",", 
      RowBox[{"color", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
          ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
          ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"",
           ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"",
           ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
          ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<white\>\"", 
          ",", "\"\<yellow\>\"", ",", "\"\<blue!50!red\>\"", 
          ",", "\"\<green!70!black\>\"", ",", "\"\<red!20!blue!80!green\>\"", 
          ",", "\"\<yellow!75!red\>\""}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"10", ",", "60"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<mapacolor=\>\"", ",", 
      RowBox[{"mapacolor", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<viridis\>\"", ",", "\"\<cool\>\"", ",", "\"\<hot\>\"", 
          ",", "\"\<jet\>\"", ",", "\"\<hsv\>\"", ",", "\"\<spring\>\"", 
          ",", "\"\<summer\>\"", ",", "\"\<autumn\>\"", ",", "\"\<winter\>\"",
           ",", "\"\<gray\>\"", ",", "\"\<blackwhite\>\""}], "}"}], "]"}]}]}],
      "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.2", ",", "1"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<puntossuperimpli=\>\"", ",", 
      RowBox[{"puntossuperimpli", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"8000", ",", "13000"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Superficie param\[EAcute]trica\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<color\>\"", ",", 
              RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
         "}"}], "}"}]}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExportToTikZ3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", "u", "]"}], " ", 
          RowBox[{"Sin", "[", "v", "]"}]}], ",", 
         RowBox[{
          RowBox[{"Sin", "[", "u", "]"}], " ", 
          RowBox[{"Sin", "[", "v", "]"}]}], ",", 
         RowBox[{"Cos", "[", "v", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "0", ",", 
         RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "0", ",", "Pi"}], "}"}]}], "}"}], 
     ",", "\"\<grafica3D6.tex\>\"", ",", "grid", ",", "color", ",", 
     "resolucion", ",", "estiloejes", ",", "mapacolor", ",", "opacidad", ",", 
     "extensionejes", ",", "puntossuperimpli", ",", "texto"}], "]"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967119170116107*^9, 3.967119194175668*^9}, 
   3.967122124822287*^9, {3.967192724585396*^9, 3.96719272499255*^9}, {
   3.967193890246874*^9, 3.967193890674347*^9}, {3.9671953591728134`*^9, 
   3.9671953598097095`*^9}, {3.96719546038151*^9, 3.9671954676151047`*^9}, 
   3.9671959900275784`*^9, 3.9671965498124943`*^9, 3.967198823783949*^9, 
   3.967200149234749*^9, {3.967201766472784*^9, 3.967201791647831*^9}, {
   3.9672018362841797`*^9, 3.9672018381919403`*^9}, {3.967276254407113*^9, 
   3.967276267968048*^9}},
 CellLabel->
  "In[101]:=",ExpressionUUID->"201596fc-b3ed-4ef2-9dd1-b3ac1f1d9c31"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyFnXVYVcvXx7Gv3XENbMXCVhRkY2BgFxYWKmVfE7CxWwwsFOxuxWSQsAME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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[2], Opacity[
       0.7], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxFnHf8l+P3x+9935pCScjKKqMSGmhoUSIqEUpWiJYWSUYyElIZKaVhZ2Xv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            "]], Polygon3DBox[CompressedData["
1:eJwtmwf8V9Mbx+889yuirJQiRcPKVhRKhYiGCJGGNBAtCimVhjIiKhnZu5JV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            "]], Polygon3DBox[CompressedData["
1:eJwt1nmwj1Ucx/Hf9bj3d8muTauliBJtWigpIk2SYopMk8kue1m7zLSShlIu
RUxRtEch4dJCRWUnVPalUApZUr2+8/jjM/d83ufzPec8zz3nPL8qHXq16lks
k8kMp1xalpfJXJ7NZJqCLYB+xTOZfGwH9mOSyQyiBXIlsV3YJn4IFWGrsJ+x
b/j2NBlbjm3CvuJbUyFWAtuJbeQH00JsobluwyfxJagWtpL/Se5r/gF6DSvE
xlET7WrYedY3kB9AiXYF7Gp9R413VG0zbBvNzLEO7FfsAn4pFWL38q3pYX33
UEW1a43VkaZqP2S8p2T/1ve33G3aW+kjtQexQ1hDfjO9E3Ooa07z1O3EPsG2
ye2Xq8l/T5Ow+/m2FC//Af2daJ26TjTNvB3UPxPj8nfQZ/wufrbaP2T/Unsj
v4nexrZi+7Aa/Hc0EZvPr6BRao+ZpzetltuDVZRZRKPliuVnMl/G/0P/G/pb
UYJ9hW3GpvGtaal1bMQ+N95dNNo6i8stx36Ve1/mQVoi1zYv7W8h1808K/gO
een/sB1WgP3APxT/c6wtNhTrZKxGWG2sVNQabww2muZjA7EnsBb8zXKXYadh
HbBGWH3s4lgXdh92K9YAqx77G2uHTcRKW/ez2lPN2cM7+F37z6jnN9KMeM/q
2tGX6o5j32KnqRsm11l7CjZY3bL4X8i9KPduvF/vopxcA3yHecdhhdRLpmec
L6y07D80R6Z2XrrvDqmbEHuQL6l+gPZA+lrfELnBtFT7UewxmiE3ne7B6hqr
jvX04XtTHawMdpK28S1pgfY+mfnWnm/8CnnpeFvxPrmpL4H30+6fm/bt9fd3
816pbg1NVdtPri/V1V9W7b9USl0l7HtsR+xdddv5u2khv1/tArV7+Ta0GPsL
+wLrbvxu9InaPngPtcNlhtG12JlxJ8gW8I9TPewMLB8byY+gG7FzsXLYKP45
ugk7DyuPncOXscYRxh5JP+gbig2ha7RPl8vKlZWZHufSuqbFWLIvy7xEjeWq
yp1bPD0v18Ue51/PTc9Olt+Ob0jSfRr7tQzWLe5Fvjd9jI2UGUEF6gacyt3M
55q7I3YQ2409q+6ZWHesH2uAPc0/RaWwSlh9bBI/kSpjNbDm2Bzj3BJ3JV+M
qmFv8W/G2ZKrk6T7Zm6cEayQT+gi7HprWUnP8/95rguxT+Uay41P0rMVZ2xK
7AG55jI1o7Z4+g660Hq+K70nNznOPVXVfwl2B9ZU3Wp6Id471cBekBlDZ8lV
xm7F5pm3CTYhSc9vnOMc/pdYY5Lul9g3CbYNW8P3p7lYMWxrzMP3i7OGZbAt
2Cq+L80OhHWmdXyXOMPYYH4Q5VpLxSTdI0/yT8TZxM7GbsAe4x+lHKw8dhU2
Nu4CqoRVSdJ9s9hz3I5NSdJ7Le63IqxpvBu+JF2KLcKaYZOT9F6L+6003zW+
hXwvmoU1iWegMXzeqfcyS+1a7KUkPftxBxznf1I7x37eYz2t6L+4r+Neww7H
nUv/ZtOzGefxEP8wHcum35/45uzmW9If2AHzTMc28NfTwWx6f8ad+SN/Ax3A
9mBvYKv5K6gXlrXHe8cdHHPoO4H9bI65cTdg99IsbGY8m1yB5/jCcxzmD/Mf
yP0i05iOYEewD7EtfBP6mF+Dj03SOzbu2n/iHo57SO6ATDv6LZt+M+M7uZyv
HvcivwGfmKR3Ttw9n2HrsVeT9M6pd2pPrsNeSdJ7I/ZGj9hD2Ehnobv+E3iO
Zz2CrzBHTtzl5qgl82HcYdp3Yg3lr43fVlSkpln8TsL2xvdY/zi1S2TPp5PY
TrVF8b3i29PubPpNj+94Ufz+oTzzXhDn3Dg99T0SP+ywg9iyeOfxv4jfCfxm
9UvM2YbGi/0PpUdSCg==
            "]]},
          Annotation[#, "Charting`Private`Tag$68863#1"]& ]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, {{}, {}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{757, 1006, 1313, 1007, 2065, 1380, 1363, 1361, 1443, 1362, 
        2067, 770, 918, 2072, 784, 1023, 1203, 1024, 798, 2104, 1043, 1216, 
        1044, 812, 2109, 1063, 1229, 1064, 1323, 2170, 1083, 1242, 1084, 1330,
         1103, 1255, 1104, 2080, 1337, 1123, 1268, 1124, 2086, 843, 1143, 
        1281, 1144, 2091, 856, 1163, 1294, 1164, 870, 2121, 980, 884, 2127, 
        1395, 1396, 1397, 1398, 2190, 1182, 1347, 1183, 1304},
        VertexColors->None], 
       Line3DBox[{758, 1008, 1314, 1009, 1381, 2184, 1366, 1364, 1445, 1365, 
        2068, 771, 919, 2073, 785, 1025, 2132, 1204, 1026, 799, 1045, 1217, 
        1046, 813, 2110, 1065, 1230, 1066, 1324, 2171, 1085, 1243, 1086, 1331,
         1105, 1256, 1106, 2081, 1338, 1125, 1269, 1126, 2087, 844, 1145, 
        1282, 1146, 857, 1165, 1295, 1166, 871, 981, 885, 2128, 1399, 1400, 
        1401, 2191, 1402, 1184, 1348, 1185, 1305},
        VertexColors->None], 
       Line3DBox[{759, 1010, 1315, 641, 2185, 1369, 1367, 1446, 2202, 1368, 
        772, 920, 2074, 786, 1027, 2133, 1205, 1028, 800, 1047, 2138, 1218, 
        1048, 814, 1067, 1231, 1068, 1325, 2172, 1087, 1244, 1088, 1332, 1107,
         1257, 1108, 2082, 1339, 1127, 1270, 1128, 845, 1147, 1283, 2164, 
        1148, 858, 1167, 1296, 1168, 872, 982, 2093, 886, 1403, 1404, 1405, 
        2192, 679, 1349, 1186, 1306},
        VertexColors->None], 
       Line3DBox[{760, 1011, 1316, 1383, 2168, 1382, 1372, 1370, 1447, 2203, 
        1371, 773, 921, 2075, 787, 1029, 2134, 1206, 1030, 801, 1049, 2139, 
        1219, 1050, 815, 1069, 2142, 1232, 1070, 1326, 1089, 1245, 1090, 1333,
         1109, 1258, 1110, 1340, 1129, 1271, 2162, 1130, 846, 1149, 1284, 
        2165, 1150, 859, 1169, 1297, 1170, 873, 983, 2094, 887, 1406, 2193, 
        1407, 1408, 1409, 1410, 1350, 1187, 1307},
        VertexColors->None], 
       Line3DBox[{8, 508, 1799, 23, 738, 1992, 38, 1466, 53, 1481, 390, 68, 
        1495, 403, 83, 1509, 416, 98, 1523, 429, 113, 442, 1760, 128, 455, 
        1773, 143, 468, 1786, 158, 481, 173, 1543, 188, 1558, 203, 1572, 563, 
        218},
        VertexColors->None], 
       Line3DBox[{380, 237, 1868, 630, 629, 2070, 777, 925, 2076, 791, 2102, 
        252, 805, 2106, 266, 819, 2112, 280, 525, 1816, 294, 539, 308, 1830, 
        553, 322, 2089, 850, 336, 2092, 863, 350, 877, 2125, 987, 891, 2130, 
        697, 698, 1954, 365, 498},
        VertexColors->None], 
       Line3DBox[{764, 1015, 1320, 1016, 1384, 1376, 1374, 1454, 1375, 2071, 
        778, 926, 2077, 792, 1034, 2135, 1210, 1035, 806, 2107, 1054, 1223, 
        1055, 820, 2113, 1074, 1236, 1075, 1327, 2173, 1094, 1249, 1095, 1334,
         1114, 1262, 1115, 2083, 1341, 1134, 1275, 1135, 2090, 851, 1154, 
        1288, 1155, 864, 1174, 1301, 1175, 878, 988, 892, 2131, 1417, 1418, 
        1419, 2197, 1420, 1189, 1354, 1190, 1308},
        VertexColors->None], 
       Line3DBox[{765, 1017, 1321, 648, 2186, 1379, 1377, 1455, 2204, 1378, 
        779, 927, 2078, 793, 1036, 2136, 1211, 1037, 807, 1056, 2140, 1224, 
        1057, 821, 1076, 1237, 1077, 1328, 2174, 1096, 1250, 1097, 1335, 1116,
         1263, 1117, 2084, 1342, 1136, 1276, 1137, 852, 1156, 1289, 2166, 
        1157, 865, 1176, 1302, 1177, 879, 989, 2095, 893, 1421, 1422, 1423, 
        2198, 707, 1355, 1191, 1309},
        VertexColors->None], 
       Line3DBox[{766, 1018, 1322, 2169, 1019, 1387, 1385, 1456, 2205, 1386, 
        780, 928, 2079, 794, 1038, 2137, 1212, 1039, 808, 1058, 2141, 1225, 
        1059, 1357, 1078, 2143, 1238, 1079, 1329, 1098, 1251, 1099, 1336, 
        1118, 1264, 1119, 1343, 1138, 1277, 2163, 1139, 1358, 1158, 1290, 
        2167, 1159, 866, 1178, 1303, 1179, 880, 990, 2096, 894, 1424, 2199, 
        1425, 1426, 1427, 1428, 1356, 1192, 1193},
        VertexColors->None], 
       Line3DBox[{901, 997, 1344, 1390, 1389, 2188, 895, 991, 2187, 1388, 881,
         977, 2118, 867, 971, 1291, 1160, 853, 965, 2146, 1278, 1140, 840, 
        959, 2144, 1265, 1120, 834, 953, 1252, 1100, 828, 947, 1239, 1080, 
        822, 941, 1226, 2160, 1060, 809, 935, 1213, 2156, 1040, 795, 929, 
        1200, 2150, 1020, 781, 915, 2097, 767, 909, 2179, 1437, 1439, 1438, 
        754, 907, 1429, 1310, 1003, 1194},
        VertexColors->None], 
       Line3DBox[{902, 998, 1345, 1180, 1392, 2189, 896, 992, 1391, 882, 978, 
        2119, 868, 972, 1292, 1161, 854, 966, 2147, 1279, 1141, 841, 960, 
        1266, 1121, 835, 2175, 954, 1253, 1101, 829, 948, 1240, 1081, 2114, 
        823, 942, 1227, 1061, 810, 936, 1214, 2157, 1041, 796, 930, 1201, 
        2151, 1021, 782, 916, 2098, 768, 910, 1440, 1359, 1441, 755, 2180, 
        1431, 1430, 1311, 1004, 1195},
        VertexColors->None], 
       Line3DBox[{903, 999, 1346, 1181, 1394, 897, 993, 1393, 2126, 883, 979, 
        2120, 869, 973, 1293, 1162, 855, 967, 1280, 1142, 842, 2085, 961, 
        1267, 1122, 836, 2176, 955, 1254, 1102, 830, 949, 1241, 1082, 2115, 
        824, 943, 1228, 1062, 2108, 811, 937, 1215, 1042, 2103, 797, 931, 
        1202, 2152, 1022, 783, 917, 769, 2066, 911, 1442, 1360, 1444, 756, 
        1433, 2200, 1432, 1312, 1005, 1196},
        VertexColors->None], 
       Line3DBox[{904, 1000, 1351, 1413, 1412, 898, 994, 2194, 1411, 888, 984,
         2122, 874, 974, 1298, 1171, 860, 968, 2148, 1285, 1151, 847, 962, 
        2145, 1272, 1131, 837, 956, 1259, 1111, 831, 950, 1246, 1091, 825, 
        944, 1233, 2161, 1071, 816, 938, 1220, 2158, 1051, 802, 932, 1207, 
        2153, 1031, 788, 922, 2099, 774, 912, 2181, 1448, 1450, 1449, 761, 
        908, 2201, 1434, 1317, 1012, 1197},
        VertexColors->None], 
       Line3DBox[{905, 1001, 1352, 692, 2195, 899, 995, 1414, 889, 985, 2123, 
        875, 975, 1299, 1172, 861, 969, 2149, 1286, 1152, 848, 963, 1273, 
        1132, 838, 2177, 957, 1260, 1112, 832, 951, 1247, 1092, 2116, 826, 
        945, 1234, 1072, 817, 939, 1221, 2159, 1052, 803, 933, 1208, 2154, 
        1032, 789, 923, 2100, 775, 913, 2182, 1451, 743, 762, 2183, 720, 1318,
         1013, 1198},
        VertexColors->None], 
       Line3DBox[{906, 1002, 1353, 1188, 1416, 2196, 900, 996, 1415, 2129, 
        890, 986, 2124, 876, 976, 1300, 1173, 862, 970, 1287, 1153, 849, 2088,
         964, 1274, 1133, 839, 2178, 958, 1261, 1113, 833, 952, 1248, 1093, 
        2117, 827, 946, 1235, 1073, 2111, 818, 940, 1222, 1053, 2105, 804, 
        934, 1209, 2155, 1033, 790, 924, 2101, 776, 2069, 914, 1452, 1373, 
        1453, 763, 1436, 1435, 1319, 1014, 1199},
        VertexColors->None]}, 
      {GrayLevel[0.2], Line3DBox[CompressedData["
1:eJwN0EdKAwEUBuAX4ySxgR4he3sFkShBRCRBjb3EEhUF21b3gu0CCl7Cjb3e
wCP5LT7+N/97M4vJ104rJ6mIqPKYRBxmIoazEU/cpiNScoZZRmjNRVzQ7q7O
c4U5Ctzpn2WHXVrOs0CbflS+0GlXLxe50ieMmV/pskvkEtf6ZVnkjW67jDzT
r8hVxnmnxy4r11hngg/+uHefk1U2mOSTS32v9xrMm2wxxYN/0KdvNG9To8QX
/fomucOBu7L8ZkDfLHe58d09Oc0Pg3Yt8lx/ZN43/zJkPuYf5nQk7w==
        "],
        VertexColors->None], 
       Line3DBox[{1458, 1849, 2001, 2179, 1986, 1851, 910, 1987, 1853, 2066, 
        1592, 1988, 2050, 2067, 1593, 1989, 2051, 2068, 1594, 1990, 2202, 
        1857, 1595, 1991, 2203, 1859, 1596, 1992, 1861, 2002, 2181, 1993, 
        1863, 2003, 2182, 1994, 1865, 2069, 1597, 1995, 1867, 2070, 1598, 
        1996, 2052, 2071, 1599, 1997, 2204, 1870, 1600, 1998, 2205, 1894, 
        1601, 1999},
        VertexColors->None], 
       Line3DBox[{1460, 2004, 2097, 1459, 2005, 2098, 1461, 917, 1462, 2072, 
        1602, 1463, 2073, 1603, 1464, 2074, 1604, 1465, 2075, 1605, 1466, 
        2006, 2099, 1467, 2007, 2100, 1468, 2008, 2101, 1469, 2076, 1606, 
        1470, 2077, 1607, 1471, 2078, 1608, 1472, 2079, 1609, 1473},
        VertexColors->None], 
       Line3DBox[{1475, 1646, 1647, 2150, 1474, 1648, 1649, 2151, 1476, 1650, 
        1651, 2152, 1477, 1023, 1652, 1478, 2132, 1653, 1654, 1479, 2133, 
        1655, 1656, 1480, 2134, 1657, 1658, 1481, 1659, 1660, 2153, 1482, 
        1661, 1662, 2154, 1483, 1663, 1664, 2155, 1484, 1665, 2102, 1666, 
        1485, 2135, 1667, 1668, 1486, 2136, 1669, 1670, 1487, 2137, 1671, 
        1672, 1488},
        VertexColors->None], 
       Line3DBox[{1502, 1695, 1694, 2141, 1501, 1693, 1692, 2140, 1500, 1691, 
        2107, 2026, 1499, 1690, 2106, 1689, 1498, 2025, 2105, 1688, 1497, 
        2159, 1687, 1686, 1496, 2158, 1685, 1684, 1495, 1683, 1682, 2139, 
        1494, 1681, 1680, 2138, 1493, 1679, 1045, 1492, 1678, 2104, 2024, 
        1491, 2023, 2103, 1677, 1490, 2157, 1676, 1675, 1489, 2156, 1674, 
        1673, 1839},
        VertexColors->None], 
       Line3DBox[{1516, 589, 1834, 1712, 2143, 1515, 1711, 1076, 1514, 1710, 
        2113, 2031, 1513, 1709, 2112, 1708, 1512, 2030, 2111, 1707, 1511, 
        1072, 1706, 1510, 2161, 1705, 1704, 1509, 1703, 1702, 2142, 1508, 
        1701, 1067, 1507, 1700, 2110, 2029, 1506, 1699, 2109, 2028, 1505, 
        2027, 2108, 1698, 1504, 1061, 1697, 1503, 2160, 1696, 1840, 652, 1841},
        VertexColors->None], 
       Line3DBox[{106, 529, 828, 107, 530, 829, 108, 531, 830, 109, 1330, 532,
         110, 1331, 533, 111, 1332, 534, 112, 1333, 535, 113, 536, 831, 114, 
        537, 832, 115, 538, 833, 116, 539, 117, 1334, 540, 118, 1335, 541, 
        119, 1336, 542, 120},
        VertexColors->None], 
       Line3DBox[{1530, 1843, 1844, 1819, 1098, 1529, 1725, 1818, 2174, 2040, 
        1528, 1724, 1817, 2173, 2039, 1527, 1723, 1816, 1722, 1526, 2038, 
        2117, 1815, 1721, 1525, 2037, 2116, 1814, 1720, 1524, 1091, 1813, 
        1719, 1523, 1718, 1812, 1089, 1522, 1717, 1811, 2172, 2036, 1521, 
        1716, 1810, 2171, 2035, 1520, 1715, 1809, 2170, 2034, 1519, 2033, 
        2115, 1808, 1714, 1518, 2032, 2114, 1807, 1713, 1517, 1080, 1806, 
        1897, 1896, 1842},
        VertexColors->None], 
       Line3DBox[{1531, 1845, 1846, 1820, 953, 1754, 1726, 1821, 2175, 1610, 
        1755, 1727, 1822, 2176, 1611, 1756, 2041, 2080, 1823, 1612, 1757, 
        2042, 2081, 1824, 1613, 1758, 2043, 2082, 1825, 1614, 1759, 1110, 
        1826, 1615, 1760, 1728, 1827, 956, 1761, 1729, 1828, 2177, 1616, 1762,
         1730, 1829, 2178, 1617, 1763, 1731, 1830, 1618, 1764, 2044, 2083, 
        1831, 1619, 1765, 2045, 2084, 1832, 1620, 1766, 1119, 1833, 1836, 
        1621, 1835},
        VertexColors->None], 
       Line3DBox[{1532, 656, 1847, 2009, 2144, 1767, 1732, 960, 1768, 1733, 
        2085, 1622, 1769, 2046, 2086, 1623, 1770, 2047, 2087, 1624, 1771, 
        1128, 1625, 1772, 2162, 1734, 1626, 1773, 1735, 2010, 2145, 1774, 
        1736, 963, 1775, 1737, 2088, 1627, 1776, 1738, 2089, 1628, 1777, 2048,
         2090, 1629, 1778, 1137, 1630, 1779, 2163, 1739, 1838, 636, 1837},
        VertexColors->None], 
       Line3DBox[{1533, 1740, 2011, 2146, 1780, 1741, 2012, 2147, 1781, 1742, 
        967, 1782, 2049, 2091, 1631, 1783, 1146, 1632, 1784, 2164, 1743, 1633,
         1785, 2165, 1744, 1634, 1786, 1745, 2013, 2148, 1787, 1746, 2014, 
        2149, 1788, 1747, 970, 1789, 1748, 2092, 1635, 1790, 1155, 1636, 1791,
         2166, 1749, 1637, 1792, 2167, 1750, 1638, 1848},
        VertexColors->None], 
       Line3DBox[{1534, 340, 1291, 475, 341, 1292, 476, 342, 1293, 477, 1294},
        
        VertexColors->None], 
       Line3DBox[{1535, 353, 1303, 487, 352, 1302, 486, 351, 1301, 485, 350, 
        484, 1300, 349, 483, 1299, 348, 482, 1298, 347, 481, 346, 1297, 480, 
        345, 1296, 479, 344, 1295, 478, 343},
        VertexColors->None], 
       Line3DBox[{1537, 2015, 2118, 1536, 2016, 2119, 1538, 2017, 2120, 1539, 
        2018, 2121, 1540, 981, 1541, 2093, 1639, 1542, 2094, 1640, 1543, 2019,
         2122, 1544, 2020, 2123, 1545, 2021, 2124, 1546, 2022, 2125, 1547, 
        988, 1548, 2095, 1641, 1549, 2096, 1642, 1550},
        VertexColors->None], 
       Line3DBox[{1552, 1898, 1899, 2187, 1551, 1902, 1391, 1553, 1907, 2126, 
        2056, 1554, 2057, 2127, 1912, 1555, 2058, 2128, 1918, 1556, 1403, 
        1923, 1557, 2193, 1929, 1930, 1558, 1935, 1936, 2194, 1559, 1941, 
        1414, 1560, 1947, 2129, 2060, 1561, 1952, 2130, 1953, 1562, 2062, 
        2131, 1959, 1563, 1421, 1964, 1564, 2199, 1970, 1971, 1565},
        VertexColors->None], Line3DBox[CompressedData["
1:eJwVztkuQ1EUBuDlQisR8QaoqejbuHblupTGEEWotEi0xhqjJDXEkBoSngVv
4zsXX/51/rWz98lMFyZnOyJiilwq4o+vdMQ3J50RE74/zJ+0eeesK+JNjtu9
yFee6NWf8mwes3uQj7S4546s/lY2nOvh2nxDk1G7y+Rd/VXyDhecM2JX8T8N
81FyhmOG9XW5zx41ys4N6XfMu1TY5tC9VTloV5ZbbNCtP2DTnLFbk+usJPfq
V2WJAbtlWXT/glxikX59UdadTVMwzzNHn11KV2PGd54f3S//q5Ywdg==
        "],
        VertexColors->None]}}},
    VertexColors->CompressedData["
1:eJztnHdUFfcSxwEVEBAkBhGl+QTzVAwKklgZbIFERAUbAgoqFopgARSxYUWx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     "],
    VertexNormals->CompressedData["
1:eJx0fXVclUvXNirGUew+dmNgYBdjYyDY3aigYnei2GCjYgCKgYWFrcggoYik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     "]], {}},
  Axes->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImagePadding->Automatic,
  Lighting->"Neutral",
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}},
  PlotInteractivity:>True,
  PlotRange->{{-1., 0.9999999999998993}, {-0.9999999999999748, 
   0.9999999999999748}, {-0.9999999999999748, 0.9999999999999748}},
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9672017958985767`*^9, 3.9672018415801983`*^9}, 
   3.9672762898255787`*^9},
 CellLabel->
  "Out[101]=",ExpressionUUID->"88d00c85-e825-49aa-97ff-9cf770f73c32"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"color=\"", "\"gray\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "12"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"center\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"mapacolor=\"", "\"gray\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.6175305205066512`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.3187882868473785`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"puntossuperimpli=\"", "11269"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Superficie param\[EAcute]trica\"", ",", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"orange\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\Huge\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"east\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "46.60368651743501`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.9672017958985767`*^9, 3.9672018415801983`*^9}, 
   3.967276289830991*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"b2612aec-22ce-4a96-8be1-e030413bf72c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672017970755863`*^9, 3.967201842894451*^9}, 
   3.967276289880661*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"4264c4f4-202d-4ad1-9983-4f185c215a86"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9672017970755863`*^9, 3.967201842894451*^9}, 
   3.967276289881482*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"c9ea9242-a78e-483d-baf2-8fe85c44f297"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672017970755863`*^9, 3.967201842894451*^9}, 
   3.967276289882124*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"1450838c-729d-408c-8557-1233d07e912e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672017970755863`*^9, 3.967201842894451*^9}, 
   3.967276289882531*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"b385c8b5-175a-4b56-81f0-76e51464923b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672017970755863`*^9, 3.967201842894451*^9}, 
   3.9672762898829117`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"7c1917cb-0884-4f8d-a328-87ffddbee672"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9672017970755863`*^9, 3.967201842894451*^9}, 
   3.967276289937068*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"6e3b0aa4-ed50-425b-881f-d588fdc5fd5c"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9672017970755863`*^9, 3.967201842894451*^9}, 
   3.967276290944154*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"3e212215-4351-419d-a0a6-919f653df690"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D6/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D6/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672017970755863`*^9, 3.967201842894451*^9}, 
   3.967276290949337*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"7e71a9b5-e775-4da9-a029-3e43c258a2cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafica3D6\"\>"}],
  SequenceForm["Archivo: ", "grafica3D6"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672017970755863`*^9, 3.967201842894451*^9}, 
   3.967276290951544*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"5c31cba1-9a93-48fb-b208-219fb46c8efd"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9672017970755863`*^9, 3.967201842894451*^9}, 
   3.967276291780629*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"bfaabc11-8b8b-4420-aade-0d794f6d21ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D6/grafica3D6.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D6/grafica3D6.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672017970755863`*^9, 3.967201842894451*^9}, 
   3.967276291781495*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[101]:=",ExpressionUUID->"909fdc36-6c46-45f3-a645-ff38bc958f38"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafica3D6/\
grafica3D6.pdf\"\>"], "Output",
 CellChangeTimes->{{3.9672017958985767`*^9, 3.9672018415801983`*^9}, 
   3.967276291793779*^9},
 CellLabel->
  "Out[105]=",ExpressionUUID->"c22915b5-bf21-459e-ad61-6abd30c215f7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 7", "Subsection",
 CellChangeTimes->{{3.967118818547166*^9, 3.967118820248961*^9}, 
   3.967118853795833*^9, 
   3.9671221273673897`*^9},ExpressionUUID->"24dc9773-2fb5-4760-87eb-\
f544db7c86f8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], ",", 
      RowBox[{"Sin", "[", "t", "]"}], ",", 
      RowBox[{"t", "/", "4"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"8", "*", "Pi"}]}], "}"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<color=\>\"", ",", 
      RowBox[{"color", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
          ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
          ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"",
           ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"",
           ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
          ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<white\>\"", 
          ",", "\"\<yellow\>\"", ",", "\"\<blue!50!red\>\"", 
          ",", "\"\<green!70!black\>\"", ",", "\"\<red!20!blue!80!green\>\"", 
          ",", "\"\<yellow!75!red\>\""}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"10", ",", "60"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<mapacolor=\>\"", ",", 
      RowBox[{"mapacolor", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<viridis\>\"", ",", "\"\<cool\>\"", ",", "\"\<hot\>\"", 
          ",", "\"\<jet\>\"", ",", "\"\<hsv\>\"", ",", "\"\<spring\>\"", 
          ",", "\"\<summer\>\"", ",", "\"\<autumn\>\"", ",", "\"\<winter\>\"",
           ",", "\"\<gray\>\"", ",", "\"\<blackwhite\>\""}], "}"}], "]"}]}]}],
      "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.2", ",", "1"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<puntossuperimpli=\>\"", ",", 
      RowBox[{"puntossuperimpli", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"8000", ",", "13000"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Curva param\[EAcute]trica\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<color\>\"", ",", 
              RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
         "}"}], "}"}]}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "t", "]"}], ",", 
        RowBox[{"Sin", "[", "t", "]"}], ",", 
        RowBox[{"t", "/", "4"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"8", "*", "Pi"}]}], "}"}]}], "}"}], 
    ",", "\"\<grafica3D7.tex\>\"", ",", "grid", ",", "color", ",", 
    "resolucion", ",", "estiloejes", ",", "mapacolor", ",", "opacidad", ",", 
    "extensionejes", ",", "puntossuperimpli", ",", "texto"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9671192046936197`*^9, 3.967119210769261*^9}, 
   3.967122130710066*^9, {3.9671953626667194`*^9, 3.967195363304182*^9}, {
   3.967195432681284*^9, 3.967195439340292*^9}, 3.9671960012459736`*^9, 
   3.967196553404043*^9, 3.967198828841753*^9, 3.9672001543885574`*^9, {
   3.967201891900154*^9, 3.9672018957234*^9}, {3.9672763365377007`*^9, 
   3.967276347379318*^9}, 3.970591241852232*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"f793dea3-83b8-4a1b-9129-50b123bdf334"],

Cell[BoxData[
 Graphics3DBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
      Line3DBox[CompressedData["
1:eJwUmgVUVU0XhumuS6lggSKKhGLQ7BELFQsERUJART8alAYBUcAmLJCSllBC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       "]]},
     Annotation[#, "Charting`Private`Tag$15803#1"]& ]}, {}},
  Axes->True,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImagePadding->Automatic,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}},
  PlotInteractivity:>True,
  PlotRange->{{-0.9999986633107022, 0.9999999999998684}, {-0.9999968914310025,
    0.9999975297451876}, {0., 6.283185178951315}},
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9672019029554424`*^9, 3.9672019175895576`*^9}, 
   3.967276360439877*^9, 3.970591298546074*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"f527e8f8-1259-4e43-8bdb-a78015a9947f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"color=\"", "\"teal\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"resolucion=\"", "22"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estiloejes=\"", "\"center\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"mapacolor=\"", "\"autumn\""},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.5984027671453603`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"extensionejes=\"", "0.2092659339241801`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"puntossuperimpli=\"", "10634"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Curva param\[EAcute]trica\"", ",", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"olive\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\Large\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"north\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "57.89226093094905`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.9672019029554424`*^9, 3.9672019175895576`*^9}, 
   3.967276360439877*^9, 3.970591298548827*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"6f2e8dc9-254c-4e2d-a154-d2e6cc361656"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672019029682064`*^9, 3.9672019176674805`*^9}, 
   3.967276360470911*^9, 3.970591298571268*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"e15d4638-562b-46aa-b0dd-c4f174dcf9a2"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9672019029682064`*^9, 3.9672019176674805`*^9}, 
   3.967276360470911*^9, 3.970591298572057*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"6fb17d1f-9b8f-40dd-a228-96ea0c9f6960"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672019029682064`*^9, 3.9672019176674805`*^9}, 
   3.967276360470911*^9, 3.970591298572795*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"f4a8c36d-e48e-4b22-912f-1803b754e14f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672019029682064`*^9, 3.9672019176674805`*^9}, 
   3.967276360470911*^9, 3.9705912985732307`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"c461dc89-cf67-4307-a20f-4d490b752b10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672019029682064`*^9, 3.9672019176674805`*^9}, 
   3.967276360470911*^9, 3.970591298573657*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"54c99d11-a5af-4f17-b27c-3d037b421887"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9672019029682064`*^9, 3.9672019176674805`*^9}, 
   3.967276360470911*^9, 3.970591298994747*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"a82e9363-cae6-48e8-91fb-6303aa51c7c9"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9672019029682064`*^9, 3.9672019176674805`*^9}, 
   3.967276360470911*^9, 3.970591300001872*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"630adf43-dd27-48f3-bc5c-0a4ac1b1c5b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D7/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D7/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672019029682064`*^9, 3.9672019176674805`*^9}, 
   3.967276360470911*^9, 3.970591300007492*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"6b1b331c-b543-404f-83fd-a8213e8e9e7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafica3D7\"\>"}],
  SequenceForm["Archivo: ", "grafica3D7"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672019029682064`*^9, 3.9672019176674805`*^9}, 
   3.967276360470911*^9, 3.970591300010827*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"8ea89a43-7016-499e-b48b-25646ee1ff37"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9672019029682064`*^9, 3.9672019176674805`*^9}, 
   3.967276360470911*^9, 3.970591302267251*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"93eef97c-7c5b-4d9a-a8bd-df6da7f9dece"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafica3D7/grafica3D7.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafica3D7/grafica3D7.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9672019029682064`*^9, 3.9672019176674805`*^9}, 
   3.967276360470911*^9, 3.9705913022681847`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"286ceeaa-448d-490e-8445-102f6e601293"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafica3D7/\
grafica3D7.pdf\"\>"], "Output",
 CellChangeTimes->{{3.9672019029554424`*^9, 3.9672019175895576`*^9}, 
   3.967276360439877*^9, 3.970591302280875*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"7857aee7-e2a2-43e1-9a0e-9fde55632c25"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 8: hiperboloide de una hoja", "Subsection",
 CellChangeTimes->{{3.967118818547166*^9, 3.967118820248961*^9}, 
   3.9671188562563343`*^9, {3.967119229863778*^9, 3.967119236290948*^9}, 
   3.9671221339739227`*^9},ExpressionUUID->"f3ec5bec-d2b6-4314-b7d7-\
fe293f42791c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ContourPlot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "/", "4"}], "+", 
      RowBox[{
       RowBox[{"y", "^", "2"}], "/", "9"}]}], "==", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", "-", "9"}], ")"}], "^", "2"}], "/", "16"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "30"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "30"}], ",", "30"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", "30"}], ",", "40"}], "}"}], ",", 
    RowBox[{"ContourStyle", "->", 
     RowBox[{"Opacity", "[", "0.7", "]"}]}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"ColorData", "[", "\"\<Gradients\>\"", "]"}], "]"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"colortexto", "[", "]"}], ":=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
        ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
        ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"", 
        ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"", 
        ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
        ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<yellow\>\""}], 
       "}"}], "]"}]}], ",", 
    RowBox[{"sizetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
        ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
        ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
        ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
        ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"anclajetexto", "=", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
        ",", "\"\<west\>\"", ",", "\"\<north east\>\"", 
        ",", "\"\<north west\>\"", ",", "\"\<south east\>\"", 
        ",", "\"\<south west\>\"", ",", "\"\<center\>\""}], "}"}], "]"}]}], ",", 
    RowBox[{"rotatexto", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "360"}], "}"}], "]"}]}]}], "}"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<color=\>\"", ",", 
      RowBox[{"color", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<black\>\"", ",", "\"\<blue\>\"", ",", "\"\<brown\>\"", 
          ",", "\"\<cyan\>\"", ",", "\"\<darkgray\>\"", ",", "\"\<gray\>\"", 
          ",", "\"\<green\>\"", ",", "\"\<lightgray\>\"", ",", "\"\<lime\>\"",
           ",", "\"\<magenta\>\"", ",", "\"\<olive\>\"", ",", "\"\<orange\>\"",
           ",", "\"\<pink\>\"", ",", "\"\<purple\>\"", ",", "\"\<red\>\"", 
          ",", "\"\<teal\>\"", ",", "\"\<violet\>\"", ",", "\"\<white\>\"", 
          ",", "\"\<yellow\>\"", ",", "\"\<blue!50!red\>\"", 
          ",", "\"\<green!70!black\>\"", ",", "\"\<red!20!blue!80!green\>\"", 
          ",", "\"\<yellow!75!red\>\""}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<resolucion=\>\"", ",", 
      RowBox[{"resolucion", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"10", ",", "60"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estiloejes=\>\"", ",", 
      RowBox[{"estiloejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<box\>\"", ",", "\"\<center\>\"", ",", "\"\<none\>\""}], 
         "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<mapacolor=\>\"", ",", 
      RowBox[{"mapacolor", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<viridis\>\"", ",", "\"\<cool\>\"", ",", "\"\<hot\>\"", 
          ",", "\"\<jet\>\"", ",", "\"\<hsv\>\"", ",", "\"\<spring\>\"", 
          ",", "\"\<summer\>\"", ",", "\"\<autumn\>\"", ",", "\"\<winter\>\"",
           ",", "\"\<gray\>\"", ",", "\"\<blackwhite\>\""}], "}"}], "]"}]}]}],
      "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.2", ",", "1"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<extensionejes=\>\"", ",", 
      RowBox[{"extensionejes", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.1", ",", "0.4"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<puntossuperimpli=\>\"", ",", 
      RowBox[{"puntossuperimpli", "=", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{"8000", ",", "10000"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Hiperboloide de una hoja\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\"\<color\>\"", ",", 
              RowBox[{"colortexto", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<size\>\"", ",", "sizetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<anchor\>\"", ",", "anclajetexto"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"\"\<rotate\>\"", ",", "rotatexto"}], "}"}]}], "}"}]}], 
         "}"}], "}"}]}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "/", "4"}], "+", 
        RowBox[{
         RowBox[{"y", "^", "2"}], "/", "9"}]}], "==", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"z", "-", "9"}], ")"}], "^", "2"}], "/", "16"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "30"}], ",", "30"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "30"}], ",", "30"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "30"}], ",", "40"}], "}"}]}], "}"}], 
    ",", "\"\<grafica3D8.tex\>\"", ",", "grid", ",", "color", ",", 
    "resolucion", ",", "estiloejes", ",", "mapacolor", ",", "opacidad", ",", 
    "extensionejes", ",", "puntossuperimpli", ",", "texto"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967119223489449*^9, 3.967119224164021*^9}, {
   3.967119287345299*^9, 3.967119326348639*^9}, 3.9671221381664248`*^9, {
   3.967192739235794*^9, 3.967192739716385*^9}, {3.967192783855036*^9, 
   3.967192785101118*^9}, {3.9671938985181637`*^9, 3.9671938988797207`*^9}, {
   3.9671953670642815`*^9, 3.9671953677254047`*^9}, {3.9671954181445923`*^9, 
   3.9671954448152695`*^9}, 3.9671960096716537`*^9, 3.967196557416687*^9, 
   3.967198836023245*^9, 3.96720015941893*^9, {3.9672019438655834`*^9, 
   3.967201955631174*^9}, 3.9672020201425*^9, {3.967202161477421*^9, 
   3.9672022232038193`*^9}, {3.9672022578646545`*^9, 
   3.9672022764941635`*^9}, {3.967202308099209*^9, 3.9672023142044697`*^9}, {
   3.9672023605311546`*^9, 3.9672023800126457`*^9}, {3.9672024466317387`*^9, 
   3.9672024538368073`*^9}, 3.96720253854978*^9, 3.9672026000319386`*^9, {
   3.967276390741432*^9, 3.9672764050329514`*^9}, {3.9672764377885323`*^9, 
   3.967276469035281*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"41ef8cb0-9485-4813-8249-61d810efe6bd"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx0fXk4ls8Xtz1Ksm8h+77vu9vSJlmKFlvatVrSipRESqIiqRBttiIqSbmT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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.7], EdgeForm[None], 
       Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJw1mQWUVWUbhc9wL3duDENK19AhXRLS3d0dQw0hIAJDKo3S0iHd3YoKCP4C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